/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ProjectDiagnostics {
    private ProjectDiagnostics() {
    }

    public static void findAndReportStructureIssues(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectDiagnostics", "findAndReportStructureIssues"));
        }
        ArrayListMultimap modulesByPath = ArrayListMultimap.create();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
            File moduleDirPath = moduleFilePath.getParentFile();
            if (moduleDirPath == null) continue;
            modulesByPath.put((Object)moduleDirPath.getPath(), (Object)module);
        }
        Set modulePaths = modulesByPath.keySet();
        for (String modulePath : modulePaths) {
            DataNode<ProjectData> projectInfo;
            Collection modules = modulesByPath.get((Object)modulePath);
            int moduleCount = modules.size();
            if (moduleCount <= 1) continue;
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
            StringBuilder msg = new StringBuilder();
            msg.append("The modules ");
            int i = 0;
            HashSet moduleNames = Sets.newHashSet();
            for (Module module : modules) {
                if (i++ != 0) {
                    msg.append(", ");
                }
                String name = module.getName();
                moduleNames.add(name);
                msg.append("'").append(name).append("'");
            }
            msg.append(" point to same directory in the file system.");
            String[] lines = new String[]{msg.toString(), "Each module has to have a unique path."};
            Message message = new Message("Project structure issues", Message.Type.ERROR, lines);
            ArrayList modulesToDisplayInDialog = Lists.newArrayList();
            if (ProjectSubset.isSettingEnabled() && (projectInfo = GradleUtil.getCachedProjectData(project)) != null) {
                Collection cachedModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
                for (DataNode moduleNode : cachedModules) {
                    if (!moduleNames.contains(((ModuleData)moduleNode.getData()).getExternalName())) continue;
                    modulesToDisplayInDialog.add(moduleNode);
                }
            }
            if (modulesToDisplayInDialog.isEmpty()) {
                messages.add(message, new NotificationHyperlink[0]);
                continue;
            }
            messages.add(message, new AddOrRemoveModulesHyperlink());
        }
    }

    private static class AddOrRemoveModulesHyperlink
    extends NotificationHyperlink {
        AddOrRemoveModulesHyperlink() {
            super("add.or.remove.modules", "Configure Project Subset");
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectDiagnostics$AddOrRemoveModulesHyperlink", "execute"));
            }
            ProjectSubset subset = ProjectSubset.getInstance(project);
            subset.addOrRemoveModules();
        }
    }
}

