/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.testing;

import com.android.tools.idea.gradle.testing.TestArtifactSearchScopes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ScopeOptimizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestArtifactUseScopeOptimizer
implements ScopeOptimizer {
    @Nullable
    public GlobalSearchScope getScopeToExclude(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/testing/TestArtifactUseScopeOptimizer", "getScopeToExclude"));
        }
        VirtualFile file = TestArtifactUseScopeOptimizer.findVirtualFile(element);
        if (file == null) {
            return null;
        }
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(file, element.getProject());
        if (testScopes == null) {
            return null;
        }
        boolean inAndroidTest = testScopes.isAndroidTestSource(file);
        boolean inUnitTest = testScopes.isUnitTestSource(file);
        if (inAndroidTest && inUnitTest) {
            return null;
        }
        if (inAndroidTest) {
            return testScopes.getUnitTestSourceScope();
        }
        if (inUnitTest) {
            return testScopes.getAndroidTestSourceScope();
        }
        return null;
    }

    @Nullable
    private static VirtualFile findVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/testing/TestArtifactUseScopeOptimizer", "findVirtualFile"));
        }
        PsiFile psiFile = element.getContainingFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }
}

