/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.ui.ImageComponent;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PreviewIconsPanel
extends JPanel {
    private final Theme myTheme;
    private final Map<Density, ImageComponent> myIconImages;
    @Nullable
    private CategoryIconMap.Filter myFilter;
    private JPanel myRootPanel;
    private JPanel myIconsPanel;
    private JBLabel myTitleLabel;

    public PreviewIconsPanel(@NotNull String title, @NotNull Theme theme) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "<init>"));
        }
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "<init>"));
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myIconImages = Maps.newHashMap();
        this.add(this.myRootPanel);
        this.myTitleLabel.setText(title);
        this.myTitleLabel.setVisible(!title.isEmpty());
        this.myTheme = theme;
        this.myRootPanel.setBackground(this.myTheme.getMainColor());
        this.myRootPanel.setOpaque(this.myTheme != Theme.TRANSPARENT);
        this.myTitleLabel.setForeground(this.myTheme.getAltColor());
    }

    public PreviewIconsPanel(@NotNull String title, @NotNull Theme theme, @NotNull CategoryIconMap.Filter filter) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "<init>"));
        }
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "<init>"));
        }
        this(title, theme);
        this.myFilter = filter;
    }

    private static void updateImage(@NotNull ImageComponent imageComponent, @NotNull BufferedImage sourceImage) {
        if (imageComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageComponent", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "updateImage"));
        }
        if (sourceImage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceImage", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "updateImage"));
        }
        JBImageIcon icon = IconUtil.createImageIcon((BufferedImage)sourceImage);
        Dimension d = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        imageComponent.setPreferredSize(d);
        imageComponent.setMinimumSize(d);
        imageComponent.setIcon((Icon)icon);
    }

    public void updateImages(@NotNull CategoryIconMap categoryIconMap) {
        if (categoryIconMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryIconMap", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "updateImages"));
        }
        Map<Density, BufferedImage> densityImageMap = this.myFilter != null ? categoryIconMap.toDensityMap(this.myFilter) : categoryIconMap.toDensityMap();
        if (this.myIconsPanel.getComponentCount() == 0) {
            this.initializeIconComponents(densityImageMap.keySet());
        }
        for (Map.Entry<Density, BufferedImage> densityImageEntry : densityImageMap.entrySet()) {
            PreviewIconsPanel.updateImage(this.myIconImages.get(densityImageEntry.getKey()), densityImageEntry.getValue());
        }
    }

    private void initializeIconComponents(@NotNull Collection<Density> densities) {
        if (densities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "densities", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel", "initializeIconComponents"));
        }
        Ordering<Density> densityOrdering = new Ordering<Density>(){

            public int compare(Density left, Density right) {
                return Ints.compare((int)left.ordinal(), (int)right.ordinal());
            }
        };
        densities = densityOrdering.immutableSortedCopy(densities);
        for (Density density : densities) {
            JPanel iconPanel = new JPanel((LayoutManager)new VerticalFlowLayout(false, false));
            iconPanel.setBackground(this.myTheme.getMainColor());
            iconPanel.setOpaque(this.myTheme != Theme.TRANSPARENT);
            JBLabel title = new JBLabel(density.getResourceValue());
            title.setForeground(this.myTheme.getAltColor());
            iconPanel.add((Component)title);
            ImageComponent iconImage = new ImageComponent(null);
            iconImage.setBorder(new LineBorder(this.myTheme.getAltColor()));
            iconImage.setOpaque(false);
            iconPanel.add((Component)((Object)iconImage));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 19;
            this.myIconsPanel.add((Component)iconPanel, c);
            this.myIconImages.put(density, iconImage);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myIconsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTitleLabel = jBLabel = new JBLabel();
        jBLabel.setText("(title)");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    public static enum Theme {
        DARK(Color.BLACK, Color.WHITE),
        LIGHT(Color.WHITE, Color.BLACK),
        GRAY(Color.DARK_GRAY, Color.LIGHT_GRAY),
        TRANSPARENT(UIUtil.TRANSPARENT_COLOR, (Color)JBColor.BLACK);

        private final Color myMainColor;
        private final Color myAltColor;

        private Theme(Color mainColor, Color altColor) {
            if (mainColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainColor", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel$Theme", "<init>"));
            }
            if (altColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "altColor", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel$Theme", "<init>"));
            }
            this.myMainColor = mainColor;
            this.myAltColor = altColor;
        }

        @NotNull
        public Color getMainColor() {
            Color color = this.myMainColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel$Theme", "getMainColor"));
            }
            return color;
        }

        @NotNull
        public Color getAltColor() {
            Color color = this.myAltColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel$Theme", "getAltColor"));
            }
            return color;
        }
    }
}

