/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.core;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.ObservableOptional;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.google.common.base.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionalProperty<T>
extends AbstractProperty<Optional<T>>
implements ObservableOptional<T> {
    public final void setValue(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalProperty", "setValue"));
        }
        Optional opt = (Optional)this.get();
        if (!opt.isPresent() || !opt.get().equals(value)) {
            this.set(Optional.of(value));
        }
    }

    public final void clear() {
        if (((Optional)this.get()).isPresent()) {
            this.set(Optional.absent());
        }
    }

    public final void setNullableValue(@Nullable T value) {
        if (value != null) {
            this.setValue(value);
        } else {
            this.clear();
        }
    }

    @Override
    @NotNull
    public final ObservableBool isPresent() {
        BooleanExpression booleanExpression = new BooleanExpression(new ObservableValue[]{this}){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = ((Optional)OptionalProperty.this.get()).isPresent();
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty$1", "get"));
                }
                return bl;
            }
        };
        if (booleanExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty", "isPresent"));
        }
        return booleanExpression;
    }

    @Override
    @NotNull
    public final T getValue() {
        Optional opt = (Optional)this.get();
        Object object = opt.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty", "getValue"));
        }
        return (T)object;
    }

    @Override
    @NotNull
    public final T getValueOr(@NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/android/tools/idea/ui/properties/core/OptionalProperty", "getValueOr"));
        }
        Optional opt = (Optional)this.get();
        Object object = opt.or(defaultValue);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty", "getValueOr"));
        }
        return (T)object;
    }

    @Override
    @Nullable
    public final T getValueOrNull() {
        Optional opt = (Optional)this.get();
        return (T)opt.orNull();
    }
}

