/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Locale;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public abstract class NlLayoutType
extends Enum<NlLayoutType> {
    public static final /* enum */ NlLayoutType LAYOUT = new NlLayoutType(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType$1", "isResourceTypeOf"));
            }
            return LayoutDomFileDescription.isLayoutFile(file);
        }
    };
    public static final /* enum */ NlLayoutType MENU = new NlLayoutType(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType$2", "isResourceTypeOf"));
            }
            return MenuDomFileDescription.isMenuFile(file);
        }
    };
    public static final /* enum */ NlLayoutType PREFERENCE_SCREEN = new NlLayoutType(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType$3", "isResourceTypeOf"));
            }
            return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType$3", "lambda$isResourceTypeOf$0"));
                }
                if (file.getProject().isDisposed()) {
                    return false;
                }
                if (AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, ResourceFolderType.XML.getName())) {
                    XmlTag tag = file.getRootTag();
                    return tag != null && tag.getName().equals("PreferenceScreen");
                }
                return false;
            });
        }
    };
    public static final /* enum */ NlLayoutType DRAWABLE = new NlLayoutType(false){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType$4", "isResourceTypeOf"));
            }
            return AndroidDrawableDomUtil.isDrawableResourceFile(file);
        }
    };
    public static final /* enum */ NlLayoutType UNKNOWN = new NlLayoutType(false){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType$5", "isResourceTypeOf"));
            }
            return false;
        }
    };
    private final boolean mySupportedByDesigner;
    private static final /* synthetic */ NlLayoutType[] $VALUES;

    public static NlLayoutType[] values() {
        return (NlLayoutType[])$VALUES.clone();
    }

    public static NlLayoutType valueOf(String name) {
        return Enum.valueOf(NlLayoutType.class, name);
    }

    private NlLayoutType(boolean supportedByDesigner) {
        this.mySupportedByDesigner = supportedByDesigner;
    }

    public abstract boolean isResourceTypeOf(@NotNull XmlFile var1);

    public boolean isLayout() {
        return this == LAYOUT;
    }

    public static boolean supports(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType", "supports"));
        }
        return NlLayoutType.typeOf(file).isSupportedByDesigner();
    }

    @NotNull
    public static NlLayoutType typeOf(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/model/NlLayoutType", "typeOf"));
        }
        for (NlLayoutType type : NlLayoutType.values()) {
            if (!type.isResourceTypeOf(file)) continue;
            NlLayoutType nlLayoutType = type;
            if (nlLayoutType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlLayoutType", "typeOf"));
            }
            return nlLayoutType;
        }
        NlLayoutType nlLayoutType = UNKNOWN;
        if (nlLayoutType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlLayoutType", "typeOf"));
        }
        return nlLayoutType;
    }

    public boolean isSupportedByDesigner() {
        return this.mySupportedByDesigner;
    }

    @NotNull
    public final String getPaletteFileName() {
        assert (this.isSupportedByDesigner());
        String string = this.toString().toLowerCase(Locale.ROOT) + "_palette.xml";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlLayoutType", "getPaletteFileName"));
        }
        return string;
    }

    static {
        $VALUES = new NlLayoutType[]{LAYOUT, MENU, PREFERENCE_SCREEN, DRAWABLE, UNKNOWN};
    }
}

