/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.reflect.Type;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.SubtagsProcessingUtil;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomExtender
extends DomExtender<AndroidDomElement> {
    public boolean supportsStubs() {
        return false;
    }

    @NotNull
    private static Class getValueClass(@Nullable AttributeFormat format) {
        if (format == null) {
            if (String.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
            }
            return String.class;
        }
        switch (format) {
            case Boolean: {
                Class<Boolean> clazz = Boolean.TYPE;
                if (clazz == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
                }
                return clazz;
            }
            case Reference: 
            case Dimension: 
            case Color: {
                if (ResourceValue.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
                }
                return ResourceValue.class;
            }
        }
        if (String.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
        }
        return String.class;
    }

    public void registerExtensions(@NotNull AndroidDomElement element, @NotNull DomExtensionsRegistrar registrar) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "registerExtensions"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/android/dom/AndroidDomExtender", "registerExtensions"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return;
        }
        AttributeProcessingUtil.processAttributes(element, facet, true, (xmlName, attrDef, parentStyleableName) -> {
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/android/dom/AndroidDomExtender", "lambda$registerExtensions$0"));
            }
            Set<AttributeFormat> formats = attrDef.getFormats();
            Class valueClass = formats.size() == 1 ? AndroidDomExtender.getValueClass(formats.iterator().next()) : String.class;
            registrar.registerAttributeChildExtension(xmlName, GenericAttributeValue.class);
            return registrar.registerGenericAttributeValueChildExtension(xmlName, (Type)valueClass);
        });
        SubtagsProcessingUtil.processSubtags(facet, element, (arg_0, arg_1) -> ((DomExtensionsRegistrar)registrar).registerCollectionChildrenExtension(arg_0, arg_1));
    }
}

