/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.ManifestPlaceholderResolver;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestPlaceholderConverter
extends ResolvingConverter
implements CustomReferenceConverter<Object> {
    private static Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}?");
    private Converter myConverterDelegate;

    public ManifestPlaceholderConverter(@NotNull Converter converter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "<init>"));
        }
        this.myConverterDelegate = converter;
    }

    @NotNull
    public Collection<?> getVariants(ConvertContext context) {
        if (this.myConverterDelegate instanceof ResolvingConverter) {
            Collection collection = ((ResolvingConverter)this.myConverterDelegate).getVariants(context);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "getVariants"));
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "getVariants"));
        }
        return list;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (context.getModule() != null && s != null && s.contains("${")) {
            ManifestPlaceholderResolver resolver = new ManifestPlaceholderResolver(context.getModule());
            s = resolver.resolve(s);
        }
        return this.myConverterDelegate.getErrorMessage(s, context);
    }

    @Nullable
    public Object fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s != null && s.contains("${")) {
            return new PlaceholderValue(s);
        }
        return this.myConverterDelegate.fromString(s, context);
    }

    @Nullable
    public String toString(@Nullable Object o, ConvertContext context) {
        if (o instanceof PlaceholderValue) {
            return ((PlaceholderValue)o).myValueWithPlaceholders;
        }
        return this.myConverterDelegate != null ? this.myConverterDelegate.toString(o, context) : null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Object> value, PsiElement element, ConvertContext context) {
        if (context.getModule() == null || !(value.getValue() instanceof PlaceholderValue) && this.myConverterDelegate instanceof CustomReferenceConverter) {
            PsiReference[] psiReferenceArray = ((CustomReferenceConverter)this.myConverterDelegate).createReferences(value, element, context);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        String stringValue = element.getText();
        if (stringValue == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ManifestPlaceholderResolver resolver = new ManifestPlaceholderResolver(context.getModule());
        ImmutableSet placeholders = resolver.getPlaceholders().keySet();
        if (placeholders.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String[] placeholdersArray = ArrayUtil.toStringArray((Collection)placeholders);
        ArrayList result = Lists.newArrayList();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(stringValue);
        while (matcher.find()) {
            TextRange range = new TextRange(matcher.start(1), matcher.end(1));
            result.add(new PlaceholderReference(element, range, placeholdersArray));
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static class PlaceholderReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myDummyElement;
        private final ImmutableSet<String> myPlaceholderNames;
        private final String[] myValues;
        private final String myName;

        public PlaceholderReference(@NotNull PsiElement element, TextRange range, String[] values) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter$PlaceholderReference", "<init>"));
            }
            super(element, range, true);
            this.myDummyElement = new FakePsiElement(){

                public PsiElement getParent() {
                    return this.getElement();
                }
            };
            this.myName = range.substring(element.getText());
            this.myPlaceholderNames = ImmutableSet.copyOf((Object[])values);
            this.myValues = values;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myPlaceholderNames.contains((Object)this.myName) ? this.myDummyElement : null;
        }

        @NotNull
        public Object[] getVariants() {
            if (this.myValues == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ManifestPlaceholderConverter$PlaceholderReference", "getVariants"));
            }
            return this.myValues;
        }
    }

    static class PlaceholderValue {
        String myValueWithPlaceholders;

        PlaceholderValue(String valueWithPlaceholders) {
            this.myValueWithPlaceholders = valueWithPlaceholders;
        }
    }
}

