/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDependenciesCache {
    private static final Key<SoftReference<AndroidDependenciesCache>> KEY = Key.create((String)"ANDROID_DEPENDENCIES_CACHE");
    private final Module myModule;
    private final Ref<List<WeakReference<AndroidFacet>>> myAllDependencies;
    private final Ref<List<WeakReference<AndroidFacet>>> myAllLibraryDependencies;

    private AndroidDependenciesCache(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidDependenciesCache", "<init>"));
        }
        this.myAllDependencies = Ref.create();
        this.myAllLibraryDependencies = Ref.create();
        this.myModule = module;
        module.getProject().getMessageBus().connect((Disposable)module).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                AndroidDependenciesCache.this.dropCache();
            }
        });
    }

    private synchronized void dropCache() {
        this.myAllDependencies.set(null);
        this.myAllLibraryDependencies.set(null);
    }

    @NotNull
    public static AndroidDependenciesCache getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidDependenciesCache", "getInstance"));
        }
        AndroidDependenciesCache cache = (AndroidDependenciesCache)SoftReference.dereference((Reference)((Reference)module.getUserData(KEY)));
        if (cache == null) {
            cache = new AndroidDependenciesCache(module);
            module.putUserData(KEY, (Object)new SoftReference((Object)cache));
        }
        AndroidDependenciesCache androidDependenciesCache = cache;
        if (androidDependenciesCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidDependenciesCache", "getInstance"));
        }
        return androidDependenciesCache;
    }

    @NotNull
    public synchronized List<AndroidFacet> getAllAndroidDependencies(boolean androidLibrariesOnly) {
        List<AndroidFacet> list = AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, androidLibrariesOnly, this.getListRef(androidLibrariesOnly));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidDependenciesCache", "getAllAndroidDependencies"));
        }
        return list;
    }

    @NotNull
    private Ref<List<WeakReference<AndroidFacet>>> getListRef(boolean androidLibrariesOnly) {
        Ref<List<WeakReference<AndroidFacet>>> ref = androidLibrariesOnly ? this.myAllLibraryDependencies : this.myAllDependencies;
        if (ref == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidDependenciesCache", "getListRef"));
        }
        return ref;
    }

    @NotNull
    private static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module, boolean androidLibrariesOnly, Ref<List<WeakReference<AndroidFacet>>> listRef) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidDependenciesCache", "getAllAndroidDependencies"));
        }
        List refs = (List)listRef.get();
        if (refs == null) {
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            AndroidDependenciesCache.collectAllAndroidDependencies(module, androidLibrariesOnly, facets, (Set<AndroidFacet>)new HashSet());
            refs = ContainerUtil.map((Collection)ContainerUtil.reverse(facets), (Function)new Function<AndroidFacet, WeakReference<AndroidFacet>>(){

                public WeakReference<AndroidFacet> fun(AndroidFacet facet) {
                    return new WeakReference<AndroidFacet>(facet);
                }
            });
            listRef.set((Object)refs);
        }
        List<AndroidFacet> list = AndroidDependenciesCache.dereference(refs);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidDependenciesCache", "getAllAndroidDependencies"));
        }
        return list;
    }

    @NotNull
    private static List<AndroidFacet> dereference(@NotNull List<WeakReference<AndroidFacet>> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "org/jetbrains/android/util/AndroidDependenciesCache", "dereference"));
        }
        List list = ContainerUtil.mapNotNull(refs, (Function)new Function<WeakReference<AndroidFacet>, AndroidFacet>(){

            public AndroidFacet fun(WeakReference<AndroidFacet> ref) {
                return (AndroidFacet)((Object)ref.get());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidDependenciesCache", "dereference"));
        }
        return list;
    }

    private static void collectAllAndroidDependencies(Module module, boolean androidLibrariesOnly, List<AndroidFacet> result, Set<AndroidFacet> visited) {
        OrderEntry[] entries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            OrderEntry orderEntry = entries[i];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || androidLibrariesOnly && !depFacet.isLibraryProject() || !visited.add(depFacet)) continue;
            List cachedDepDeps = (List)AndroidDependenciesCache.getInstance(depModule).getListRef(androidLibrariesOnly).get();
            if (cachedDepDeps != null) {
                List<AndroidFacet> depDeps = AndroidDependenciesCache.dereference(cachedDepDeps);
                for (AndroidFacet depDepFacet : depDeps) {
                    if (!visited.add(depDepFacet)) continue;
                    result.add(depDepFacet);
                }
            } else {
                AndroidDependenciesCache.collectAllAndroidDependencies(depModule, androidLibrariesOnly, result, visited);
            }
            result.add(depFacet);
        }
    }
}

