/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.spring.security.model.xml.converters.SpringSecurityRolesConverter;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityRolesFactory;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class InterceptUrlAccessRolesConverter
extends SpringSecurityRolesConverter {
    @Override
    protected PsiReference createReference(PsiElement element, final @NotNull Module module, @NotNull String roleName, final int i) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/security/model/xml/converters/InterceptUrlAccessRolesConverter", "createReference"));
        }
        if (roleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roleName", "com/intellij/spring/security/model/xml/converters/InterceptUrlAccessRolesConverter", "createReference"));
        }
        return new SpringSecurityRolePsiReference(element, roleName, module, true){

            @Override
            @NotNull
            public Object[] getVariants() {
                if (i > 0) {
                    Object[] objectArray = super.getVariants();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptUrlAccessRolesConverter$1", "getVariants"));
                    }
                    return objectArray;
                }
                HashSet<PsiMethod> variants = new HashSet<PsiMethod>();
                variants.addAll(SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module, "org.springframework.security.web.access.expression.WebSecurityExpressionRoot"));
                SpringSecurityRolesFactory securityRolesFactory = SpringSecurityRolesFactory.getInstance(module);
                ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getRolesVariants());
                ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getPredefinedRolesVariants());
                Object[] objectArray = ArrayUtil.toObjectArray(variants);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptUrlAccessRolesConverter$1", "getVariants"));
                }
                return objectArray;
            }
        };
    }
}

