/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.detector.api.ClassContext;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import java.io.File;

public abstract class JavaEvaluator {
    public abstract boolean extendsClass(PsiClass var1, String var2, boolean var3);

    public abstract boolean implementsInterface(PsiClass var1, String var2, boolean var3);

    public boolean isMemberInSubClassOf(PsiMember method, String className, boolean strict) {
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && this.extendsClass(containingClass, className, strict);
    }

    public boolean isMemberInClass(PsiMember method, String className) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && className.equals(containingClass.getQualifiedName());
    }

    public int getParameterCount(PsiMethod method) {
        return method.getParameterList().getParametersCount();
    }

    public boolean inheritsFrom(PsiClass cls, String className, boolean strict) {
        return this.extendsClass(cls, className, strict) || this.implementsInterface(cls, className, strict);
    }

    public boolean methodMatches(PsiMethod method, String className, boolean allowInherit, String ... argumentTypes) {
        if (className != null && allowInherit && !this.isMemberInSubClassOf((PsiMember)method, className, false)) {
            return false;
        }
        return this.parametersMatch(method, argumentTypes);
    }

    public boolean parametersMatch(PsiMethod method, String ... argumentTypes) {
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != argumentTypes.length) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiType type = parameters[i].getType();
            if (type.getCanonicalText().equals(argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean parameterHasType(PsiMethod method, int parameterIndex, String typeName) {
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() > parameterIndex && this.typeMatches(parameterList.getParameters()[parameterIndex].getType(), typeName);
    }

    public boolean typeMatches(PsiType type, String typeName) {
        return type != null && type.getCanonicalText().equals(typeName);
    }

    public PsiElement resolve(PsiElement element) {
        PsiMethod resolved;
        if (element instanceof PsiReference) {
            return ((PsiReference)element).resolve();
        }
        if (element instanceof PsiMethodCallExpression && (resolved = ((PsiMethodCallExpression)element).resolveMethod()) != null) {
            return resolved;
        }
        return null;
    }

    public boolean isPublic(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("public");
        }
        return false;
    }

    public boolean isStatic(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("static");
        }
        return false;
    }

    public boolean isPrivate(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("private");
        }
        return false;
    }

    public boolean isAbstract(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("abstract");
        }
        return false;
    }

    public boolean isFinal(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("final");
        }
        return false;
    }

    public PsiMethod getSuperMethod(PsiMethod method) {
        if (method == null) {
            return null;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            return superMethods[0];
        }
        return null;
    }

    public String getInternalName(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null && (qualifiedName = psiClass.getName()) == null) {
            assert (psiClass instanceof PsiAnonymousClass);
            return this.getInternalName(psiClass.getContainingClass());
        }
        return ClassContext.getInternalName(qualifiedName);
    }

    public String getInternalName(PsiClassType psiClassType) {
        return ClassContext.getInternalName(psiClassType.getCanonicalText());
    }

    public abstract PsiClass findClass(String var1);

    public abstract PsiClassType getClassType(PsiClass var1);

    public abstract PsiAnnotation[] getAllAnnotations(PsiModifierListOwner var1, boolean var2);

    public abstract PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner var1, String ... var2);

    public abstract PsiAnnotation findAnnotation(PsiModifierListOwner var1, String ... var2);

    public abstract File getFile(PsiFile var1);
}

