/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.jsf.SeamJamValidator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SeamValidatorReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/seam/model/references/SeamValidatorReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/seam/model/references/SeamValidatorReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new SeamValidatorPsiReference(element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/references/SeamValidatorReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/references/SeamValidatorReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class SeamValidatorPsiReference
    extends PsiReferenceBase {
        public SeamValidatorPsiReference(PsiElement element) {
            super(element, true);
        }

        public PsiElement resolve() {
            String value = this.getValue();
            if (StringUtil.isEmptyOrSpaces((String)value)) {
                return null;
            }
            List<SeamJamComponent> validorComponents = SeamValidatorPsiReference.getValidorComponents(this.getElement());
            for (SeamJamComponent validorComponent : validorComponents) {
                SeamJamValidator jamValidator = validorComponent.getValidator();
                if (jamValidator != null && value.equals(jamValidator.getId())) {
                    return jamValidator.getIdentifyingAnnotation();
                }
                if (!value.equals(validorComponent.getComponentName())) continue;
                return validorComponent.getIdentifyingPsiElement();
            }
            return null;
        }

        private static String getValidatorName(SeamJamComponent validorComponent) {
            String validatorName;
            SeamJamValidator jamValidator = validorComponent.getValidator();
            if (jamValidator != null && !StringUtil.isEmptyOrSpaces((String)(validatorName = jamValidator.getId()))) {
                return validatorName;
            }
            return validorComponent.getComponentName();
        }

        @NotNull
        public Object[] getVariants() {
            List variants = ContainerUtil.mapNotNull(SeamValidatorPsiReference.getValidorComponents(this.getElement()), seamJamComponent -> SeamValidatorPsiReference.getValidatorName(seamJamComponent));
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/references/SeamValidatorReferenceProvider$SeamValidatorPsiReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        private static List<SeamJamComponent> getValidorComponents(PsiElement element) {
            ArrayList<SeamJamComponent> validators = new ArrayList<SeamJamComponent>();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module != null) {
                for (SeamJamComponent seamJamComponent : SeamJamModel.getModel(module).getSeamComponents()) {
                    if (seamJamComponent.getValidator() == null) continue;
                    validators.add(seamJamComponent);
                }
            }
            ArrayList<SeamJamComponent> arrayList = validators;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/references/SeamValidatorReferenceProvider$SeamValidatorPsiReference", "getValidorComponents"));
            }
            return arrayList;
        }
    }
}

