/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.List;
import lombok.ast.Identifier;
import lombok.ast.ListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.WildcardKind;

class TypeReferenceTemplate {
    WildcardKind wildcard1;
    int arrayDimensions3;
    List<TypeReferencePart> parts2;
    private static final String PRIMITIVE_NAMES = " int long float double char short byte boolean ";

    TypeReferenceTemplate() {
    }

    static String getDescription(TypeReference self) {
        try {
            return self.getTypeName();
        }
        catch (Exception e) {
            return null;
        }
    }

    static TypeReference VOID() {
        return TypeReferenceTemplate.newPrimitive("void");
    }

    static TypeReference BOOLEAN() {
        return TypeReferenceTemplate.newPrimitive("boolean");
    }

    static TypeReference INT() {
        return TypeReferenceTemplate.newPrimitive("int");
    }

    static TypeReference LONG() {
        return TypeReferenceTemplate.newPrimitive("long");
    }

    static TypeReference SHORT() {
        return TypeReferenceTemplate.newPrimitive("short");
    }

    static TypeReference BYTE() {
        return TypeReferenceTemplate.newPrimitive("byte");
    }

    static TypeReference CHAR() {
        return TypeReferenceTemplate.newPrimitive("char");
    }

    static TypeReference DOUBLE() {
        return TypeReferenceTemplate.newPrimitive("double");
    }

    static TypeReference FLOAT() {
        return TypeReferenceTemplate.newPrimitive("float");
    }

    private static TypeReference newPrimitive(String primitiveName) {
        return (TypeReference)new TypeReference().astParts().addToEnd(new TypeReferencePart[]{new TypeReferencePart().astIdentifier(Identifier.of(primitiveName))});
    }

    static TypeReference fromName(String name) {
        TypeReference ref = new TypeReference();
        for (String part : name.split("\\.")) {
            ref.astParts().addToEnd(new TypeReferencePart[]{new TypeReferencePart().astIdentifier(Identifier.of(part))});
        }
        return ref;
    }

    static boolean isPrimitive(TypeReference self) {
        if (self.astArrayDimensions() > 0 || self.rawParts().size() != 1) {
            return false;
        }
        try {
            String name = self.astParts().first().astIdentifier().astValue();
            return name.indexOf(32) == -1 && PRIMITIVE_NAMES.contains(" " + name + " ");
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    static boolean isBoolean(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "boolean");
    }

    static boolean isInt(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "int");
    }

    static boolean isLong(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "long");
    }

    static boolean isShort(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "short");
    }

    static boolean isByte(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "byte");
    }

    static boolean isChar(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "char");
    }

    static boolean isDouble(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "double");
    }

    static boolean isFloat(TypeReference self) {
        return TypeReferenceTemplate.isPrimitive(self, "float");
    }

    private static boolean isPrimitive(TypeReference ref, String primitiveName) {
        if (ref.astArrayDimensions() > 0 || ref.rawParts().size() != 1) {
            return false;
        }
        try {
            String name = ref.astParts().first().astIdentifier().astValue();
            return name.equals(primitiveName);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    static boolean isVoid(TypeReference self) {
        if (self.rawParts().size() != 1) {
            return false;
        }
        try {
            String name = self.astParts().first().astIdentifier().astValue();
            return name.equals("void");
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    static String getTypeName(TypeReference self) {
        StringBuilder out = new StringBuilder();
        for (TypeReferencePart p : self.astParts()) {
            if (out.length() > 0) {
                out.append(".");
            }
            out.append(p.getTypeName());
        }
        for (int i = 0; i < self.astArrayDimensions(); ++i) {
            out.append("[]");
        }
        return out.toString();
    }

    static boolean hasTypeArguments(TypeReference self) {
        return TypeReferenceTemplate.getTypeArguments(self).isEmpty();
    }

    static StrictListAccessor<TypeReference, TypeReference> getTypeArguments(TypeReference self) {
        try {
            return self.astParts().last().typeArguments.wrap(self).asStrict();
        }
        catch (Exception e) {
            return ListAccessor.emptyStrict("typeArguments", self);
        }
    }
}

