/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.ecj;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.StringLiteral;
import lombok.ast.ecj.EcjTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class EcjTreePrinter {
    private static final Multimap<Class<?>, ComponentField> visitedClasses = ArrayListMultimap.create();
    private static final List<String> POSITION_FIELDNAMES = ImmutableList.of((Object)"sourceStart", (Object)"sourceEnd", (Object)"originalSourceEnd", (Object)"bodyStart", (Object)"bodyEnd", (Object)"blockStart", (Object)"declarationSourceStart", (Object)"declarationSourceEnd", (Object)"declarationEnd", (Object)"endPart1Position", (Object)"endPart2Position", (Object)"valuePositions", (Object[])new String[]{"sourcePositions", "modifiersSourceStart", "typeArgumentsSourceStart", "statementEnd", "labelEnd", "nameSourcePosition", "tagSourceStart", "tagSourceEnd"});
    private final Printer printer;
    private Set<String> propertySkipList = Sets.newHashSet();
    private Multimap<String, Object> propertyIfValueSkipList = ArrayListMultimap.create();
    private Map<String, String> stringReplacements = Maps.newHashMap();
    private List<ReferenceTrackingSkip> referenceTrackingSkipList = Lists.newArrayList();
    private final EcjTreeVisitor visitor = new EcjTreeVisitor(){

        @Override
        public void visitAny(ASTNode node) {
            Collection fields = EcjTreePrinter.findFields(node);
            for (ComponentField f : fields) {
                Object value;
                String skipListKey = node.getClass().getSimpleName() + "/" + f.field.getName();
                if (EcjTreePrinter.this.propertySkipList.contains(skipListKey)) continue;
                if (node instanceof ConditionalExpression) {
                    ((ConditionalExpression)node).valueIfTrue.sourceEnd = -2;
                }
                if ((value = "originalSourceEnd".equals(f.field.getName()) && node instanceof ArrayTypeReference ? Integer.valueOf(-2) : EcjTreePrinter.this.readField(f.field, node)) == null || EcjTreePrinter.this.propertyIfValueSkipList.get((Object)skipListKey).contains(value)) continue;
                boolean trackRef = true;
                for (ReferenceTrackingSkip skip : EcjTreePrinter.this.referenceTrackingSkipList) {
                    if (skip.getParent() != null && !skip.getParent().isInstance(node) || skip.getType() != null && !skip.getType().isInstance(value)) continue;
                    trackRef = false;
                    break;
                }
                f.print(EcjTreePrinter.this.printer, this, value, trackRef);
            }
        }

        @Override
        public void visitOther(ASTNode node) {
            this.visitAny(node);
        }
    };

    private EcjTreePrinter(boolean printPositions) {
        this.printer = new Printer(printPositions);
    }

    public static EcjTreePrinter printerWithPositions() {
        return new EcjTreePrinter(true);
    }

    public static EcjTreePrinter printerWithoutPositions() {
        return new EcjTreePrinter(false);
    }

    public String toString() {
        return this.getContent();
    }

    public String getContent() {
        String result = this.printer.content.toString();
        for (Map.Entry<String, String> entry : this.stringReplacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void visit(ASTNode node) {
        this.visitor.visitEcjNode(node);
    }

    public EcjTreePrinter skipProperty(Class<? extends ASTNode> type, String propertyName) {
        this.propertySkipList.add(type.getSimpleName() + "/" + propertyName);
        return this;
    }

    public EcjTreePrinter skipPropertyIfHasValue(Class<? extends ASTNode> type, String propertyName, Object value) {
        this.propertyIfValueSkipList.put((Object)(type.getSimpleName() + "/" + propertyName), value);
        return this;
    }

    public void stringReplace(String original, String replacement) {
        this.stringReplacements.put(original, replacement);
    }

    public EcjTreePrinter skipReferenceTracking(Class<? extends ASTNode> parent, Class<?> type) {
        this.referenceTrackingSkipList.add(new ReferenceTrackingSkip(parent, type));
        return this;
    }

    private Object readField(Field field, ASTNode node) {
        return field.get(node);
    }

    private static Collection<ComponentField> findFields(ASTNode node) {
        Class<?> clazz = node.getClass();
        if (visitedClasses.containsKey(clazz)) {
            return visitedClasses.get(clazz);
        }
        ArrayList fields = Lists.newArrayList();
        for (Field f : EcjTreePrinter.findAllFields(clazz)) {
            if ((f.getModifiers() & 8) != 0) continue;
            fields.add(new ComponentField(f));
        }
        Collections.sort(fields);
        visitedClasses.putAll(clazz, (Iterable)fields);
        return fields;
    }

    private static List<Field> findAllFields(Class<?> clazz) {
        ArrayList allFields = Lists.newArrayList();
        EcjTreePrinter.findAllFieldsRecursively(allFields, clazz);
        return allFields;
    }

    private static void findAllFieldsRecursively(List<Field> allFields, Class<?> clazz) {
        if (clazz == Object.class) {
            return;
        }
        allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        EcjTreePrinter.findAllFieldsRecursively(allFields, clazz.getSuperclass());
    }

    static class ComponentField
    implements Comparable<ComponentField> {
        private static final List<Package> KNOWN_PACKAGES = ImmutableList.of((Object)String.class.getPackage(), (Object)ASTNode.class.getPackage(), (Object)TypeBinding.class.getPackage(), (Object)Constant.class.getPackage());
        private ImmutableMap<Class<?>, Object> DEFAULTS = ImmutableMap.builder().put(Boolean.TYPE, (Object)false).put(Byte.TYPE, (Object)0).put(Short.TYPE, (Object)0).put(Integer.TYPE, (Object)0).put(Character.TYPE, (Object)Character.valueOf('\u0000')).put(Long.TYPE, (Object)0L).put(Float.TYPE, (Object)Float.valueOf(0.0f)).put(Double.TYPE, (Object)0.0).build();
        private final Field field;
        private final int dimensions;
        private final Class<?> type;

        public ComponentField(Field field) {
            this.field = field;
            field.setAccessible(true);
            Class<?> type = field.getType();
            int dimensions = 0;
            while (type.isArray()) {
                ++dimensions;
                type = type.getComponentType();
            }
            this.dimensions = dimensions;
            this.type = type;
        }

        public String toString() {
            return this.createDescription();
        }

        private String createDescription() {
            StringBuilder result = new StringBuilder();
            result.append(this.typeName());
            for (int dim = 0; dim < this.dimensions; ++dim) {
                result.append("[]");
            }
            result.append(" ").append(this.field.getName());
            return result.toString();
        }

        private String typeName() {
            if (this.type.isPrimitive() || KNOWN_PACKAGES.contains(this.type.getPackage())) {
                return this.type.getSimpleName();
            }
            return this.type.getName();
        }

        boolean isPositionField() {
            return POSITION_FIELDNAMES.contains(this.field.getName());
        }

        @Override
        public int compareTo(ComponentField o) {
            Class<?> otherType = o.type;
            if (this.isPositionField() && o.isPositionField()) {
                return POSITION_FIELDNAMES.indexOf(this.field.getName()) - POSITION_FIELDNAMES.indexOf(o.field.getName());
            }
            if (this.isPositionField() || o.isPositionField()) {
                return this.isPositionField() ? -1 : 1;
            }
            if (this.type.isPrimitive() == otherType.isPrimitive()) {
                return String.CASE_INSENSITIVE_ORDER.compare(this.field.getName(), o.field.getName());
            }
            return this.type.isPrimitive() ? -1 : 1;
        }

        public void printVisited(Printer printer, Integer id) {
            printer.printProperty(this.typeName(), this.field.getName(), "reference to " + id, false);
        }

        public void print(Printer printer, EcjTreeVisitor visitor, Object value, boolean trackRef) {
            boolean posField = this.isPositionField();
            if (!printer.printPositions && posField) {
                return;
            }
            if (!posField && this.isDefault(value)) {
                return;
            }
            this.unroll(printer, visitor, value, 0, this.field.getName(), posField, trackRef);
        }

        private void unroll(Printer printer, EcjTreeVisitor visitor, Object value, int dim, String description, boolean posField, boolean trackRef) {
            if (dim == this.dimensions) {
                if (value instanceof ASTNode) {
                    if (!trackRef) {
                        printer.begin(this.typeName(), description, value.getClass(), printer.objectCounter++);
                        visitor.visitEcjNode((ASTNode)value);
                        printer.end();
                    } else if (printer.visited.containsKey(value)) {
                        this.printVisited(printer, printer.visited.get(value));
                    } else {
                        printer.visited.put(value, printer.objectCounter);
                        printer.begin(this.typeName(), description, value.getClass(), printer.objectCounter++);
                        visitor.visitEcjNode((ASTNode)value);
                        printer.end();
                    }
                } else {
                    printer.printProperty(this.typeName(), description, value, posField);
                }
            } else if (value == null) {
                printer.printProperty(this.typeName(), description, "NULL", posField);
            } else {
                if (this.type == Character.TYPE && this.dimensions - dim <= 2) {
                    if (this.dimensions - dim == 1) {
                        printer.printProperty(this.typeName(), description + "[]", value, posField);
                    } else {
                        printer.printProperty(this.typeName(), description + "[][]", value, posField);
                    }
                    return;
                }
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    this.unroll(printer, visitor, Array.get(value, i), dim + 1, description + "[" + i + "]", posField, trackRef);
                }
            }
        }

        private boolean isDefault(Object value) {
            if (value == null) {
                return true;
            }
            if (this.type.isPrimitive() && this.dimensions == 0) {
                return this.DEFAULTS.get(this.type).equals(value);
            }
            return false;
        }
    }

    static class Printer {
        final Map<Object, Integer> visited = new MapMaker().weakKeys().makeMap();
        int objectCounter = 0;
        private final StringBuilder content = new StringBuilder();
        private int indent;
        private final boolean printPositions;

        public Printer(boolean printPositions) {
            this.printPositions = printPositions;
        }

        void begin(String typeName, String description, Class<?> clazz, int id) {
            this.printIndent();
            this.content.append(typeName).append(" ").append(description).append(" = ").append(clazz.getSimpleName());
            if (id != -1) {
                this.content.append(" (id:").append(id).append(")");
            }
            this.content.append("\n");
            ++this.indent;
        }

        void end() {
            --this.indent;
        }

        public void printProperty(String typeName, String name, Object value, boolean posField) {
            String stringValue;
            this.printIndent();
            if (posField) {
                if (value instanceof Long) {
                    long longValue = (Long)value;
                    stringValue = String.format("(%d, %d)", (int)(longValue >> 32), (int)(longValue & 0xFFFFFFFFL));
                } else {
                    stringValue = String.valueOf(value);
                }
            } else if ("bits".equals(name) && value instanceof Integer) {
                stringValue = Printer.formatBits((Integer)value);
            } else if (value instanceof Long) {
                long longValue = (Long)value;
                stringValue = String.format("0x%1$016x (%1$d)  %2$d<<32 | %3$d", value, (int)(longValue >> 32), (int)(longValue & 0xFFFFFFFFL));
            } else if (value instanceof Integer) {
                stringValue = String.format("0x%1$08x (%1$d)", value);
            } else if (value instanceof char[]) {
                stringValue = new StringLiteral().astValue(new String((char[])value)).rawValue();
            } else if (value instanceof char[][]) {
                StringBuilder sb = new StringBuilder();
                for (char[] single : (char[][])value) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(new StringLiteral().astValue(new String(single)).rawValue());
                }
                stringValue = "{" + sb.toString() + "}";
            } else if ("compilationResult".equals(name)) {
                stringValue = value == null ? "[NULL]" : "[SET]";
            } else {
                if ("problemReporter".equals(name)) {
                    return;
                }
                stringValue = String.valueOf(value);
            }
            this.content.append(typeName).append(" ").append(name).append(" = ").append(stringValue).append("\n");
        }

        private static String formatBits(int value) {
            ArrayList elems = Lists.newArrayList();
            int pos = 0;
            while (value != 0) {
                ++pos;
                if ((value & 1) != 0) {
                    elems.add(pos);
                }
                value >>>= 1;
            }
            return elems.isEmpty() ? "NONE" : "[" + Joiner.on((String)",").join((Iterable)elems) + "]";
        }

        private void printIndent() {
            for (int i = 0; i < this.indent; ++i) {
                this.content.append("  ");
            }
        }
    }

    private static class ReferenceTrackingSkip {
        private final Class<? extends ASTNode> parent;
        private final Class<?> type;

        @ConstructorProperties(value={"parent", "type"})
        public ReferenceTrackingSkip(Class<? extends ASTNode> parent, Class<?> type) {
            this.parent = parent;
            this.type = type;
        }

        public Class<? extends ASTNode> getParent() {
            return this.parent;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReferenceTrackingSkip)) {
                return false;
            }
            ReferenceTrackingSkip other = (ReferenceTrackingSkip)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent())) {
                return false;
            }
            return !(this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType()));
        }

        public boolean canEqual(Object other) {
            return other instanceof ReferenceTrackingSkip;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + (this.getParent() == null ? 0 : this.getParent().hashCode());
            result = result * 31 + (this.getType() == null ? 0 : this.getType().hashCode());
            return result;
        }

        public String toString() {
            return "EcjTreePrinter.ReferenceTrackingSkip(parent=" + this.getParent() + ", type=" + this.getType() + ")";
        }
    }
}

