/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaDuplicatesView
extends DuplicatesView {
    private final Project myProject;
    private final DiffPanelEx myDiffPanel;

    public JavaDuplicatesView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/resultUI/JavaDuplicatesView", "<init>"));
        }
        this.myProject = project;
        this.myDiffPanel = (DiffPanelEx)DiffManager.getInstance().createDiffPanel(null, project, (Disposable)this, null);
        this.myDiffPanel.setComparisonPolicy(ComparisonPolicy.IGNORE_SPACE);
        DiffPanelOptions diffPanelOptions = this.myDiffPanel.getOptions();
        diffPanelOptions.setShowSourcePolicy(DiffPanelOptions.ShowSourcePolicy.OPEN_EDITOR);
        diffPanelOptions.setRequestFocusOnNewContent(false);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myDiffPanel.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/JavaDuplicatesView", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void setContent(@NotNull CodeNode left, @NotNull CodeNode right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/dupLocator/resultUI/JavaDuplicatesView", "setContent"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/dupLocator/resultUI/JavaDuplicatesView", "setContent"));
        }
        SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
        request.setToolbarAddons(DiffRequest.ToolbarAddons.IDE_FRAME);
        DiffContent leftContent = left.getDiffContentIfValid();
        DiffContent rightContent = right.getDiffContentIfValid();
        if (leftContent == null || rightContent == null) {
            return;
        }
        request.setContents(leftContent, rightContent);
        request.setContentTitles(left.getTitle(false).getText(), right.getTitle(false).getText());
        this.myDiffPanel.setDiffRequest((DiffRequest)request);
    }
}

