/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.NotNullFunction;
import com.intellij.util.xml.DomElement;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class NavigationGutterIconBuilderUtil {
    static final NotNullFunction<SpringBeanPointer, Collection<? extends PsiElement>> BEAN_POINTER_CONVERTOR = pointer -> {
        if (!pointer.isValid()) {
            return Collections.emptySet();
        }
        return Collections.singleton(pointer.getSpringBean().getIdentifyingPsiElement());
    };
    static final NotNullFunction<CommonModelElement, Collection<? extends PsiElement>> COMMON_MODEL_ELEMENT_CONVERTOR = modelElement -> Collections.singleton(modelElement.getIdentifyingPsiElement());
    static final NotNullFunction<SpringBeanPointer, Collection<? extends GotoRelatedItem>> BEAN_POINTER_GOTO_PROVIDER = pointer -> {
        CommonSpringBean bean = pointer.getSpringBean();
        if (bean instanceof DomSpringBean) {
            return Collections.singletonList(new DomGotoRelatedItem((DomElement)((DomSpringBean)bean)));
        }
        PsiElement element = bean.getIdentifyingPsiElement();
        if (element != null) {
            return Collections.singletonList(new GotoRelatedItem(element));
        }
        return Collections.emptyList();
    };
    public static final NotNullFunction<CommonModelElement, Collection<? extends GotoRelatedItem>> COMMON_MODEL_ELEMENT_GOTO_PROVIDER = modelElement -> {
        if (modelElement instanceof DomSpringBean) {
            return Collections.singletonList(new DomGotoRelatedItem((DomElement)((DomSpringBean)modelElement)));
        }
        PsiElement element = modelElement.getIdentifyingPsiElement();
        if (element != null) {
            return Collections.singletonList(new GotoRelatedItem(element));
        }
        return Collections.emptyList();
    };

    private NavigationGutterIconBuilderUtil() {
    }

    public static void addAutowiredBeansGutterIcon(@NotNull Collection<SpringBeanPointer> collection, @NotNull Collection<? super RelatedItemLineMarkerInfo> holder, @NotNull PsiElement element) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(collection, holder, element, SpringBundle.message("navigate.to.autowired.dependencies", new Object[0]));
    }

    public static void addAutowiredBeansGutterIcon(@NotNull Collection<SpringBeanPointer> collection, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiElement element, @NotNull String tooltipText) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (tooltipText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipText", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        ArrayList<SpringBeanPointer> sorted = new ArrayList<SpringBeanPointer>(collection);
        Collections.sort(sorted, SpringBeanPointer.DISPLAY_COMPARATOR);
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ShowAutowiredDependencies, BEAN_POINTER_CONVERTOR, BEAN_POINTER_GOTO_PROVIDER).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(tooltipText).setTargets(sorted);
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(element));
    }
}

