/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.actions.generate.GenerateAutowiredDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringBeanClassMember;
import com.intellij.spring.model.actions.generate.SpringGenerateTemplatesHolder;
import com.intellij.spring.model.highlighting.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateSpringBeanDependenciesUtil {
    public static boolean acceptBean(SpringBean springBean, boolean isSetterDependency) {
        return !GenerateSpringBeanDependenciesUtil.getCandidates(springBean, isSetterDependency).isEmpty();
    }

    public static boolean acceptPsiClass(PsiClass psiClass, boolean isSetterDependency) {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)psiClass);
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (PsiClass)psiClass) && !GenerateSpringBeanDependenciesUtil.getCandidates(model, psiClass, isSetterDependency).isEmpty();
    }

    public static List<Pair<SpringInjection, SpringGenerateTemplatesHolder>> generateDependenciesFor(@Nullable CommonSpringModel model, @Nullable PsiClass psiClass, boolean isSetterDependency) {
        ArrayList<Pair<SpringInjection, SpringGenerateTemplatesHolder>> createdProperties = new ArrayList<Pair<SpringInjection, SpringGenerateTemplatesHolder>>();
        if (model != null && psiClass != null) {
            List list = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)psiClass));
            if (list.size() > 0) {
                for (SpringBeanPointer pointer : list) {
                    CommonSpringBean springBean = pointer.getSpringBean();
                    if (!(springBean instanceof SpringBean) || !GenerateSpringBeanDependenciesUtil.acceptBean((SpringBean)springBean, isSetterDependency)) continue;
                    return GenerateSpringBeanDependenciesUtil.ensureFileWritable((DomElement)((SpringBean)springBean)) ? GenerateSpringBeanDependenciesUtil.generateDependenciesFor((SpringBean)springBean, isSetterDependency) : new ArrayList();
                }
            } else {
                List<SpringBeanPointer> beans = GenerateSpringBeanDependenciesUtil.chooseDependentBeans(GenerateSpringBeanDependenciesUtil.getCandidates(model, psiClass, isSetterDependency), psiClass.getProject(), isSetterDependency);
                if (beans.size() > 0) {
                    return GenerateSpringBeanDependenciesUtil.createBeanAndGenerateDependencies(psiClass, isSetterDependency, beans);
                }
            }
        }
        return createdProperties;
    }

    public static List<Pair<SpringInjection, SpringGenerateTemplatesHolder>> createBeanAndGenerateDependencies(PsiClass psiClass, boolean isSetterDependency, List<SpringBeanPointer> beans) {
        CommonSpringBean springBean = beans.get(0).getSpringBean();
        SpringBean bean = null;
        if (springBean instanceof DomSpringBean) {
            DomSpringBean domSpringBean = (DomSpringBean)springBean;
            bean = GenerateSpringBeanDependenciesUtil.createSpringBean((Beans)domSpringBean.getParentOfType(Beans.class, false), psiClass);
        }
        return bean == null ? new ArrayList() : GenerateSpringBeanDependenciesUtil.generateDependencies(bean, beans, isSetterDependency);
    }

    @Nullable
    private static SpringBean createSpringBean(Beans parentBeans, PsiClass psiClass) {
        if (!GenerateSpringBeanDependenciesUtil.ensureFileWritable((DomElement)parentBeans)) {
            return null;
        }
        SpringBean springBean = parentBeans.addBean();
        springBean.getClazz().setStringValue(psiClass.getQualifiedName());
        String[] strings = SpringBeanCoreUtils.suggestBeanNames((CommonSpringBean)springBean);
        springBean.getId().setStringValue(strings.length > 0 ? strings[0] : "");
        return springBean;
    }

    public static boolean ensureFileWritable(DomElement domElement) {
        return GenerateSpringBeanDependenciesUtil.ensureFileWritable(DomUtil.getFile((DomElement)domElement).getVirtualFile(), domElement.getManager().getProject());
    }

    public static boolean ensureFileWritable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "ensureFileWritable"));
        }
        return GenerateSpringBeanDependenciesUtil.ensureFileWritable(psiClass.getContainingFile().getVirtualFile(), psiClass.getProject());
    }

    public static boolean ensureFileWritable(@Nullable VirtualFile virtualFile, Project project) {
        if (virtualFile != null && !virtualFile.isWritable()) {
            return ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        }
        return true;
    }

    public static List<Pair<SpringInjection, SpringGenerateTemplatesHolder>> generateDependenciesFor(@Nullable SpringBean springBean, boolean isSetterDependency) {
        if (springBean == null || PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) == null) {
            return Collections.emptyList();
        }
        Project project = springBean.getManager().getProject();
        List<SpringBeanPointer> dependencies = GenerateSpringBeanDependenciesUtil.chooseDependentBeans(GenerateSpringBeanDependenciesUtil.getCandidates(springBean, isSetterDependency), project, isSetterDependency);
        return GenerateSpringBeanDependenciesUtil.generateDependencies(springBean, dependencies, isSetterDependency);
    }

    public static List<Pair<SpringInjection, SpringGenerateTemplatesHolder>> generateDependencies(final @NotNull SpringBean springBean, final List<SpringBeanPointer> dependencies, final boolean isSetterDependency) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "generateDependencies"));
        }
        Module module = springBean.getModule();
        if (module == null) {
            return Collections.emptyList();
        }
        return (List)new WriteCommandAction<List<Pair<SpringInjection, SpringGenerateTemplatesHolder>>>(module.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<List<Pair<SpringInjection, SpringGenerateTemplatesHolder>>> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil$1", "run"));
                }
                ArrayList<Pair> springInjections = new ArrayList<Pair>();
                CommonSpringModel model = SpringModelUtils.getInstance().getSpringModelByBean((CommonSpringBean)springBean);
                for (SpringBeanPointer bean : dependencies) {
                    Pair pair = isSetterDependency ? GenerateSpringBeanDependenciesUtil.createDependency(springBean, bean, model) : GenerateSpringBeanDependenciesUtil.createConstructorArg(springBean, bean, model);
                    if (pair == null) continue;
                    springInjections.add(pair);
                }
                result.setResult(springInjections);
            }
        }.execute().getResultObject();
    }

    @NotNull
    public static List<SpringBeanPointer> chooseDependentBeans(Set<SpringBeanClassMember> candidates, Project project, boolean setterDependency) {
        SpringBeanClassMember[] members;
        ArrayList<SpringBeanPointer> chosenBeans = new ArrayList<SpringBeanPointer>();
        MemberChooser<SpringBeanClassMember> chooser = new MemberChooser<SpringBeanClassMember>(candidates.toArray(new SpringBeanClassMember[candidates.size()]), false, setterDependency, project){

            protected MemberChooser.ShowContainersAction getShowContainersAction() {
                return new MemberChooser.ShowContainersAction((MemberChooser)this, SpringBundle.message("spring.beans.chooser.show.context.files", new Object[0]), SpringApiIcons.SpringConfig);
            }

            protected String getAllContainersNodeName() {
                return SpringBundle.message("spring.beans.chooser.all.context.files", new Object[0]);
            }
        };
        chooser.setTitle(SpringBundle.message("spring.bean.dependencies.chooser.title", new Object[0]));
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        if (chooser.getExitCode() == 0 && (members = (SpringBeanClassMember[])chooser.getSelectedElements((ClassMember[])new SpringBeanClassMember[0])) != null) {
            for (SpringBeanClassMember member : members) {
                chosenBeans.add(member.getSpringBean());
            }
        }
        ArrayList<SpringBeanPointer> arrayList = chosenBeans;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "chooseDependentBeans"));
        }
        return arrayList;
    }

    @NotNull
    public static Set<SpringBeanClassMember> getAutowiredBeanCandidates(@NotNull CommonSpringModel model, @NotNull Condition<SpringBeanPointer> condition) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getAutowiredBeanCandidates"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getAutowiredBeanCandidates"));
        }
        HashSet<SpringBeanClassMember> beanClassMembers = new HashSet<SpringBeanClassMember>();
        Collection allBeans = model.getAllCommonBeans();
        for (SpringBeanPointer pointer : allBeans) {
            PsiClass[] dependentBeanClasses = GenerateSpringBeanDependenciesUtil.getEffectiveBeanClasses(pointer);
            if (!GenerateSpringBeanDependenciesUtil.canBeReferenced(pointer, allBeans) || dependentBeanClasses.length <= 0 || !condition.value((Object)pointer)) continue;
            beanClassMembers.add(new SpringBeanClassMember(pointer));
        }
        HashSet<SpringBeanClassMember> hashSet = beanClassMembers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getAutowiredBeanCandidates"));
        }
        return hashSet;
    }

    private static PsiClass[] getEffectiveBeanClasses(SpringBeanPointer pointer) {
        return (PsiClass[])ContainerUtil.map2Array((Object[])pointer.getEffectiveBeanTypes(), PsiClass.class, PsiTypesUtil::getPsiClass);
    }

    @NotNull
    public static Set<SpringBeanClassMember> getCandidates(SpringBean springBean, boolean setterDependency) {
        PsiClass springBeanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (springBeanClass == null) {
            Set<SpringBeanClassMember> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getCandidates"));
            }
            return set;
        }
        com.intellij.util.containers.hash.HashSet beanClassMembers = new com.intellij.util.containers.hash.HashSet();
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean);
        Collection allBeans = model.getAllCommonBeans();
        for (SpringBeanPointer pointer : allBeans) {
            if (pointer.isReferenceTo((CommonSpringBean)springBean)) continue;
            PsiClass[] dependentBeanClasses = GenerateSpringBeanDependenciesUtil.getEffectiveBeanClasses(pointer);
            if (!GenerateSpringBeanDependenciesUtil.canBeReferenced(pointer, allBeans) || dependentBeanClasses.length <= 0 || GenerateSpringBeanDependenciesUtil.hasDependency((CommonSpringBean)springBean, pointer, setterDependency) || (!setterDependency || GenerateSpringBeanDependenciesUtil.isCompiledElementWithoutSetter(springBeanClass, dependentBeanClasses)) && (setterDependency || GenerateSpringBeanDependenciesUtil.isCompiledElementWithoutProperConstructor(springBean, model, PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()), dependentBeanClasses))) continue;
            beanClassMembers.add(new SpringBeanClassMember(pointer));
        }
        com.intellij.util.containers.hash.HashSet hashSet = beanClassMembers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getCandidates"));
        }
        return hashSet;
    }

    private static boolean canBeReferenced(SpringBeanPointer bean, Collection<SpringBeanPointer> beans) {
        return SpringBeanCoreUtils.getReferencedName(bean, beans) != null;
    }

    public static Set<SpringBeanClassMember> getCandidates(@NotNull CommonSpringModel processor, PsiClass psiClass, boolean setterDependency) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getCandidates"));
        }
        com.intellij.util.containers.hash.HashSet beanClassMembers = new com.intellij.util.containers.hash.HashSet();
        Collection allBeans = processor.getAllCommonBeans();
        for (SpringBeanPointer bean : allBeans) {
            PsiClass[] dependentBeanClasses = GenerateSpringBeanDependenciesUtil.getEffectiveBeanClasses(bean);
            if (!GenerateSpringBeanDependenciesUtil.canBeReferenced(bean, allBeans) || dependentBeanClasses.length <= 0 || (!setterDependency || GenerateSpringBeanDependenciesUtil.isCompiledElementWithoutSetter(psiClass, dependentBeanClasses)) && (setterDependency || GenerateSpringBeanDependenciesUtil.isCompiledElementWithoutProperConstructor(null, processor, psiClass, dependentBeanClasses))) continue;
            beanClassMembers.add(new SpringBeanClassMember(bean));
        }
        return beanClassMembers;
    }

    private static boolean isCompiledElementWithoutProperConstructor(@Nullable SpringBean springBean, CommonSpringModel model, PsiClass springBeanClass, PsiClass[] beanClasses) {
        if (!(springBeanClass instanceof PsiCompiledElement) && !(springBeanClass.getOriginalElement() instanceof PsiCompiledElement)) {
            return false;
        }
        if (springBean != null) {
            for (PsiClass beanClass : beanClasses) {
                if (GenerateSpringBeanDependenciesUtil.getCompiledElementCandidateConstructor(springBean, springBeanClass, beanClass) == null) continue;
                return false;
            }
        } else {
            List<SpringBeanPointer> list = SpringBeanCoreUtils.findBeansByClassName(model.getAllCommonBeans(), springBeanClass.getQualifiedName());
            for (PsiClass psiClass : beanClasses) {
                for (SpringBeanPointer pointer : list) {
                    CommonSpringBean bean = pointer.getSpringBean();
                    if (!(bean instanceof SpringBean) || GenerateSpringBeanDependenciesUtil.getCompiledElementCandidateConstructor((SpringBean)bean, springBeanClass, psiClass) == null) continue;
                    return false;
                }
            }
            for (PsiClass psiClass : springBeanClass.getConstructors()) {
                if (psiClass.getParameterList().getParametersCount() != 1) continue;
                PsiType type = psiClass.getParameterList().getParameters()[0].getType();
                PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)springBeanClass.getProject()).getElementFactory();
                for (PsiClass beanClass : beanClasses) {
                    PsiClassType classType = psiElementFactory.createType(beanClass);
                    if (!type.isAssignableFrom((PsiType)classType)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static PsiMethod getCompiledElementCandidateConstructor(SpringBean currentBean, PsiClass currentBeanClass, PsiClass candidateParameterClass) {
        PsiClassType candidatePsiType = JavaPsiFacade.getInstance((Project)currentBeanClass.getProject()).getElementFactory().createType(candidateParameterClass);
        if (currentBean.getConstructorArgs().isEmpty()) {
            return GenerateSpringBeanDependenciesUtil.findConstructor(currentBeanClass.getConstructors(), Collections.singletonList(candidatePsiType));
        }
        List<PsiMethod> methods = SpringConstructorArgResolveUtil.findMatchingMethods(currentBean);
        for (PsiMethod method : methods) {
            List<PsiType> psiParameterTypes = GenerateSpringBeanDependenciesUtil.getParameterTypes(method);
            psiParameterTypes.add((PsiType)candidatePsiType);
            PsiMethod existedConstructor = GenerateSpringBeanDependenciesUtil.findConstructor(currentBeanClass.getConstructors(), psiParameterTypes);
            if (existedConstructor == null) continue;
            return existedConstructor;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findConstructor(PsiMethod[] constructors, List<PsiType> psiParameterTypes) {
        for (PsiMethod constructor : constructors) {
            if (constructor.getParameterList().getParametersCount() != psiParameterTypes.size()) continue;
            boolean isAccepted = true;
            PsiParameter[] parameters = constructor.getParameterList().getParameters();
            for (int i = 0; i < psiParameterTypes.size(); ++i) {
                if (psiParameterTypes.get(i).isAssignableFrom(parameters[i].getType())) continue;
                isAccepted = false;
                break;
            }
            if (!isAccepted) continue;
            return constructor;
        }
        return null;
    }

    private static List<PsiType> getParameterTypes(PsiMethod method) {
        PsiParameter[] parameters;
        ArrayList<PsiType> psiParameterTypes = new ArrayList<PsiType>();
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            psiParameterTypes.add(parameter.getType());
        }
        return psiParameterTypes;
    }

    private static boolean isCompiledElementWithoutSetter(PsiClass springBeanClass, PsiClass[] beanClasses) {
        if (springBeanClass instanceof PsiCompiledElement || springBeanClass.getOriginalElement() instanceof PsiCompiledElement) {
            for (PsiClass beanClass : beanClasses) {
                if (GenerateSpringBeanDependenciesUtil.getExistedSetter(springBeanClass, beanClass) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean hasDependency(CommonSpringBean currentBean, SpringBeanPointer candidateBean, boolean isSetterDependency) {
        return isSetterDependency ? GenerateSpringBeanDependenciesUtil.getSetterDependencies(currentBean).contains(candidateBean) : GenerateSpringBeanDependenciesUtil.getConstructorDependencies(currentBean).contains(candidateBean);
    }

    public static List<SpringBeanPointer> getSetterDependencies(CommonSpringBean springBean) {
        ArrayList<SpringBeanPointer> dependencies = new ArrayList<SpringBeanPointer>();
        if (springBean instanceof DomSpringBean) {
            for (SpringPropertyDefinition property : SpringPropertyUtils.getProperties((CommonSpringBean)springBean)) {
                if (!(property instanceof SpringValueHolder)) continue;
                dependencies.addAll(SpringPropertyUtils.getSpringValueHolderDependencies((SpringValueHolderDefinition)property));
            }
        }
        return dependencies;
    }

    public static List<SpringBeanPointer> getConstructorDependencies(CommonSpringBean springBean) {
        if (springBean instanceof SpringBean) {
            ArrayList<SpringBeanPointer> dependencies = new ArrayList<SpringBeanPointer>();
            for (ConstructorArg arg : ((SpringBean)springBean).getConstructorArgs()) {
                dependencies.addAll(SpringPropertyUtils.getSpringValueHolderDependencies((SpringValueHolderDefinition)arg));
            }
            return dependencies;
        }
        return Collections.emptyList();
    }

    @Nullable
    private static Pair<SpringInjection, SpringGenerateTemplatesHolder> createDependency(SpringBean currentBean, SpringBeanPointer bean, CommonSpringModel model) {
        PsiMethod setter;
        SpringGenerateTemplatesHolder templatesHolder = new SpringGenerateTemplatesHolder(currentBean.getManager().getProject());
        PsiClass currentBeanClass = PsiTypesUtil.getPsiClass((PsiType)currentBean.getBeanType());
        PsiClass[] candidateBeanClasses = GenerateSpringBeanDependenciesUtil.getEffectiveBeanClasses(bean);
        if (currentBeanClass != null && candidateBeanClasses.length > 0 && (setter = GenerateSpringBeanDependenciesUtil.getOrCreateSetter(bean, currentBeanClass, candidateBeanClasses, templatesHolder, model)) != null) {
            SpringProperty property = currentBean.addProperty();
            property.getName().ensureXmlElementExists();
            property.getName().setStringValue(PropertyUtil.getPropertyNameBySetter((PsiMethod)setter));
            property.getRefAttr().setStringValue(GenerateSpringBeanDependenciesUtil.getReferencedName(currentBean, bean));
            return new Pair((Object)property, (Object)templatesHolder);
        }
        return null;
    }

    @Nullable
    private static Pair<SpringInjection, SpringGenerateTemplatesHolder> createConstructorArg(SpringBean currentBean, SpringBeanPointer bean, CommonSpringModel processor) {
        ConstructorArg constructorArg = null;
        SpringGenerateTemplatesHolder holder = new SpringGenerateTemplatesHolder(currentBean.getManager().getProject());
        PsiClass currentBeanClass = PsiTypesUtil.getPsiClass((PsiType)currentBean.getBeanType());
        PsiClass[] candidateBeanClasses = GenerateSpringBeanDependenciesUtil.getEffectiveBeanClasses(bean);
        if (currentBeanClass != null && candidateBeanClasses.length > 0) {
            PsiClass psiClass;
            PsiParameter parameter;
            PsiType type;
            PsiMethod psiMethod;
            PsiMethod existedConstructor = GenerateSpringBeanDependenciesUtil.findExistedConstructor(currentBean, currentBeanClass, candidateBeanClasses);
            if (existedConstructor == null) {
                if (!GenerateSpringBeanDependenciesUtil.ensureFileWritable(currentBeanClass)) {
                    return null;
                }
                existedConstructor = GenerateSpringBeanDependenciesUtil.findProperConstructorAndAddParameter(currentBean, bean, currentBeanClass, candidateBeanClasses[0], holder, processor);
            }
            constructorArg = currentBean.addConstructorArg();
            constructorArg.getRefAttr().setStringValue(GenerateSpringBeanDependenciesUtil.getReferencedName(currentBean, bean));
            if (existedConstructor == null && SpringConstructorArgResolveUtil.findMatchingMethods(currentBean).isEmpty() && (psiMethod = GenerateSpringBeanDependenciesUtil.createConstructor(currentBean)).getParameterList().getParametersCount() == 1 && (type = (parameter = psiMethod.getParameterList().getParameters()[0]).getType()) instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
                GenerateSpringBeanDependenciesUtil.addCreateSetterTemplate(psiMethod, new PsiClass[]{psiClass}, bean, holder, processor);
            }
        }
        return new Pair(constructorArg, (Object)holder);
    }

    @Nullable
    public static String getReferencedName(SpringBean currentBean, SpringBeanPointer bean) {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)currentBean);
        return SpringBeanCoreUtils.getReferencedName(bean, model.getAllCommonBeans());
    }

    @Nullable
    private static PsiMethod getOrCreateSetter(SpringBeanPointer candidateBean, PsiClass currentBeanClass, PsiClass[] candidateBeanClasses, SpringGenerateTemplatesHolder templatesHolder, CommonSpringModel model) {
        for (PsiClass candidateBeanClass : candidateBeanClasses) {
            PsiMethod existedSetter = GenerateSpringBeanDependenciesUtil.getExistedSetter(currentBeanClass, candidateBeanClass);
            if (existedSetter == null) continue;
            return existedSetter;
        }
        boolean isWritable = GenerateSpringBeanDependenciesUtil.ensureFileWritable(currentBeanClass);
        if (!isWritable) {
            return null;
        }
        PsiMethod setter = GenerateSpringBeanDependenciesUtil.createSetter(candidateBean, currentBeanClass, candidateBeanClasses);
        GenerateSpringBeanDependenciesUtil.addCreateSetterTemplate(setter, candidateBeanClasses, candidateBean, templatesHolder, model);
        return setter;
    }

    @Nullable
    public static PsiMethod findExistedConstructor(SpringBean currentBean, PsiClass currentBeanClass, PsiClass[] candidateParameterClasses) {
        List<PsiMethod> constructors = SpringConstructorArgResolveUtil.findMatchingMethods(currentBean);
        for (PsiClass candidateBeanClass : candidateParameterClasses) {
            for (PsiMethod constructor : constructors) {
                List<PsiType> psiParameterTypes = GenerateSpringBeanDependenciesUtil.getParameterTypes(constructor);
                PsiClassType candidateBeanType = PsiTypesUtil.getClassType((PsiClass)candidateBeanClass);
                psiParameterTypes.add((PsiType)candidateBeanType);
                PsiMethod existedConstructorWithRequiredParameter = GenerateSpringBeanDependenciesUtil.findConstructor(currentBeanClass.getConstructors(), psiParameterTypes);
                if (existedConstructorWithRequiredParameter == null) continue;
                return existedConstructorWithRequiredParameter;
            }
        }
        return null;
    }

    @Nullable
    private static PsiMethod findProperConstructorAndAddParameter(SpringBean currentBean, SpringBeanPointer bean, PsiClass currentBeanClass, PsiClass candidateBeanClass, SpringGenerateTemplatesHolder holder, CommonSpringModel processor) {
        PsiMethod properConstructor = currentBean.getResolvedConstructorArgs().getResolvedMethod();
        if (properConstructor != null) {
            GenerateSpringBeanDependenciesUtil.addConstructorParameter(currentBeanClass, candidateBeanClass, properConstructor);
            GenerateSpringBeanDependenciesUtil.addCreateSetterTemplate(properConstructor, new PsiClass[]{candidateBeanClass}, bean, holder, properConstructor.getParameterList().getParametersCount() - 1, processor);
            return properConstructor;
        }
        return null;
    }

    @NotNull
    private static PsiMethod createConstructor(SpringBean springBean) {
        PsiClass instantiationClass = null;
        PsiMethod instantiationMethod = null;
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        try {
            assert (beanClass != null);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory();
            if (GenerateSpringBeanDependenciesUtil.isInstantiatedByFactory(springBean)) {
                SpringBeanPointer beanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
                if (beanPointer != null) {
                    instantiationClass = beanPointer.getBeanClass();
                    String methodName = GenerateSpringBeanDependenciesUtil.getInstantiationMethodName(instantiationClass, springBean);
                    String methodText = "public " + beanClass.getName() + " " + methodName + "() { return null; }";
                    instantiationMethod = elementFactory.createMethodFromText(methodText, null);
                }
            } else if (GenerateSpringBeanDependenciesUtil.isInstantiatedByFactoryMethod(springBean)) {
                instantiationClass = beanClass;
                String methodName = GenerateSpringBeanDependenciesUtil.getInstantiationMethodName(instantiationClass, springBean);
                String methodText = "public static " + beanClass.getName() + " " + methodName + "() { return null; }";
                instantiationMethod = elementFactory.createMethodFromText(methodText, null);
            } else {
                instantiationClass = beanClass;
                instantiationMethod = elementFactory.createConstructor();
            }
            List<PsiParameter> parameters = SpringConstructorArgResolveUtil.suggestParamsForConstructorArgs(springBean);
            assert (instantiationMethod != null);
            for (PsiParameter parameter : parameters) {
                instantiationMethod.getParameterList().add((PsiElement)parameter);
            }
            assert (instantiationClass != null);
            instantiationMethod = (PsiMethod)instantiationClass.add((PsiElement)instantiationMethod);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
        PsiMethod psiMethod = instantiationMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "createConstructor"));
        }
        return psiMethod;
    }

    @NotNull
    private static String getInstantiationMethodName(PsiClass factoryBeanClass, SpringBean springBean) {
        String methodName = springBean.getFactoryMethod().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)methodName)) {
            String string = methodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getInstantiationMethodName"));
            }
            return string;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        String methodPrefix = "create";
        methodName = methodPrefix + beanClass.getName();
        int i = 0;
        while (factoryBeanClass.findMethodsByName(methodName, true).length > 0) {
            methodName = methodPrefix + beanClass.getName() + ++i;
        }
        String string = methodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getInstantiationMethodName"));
        }
        return string;
    }

    private static boolean isInstantiatedByFactoryMethod(SpringBean springBean) {
        return DomUtil.hasXml((DomElement)springBean.getFactoryMethod());
    }

    private static boolean isInstantiatedByFactory(SpringBean springBean) {
        return DomUtil.hasXml((DomElement)springBean.getFactoryBean());
    }

    private static void addConstructorParameter(PsiClass currentBeanClass, PsiClass candidateBeanClass, PsiMethod constructor) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)currentBeanClass.getProject()).getElementFactory();
        try {
            PsiClassType psiClassType = psiElementFactory.createType(candidateBeanClass);
            SuggestedNameInfo nameInfo = JavaCodeStyleManager.getInstance((Project)currentBeanClass.getProject()).suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)psiClassType);
            String name = nameInfo.names[0];
            int i = 0;
            while (GenerateSpringBeanDependenciesUtil.hasSuchName(constructor.getParameterList().getParameters(), name)) {
                name = name + ++i;
            }
            PsiParameter parameter = psiElementFactory.createParameter(name, (PsiType)psiClassType);
            constructor.getParameterList().add((PsiElement)parameter);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasSuchName(PsiParameter[] parameters, String name) {
        for (PsiParameter parameter : parameters) {
            if (!name.equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PsiMethod createSetter(SpringBeanPointer candidateBean, PsiClass currentBeanClass, PsiClass[] candidateBeanClasses) {
        PsiMethod method;
        try {
            PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)currentBeanClass.getProject());
            String beanName = candidateBean.getName();
            String name = beanName == null || !psiNameHelper.isIdentifier(beanName) ? candidateBeanClasses[0].getName() : beanName;
            PsiManager psiManager = currentBeanClass.getManager();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            String methodText = "public void set" + StringUtil.capitalize((String)name) + "(" + candidateBeanClasses[0].getQualifiedName() + " " + StringUtil.decapitalize((String)name) + ") { }";
            method = elementFactory.createMethodFromText(methodText, null);
            method = (PsiMethod)currentBeanClass.add((PsiElement)method);
            GenerateSpringBeanDependenciesUtil.reformat((PsiMember)method);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "createSetter"));
        }
        return psiMethod;
    }

    public static void reformat(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "reformat"));
        }
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)psiMember.getProject());
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiMember.getProject());
        codeStyleManager.shortenClassReferences(formatter.reformat((PsiElement)psiMember));
    }

    private static void addCreateSetterTemplate(PsiMethod method, PsiClass[] psiClasses, SpringBeanPointer bean, SpringGenerateTemplatesHolder templatesHolder, CommonSpringModel model) {
        GenerateSpringBeanDependenciesUtil.addCreateSetterTemplate(method, psiClasses, bean, templatesHolder, 0, model);
    }

    private static void addCreateSetterTemplate(PsiMethod method, PsiClass[] psiClasses, SpringBeanPointer bean, SpringGenerateTemplatesHolder templatesHolder, int paramId, CommonSpringModel model) {
        templatesHolder.addTemplateFactory((PsiElement)method.getParameterList(), (Factory<Template>)((Factory)() -> {
            PsiParameter parameter = method.getParameterList().getParameters()[paramId];
            PsiTypeElement typeElement = parameter.getTypeElement();
            Collection<PsiClass> variants = GenerateSpringBeanDependenciesUtil.getSuperTypeVariants(psiClasses);
            Expression interfaces = GenerateAutowiredDependenciesUtil.getSuperTypesExpression(typeElement.getType().getCanonicalText(), variants);
            Expression ids = GenerateSpringBeanDependenciesUtil.getSuggestNamesExpression(method, GenerateSpringBeanDependenciesUtil.getSuggestedNames(bean, method, paramId), paramId, model);
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method.getParameterList());
            if (variants.size() > 1) {
                builder.replaceElement((PsiElement)typeElement, "type", interfaces, true);
            }
            builder.replaceElement((PsiElement)parameter.getNameIdentifier(), "names", ids, true);
            return builder.buildInlineTemplate();
        }));
    }

    public static Collection<PsiClass> getSuperTypeVariants(PsiClass[] psiClasses) {
        LinkedHashSet<PsiClass> variants = new LinkedHashSet<PsiClass>();
        for (PsiClass beanClass : psiClasses) {
            variants.add(beanClass);
            ContainerUtil.addAll(variants, (Object[])beanClass.getInterfaces());
            for (PsiClass psiClass : beanClass.getSupers()) {
                if (Object.class.getName().equals(psiClass.getQualifiedName())) continue;
                variants.add(psiClass);
            }
        }
        return variants;
    }

    private static Expression getSuggestNamesExpression(PsiMethod method, final Collection<String> suggestedNames, int paramId, CommonSpringModel model) {
        final PsiParameter parameter = method.getParameterList().getParameters()[paramId];
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                PsiIdentifier psiIdentifier = parameter.getNameIdentifier();
                return new TextResult(psiIdentifier != null ? psiIdentifier.getText() : "foo");
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
                for (String name : suggestedNames) {
                    items.add(LookupElementBuilder.create((String)name));
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }

    private static Collection<String> getSuggestedNames(SpringBeanPointer beanPointer, PsiMethod method, int paramId) {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)method.getProject());
        HashSet<String> names = new HashSet<String>();
        for (String name : SpringBeanUtils.getInstance().findBeanNames(beanPointer.getSpringBean())) {
            if (!psiNameHelper.isIdentifier(name)) continue;
            names.add(name);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)method.getProject());
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length < paramId) {
            SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, parameters[paramId].getType());
            ContainerUtil.addAll(names, (Object[])info.names);
        }
        return names;
    }

    @Nullable
    public static PsiMethod getExistedSetter(PsiClass currentBeanClass, PsiClass setterPsiClass) {
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)setterPsiClass.getProject()).getElementFactory().createType(setterPsiClass);
        for (PsiMethod psiMethod : currentBeanClass.getAllMethods()) {
            PsiType type;
            if (!PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod) || !(type = psiMethod.getParameterList().getParameters()[0].getType()).isAssignableFrom((PsiType)psiClassType)) continue;
            return psiMethod;
        }
        return null;
    }

    @Nullable
    public static Module getSpringModule(@NotNull PsiClass psiClass) {
        Module module;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/generate/GenerateSpringBeanDependenciesUtil", "getSpringModule"));
        }
        PsiFile psiFile = psiClass.getContainingFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManagerEx.getInstanceEx((Project)psiClass.getProject()).getFileIndex();
        if (index.isLibraryClassFile(virtualFile) || index.isInLibrarySource(virtualFile)) {
            List orderEntries = index.getOrderEntriesForFile(virtualFile);
            for (OrderEntry orderEntry : orderEntries) {
                Module module2 = orderEntry.getOwnerModule();
                if (!SpringCommonUtils.hasSpringFacet((Module)module2)) continue;
                return module2;
            }
        }
        return SpringCommonUtils.hasSpringFacet((Module)(module = index.getModuleForFile(virtualFile))) ? module : null;
    }
}

