/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringKey;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InjectionValueStyleInspection
extends SpringBeanInspectionBase {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String VALUE_REF = "value-ref";
    @NonNls
    private static final String KEY_REF = "key-ref";
    @NonNls
    private static final String REF = "ref";

    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, Beans beans, XmlSpringModel model) {
        return new SpringModelVisitor(){

            protected boolean visitValueHolder(SpringValueHolder valueHolder) {
                InjectionValueStyleInspection.checkValueHolder(holder, (SpringValueHolderDefinition)valueHolder);
                return true;
            }
        };
    }

    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
        for (SpringValueHolderDefinition property : SpringPropertyUtils.getValueHolders((CommonSpringBean)springBean)) {
            InjectionValueStyleInspection.checkValueHolder(holder, property);
        }
    }

    private static void checkValueHolder(DomElementAnnotationHolder holder, @NotNull SpringValueHolderDefinition valueHolder) {
        if (valueHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueHolder", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection", "checkValueHolder"));
        }
        InjectionValueStyleInspection.checkValue(valueHolder, holder);
        InjectionValueStyleInspection.checkRefBean(valueHolder, holder);
        if (valueHolder instanceof SpringEntry) {
            InjectionValueStyleInspection.checkValue((SpringValueHolderDefinition)((SpringEntry)valueHolder).getKey(), holder);
            InjectionValueStyleInspection.checkRefBean((SpringValueHolderDefinition)((SpringEntry)valueHolder).getKey(), holder);
        }
    }

    private static void checkValue(@NotNull SpringValueHolderDefinition valueHolder, DomElementAnnotationHolder holder) {
        String s;
        if (valueHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueHolder", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection", "checkValue"));
        }
        PsiType type = TypeHolderUtil.getRequiredType((TypeHolder)valueHolder);
        if (type != null && Properties.class.getName().equals(type.getCanonicalText())) {
            return;
        }
        GenericDomValue value = valueHolder.getValueElement();
        if (!(value == null || value instanceof GenericAttributeValue || (s = value.getRawText()) == null || InjectionValueStyleInspection.isMultiline(s) || value instanceof SpringValue && DomUtil.hasXml((DomElement)((SpringValue)value).getType()))) {
            XmlTag tag = value.getXmlTag();
            if (tag != null && tag.getValue().hasCDATA()) {
                return;
            }
            ValueQuickFix fix = new ValueQuickFix(valueHolder);
            holder.createProblem((DomElement)value, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.style.message", new Object[0]), new LocalQuickFix[]{fix}).highlightWholeElement();
        }
    }

    private static boolean isMultiline(String s) {
        return s.trim().indexOf(10) >= 0;
    }

    private static void checkRefBean(SpringValueHolderDefinition valueHolder, DomElementAnnotationHolder holder) {
        SpringRef ref;
        GenericAttributeValue bean;
        if (valueHolder instanceof SpringValueHolder && DomUtil.hasXml((DomElement)(bean = (ref = ((SpringValueHolder)valueHolder).getRef()).getBean()))) {
            RefQuickFix fix = new RefQuickFix((SpringValueHolder)valueHolder);
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.style.ref.message", new Object[0]), new LocalQuickFix[]{fix}).highlightWholeElement();
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringInjectionValueStyleInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection", "getShortName"));
        }
        return "SpringInjectionValueStyleInspection";
    }

    private static class RefQuickFix
    implements LocalQuickFix {
        private final SpringValueHolder myValueHolder;

        public RefQuickFix(SpringValueHolder valueHolder) {
            this.myValueHolder = (SpringValueHolder)valueHolder.createStableCopy();
        }

        @NotNull
        public String getName() {
            String attr = this.myValueHolder instanceof SpringKey ? InjectionValueStyleInspection.KEY_REF : (this.myValueHolder instanceof SpringEntry ? InjectionValueStyleInspection.VALUE_REF : InjectionValueStyleInspection.REF);
            String string = SpringBundle.message("model.inspection.injection.value.style.ref.fix", attr);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$RefQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.ref.fix.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$RefQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$RefQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$RefQuickFix", "applyFix"));
            }
            XmlElement element = this.myValueHolder.getXmlElement();
            if (element == null) {
                return;
            }
            String val = this.myValueHolder.getRef().getBean().getRawText();
            if (this.myValueHolder instanceof SpringKey) {
                SpringEntry entry = (SpringEntry)this.myValueHolder.getParent();
                assert (entry != null);
                entry.getKeyRef().setStringValue(val);
                this.myValueHolder.undefine();
                XmlTag tag = entry.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            } else {
                this.myValueHolder.getRefAttr().setStringValue(val);
                this.myValueHolder.getRef().undefine();
                XmlTag tag = this.myValueHolder.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            }
        }
    }

    private static class ValueQuickFix
    implements LocalQuickFix {
        private final SpringValueHolderDefinition myValueHolder;

        public ValueQuickFix(SpringValueHolderDefinition valueHolder) {
            this.myValueHolder = (SpringValueHolderDefinition)valueHolder.createStableCopy();
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.value.fix", this.myValueHolder instanceof SpringKey ? InjectionValueStyleInspection.KEY : InjectionValueStyleInspection.VALUE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$ValueQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.value.fix.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$ValueQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$ValueQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/InjectionValueStyleInspection$ValueQuickFix", "applyFix"));
            }
            XmlElement xmlElement = this.myValueHolder.getXmlElement();
            if (xmlElement == null) {
                return;
            }
            GenericDomValue valueElement = this.myValueHolder.getValueElement();
            assert (valueElement != null);
            String val = valueElement.getRawText();
            if (this.myValueHolder instanceof SpringKey) {
                SpringEntry entry = (SpringEntry)this.myValueHolder.getParent();
                assert (entry != null);
                entry.getKeyAttr().setStringValue(val);
                this.myValueHolder.undefine();
                XmlTag tag = entry.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            } else {
                if (this.myValueHolder instanceof SpringValueHolder) {
                    SpringValueHolder holder = (SpringValueHolder)this.myValueHolder;
                    holder.getValueAttr().undefine();
                    holder.getValue().undefine();
                }
                GenericDomValue element = this.myValueHolder.getValueElement();
                assert (element != null);
                element.setStringValue(val);
                XmlTag tag = this.myValueHolder.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            }
        }
    }
}

