/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPlaceholdersInspection
extends BasicDomElementsInspection<Beans> {
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof GenericDomValue) {
            XmlElement xmlElement;
            GenericDomValue value = (GenericDomValue)element;
            if (PlaceholderUtils.getInstance().isRawTextPlaceholder(value) && (xmlElement = SpringPlaceholdersInspection.getPlaceholderElement(value)) != null) {
                for (PsiReference psiReference : xmlElement.getReferences()) {
                    ResolveResult[] resolve;
                    PlaceholderPropertyReference placeholderPropertyReference;
                    String defaultValue;
                    if (!(psiReference instanceof PlaceholderPropertyReference) || (defaultValue = (placeholderPropertyReference = (PlaceholderPropertyReference)psiReference).getDefaultValue()) != null || (resolve = placeholderPropertyReference.multiResolve(false)).length != 0) continue;
                    holder.createResolveProblem(value, (PsiReference)placeholderPropertyReference);
                }
            }
        }
    }

    @Nullable
    private static XmlElement getPlaceholderElement(@NotNull GenericDomValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/highlighting/SpringPlaceholdersInspection", "getPlaceholderElement"));
        }
        XmlElement xmlElement = value.getXmlElement();
        if (xmlElement instanceof XmlAttribute) {
            return ((XmlAttribute)xmlElement).getValueElement();
        }
        return xmlElement;
    }

    public SpringPlaceholdersInspection() {
        super(Beans.class, new Class[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringPlaceholdersInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringPlaceholdersInspection", "getShortName"));
        }
        return "SpringPlaceholdersInspection";
    }
}

