/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringQualifierReference
extends PsiReferenceBase.Poly<PsiLiteralExpression> {
    public SpringQualifierReference(PsiLiteralExpression element) {
        super((PsiElement)element);
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    private CommonSpringModel getSpringModel() {
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        if (commonSpringModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierReference", "getSpringModel"));
        }
        return commonSpringModel;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiAnnoClass = SpringQualifierReference.findAnnoPsiClass((PsiLiteralExpression)this.myElement);
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiVariable.class);
        if (psiAnnoClass != null && variable != null) {
            PsiType type = variable.getType();
            CommonSpringModel model = this.getSpringModel();
            Set<SpringBeanPointer> pointers = SpringAutowireUtil.autowireByType(model, type);
            HashSet variants = new HashSet();
            for (SpringBeanPointer beanPointer : pointers) {
                CommonSpringBean bean = beanPointer.getSpringBean();
                SpringQualifier qualifier = bean.getSpringQualifier();
                if (qualifier != null) {
                    String value = qualifier.getQualifierValue();
                    if (value == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                    variants.add(SpringConverterUtil.createCompletionVariant((SpringBeanPointer)beanPointer, (String)value));
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)variants, (Object)SpringConverterUtil.createCompletionVariant((SpringBeanPointer)beanPointer));
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierReference", "getVariants"));
            }
            return objectArray;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiClass psiAnnoClass;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiAnnotation.class);
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class);
        if (member == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Object value = ((PsiLiteralExpression)this.myElement).getValue();
        if (value instanceof String && (psiAnnoClass = SpringQualifierReference.findAnnoPsiClass((PsiLiteralExpression)this.myElement)) != null) {
            PsiElement psiElement;
            SpringBeanPointer springBeanPointer;
            CommonSpringModel model = this.getSpringModel();
            ArrayList<PsiElementResolveResult> results = new ArrayList<PsiElementResolveResult>();
            SpringJamQualifier jamQualifier = new SpringJamQualifier(annotation, null);
            List qualifiedBeans = model.findQualifiedBeans((SpringQualifier)jamQualifier);
            for (SpringBeanPointer beanPointer : qualifiedBeans) {
                CommonSpringBean bean = beanPointer.getSpringBean();
                SpringQualifier qualifier = bean.getSpringQualifier();
                assert (qualifier != null);
                results.add(new PsiElementResolveResult(qualifier.getIdentifyingPsiElement()));
            }
            String qualifierValue = jamQualifier.getQualifierValue();
            if (qualifierValue != null && (springBeanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)qualifierValue)) != null && springBeanPointer.isValid() && (psiElement = springBeanPointer.getPsiElement()) != null) {
                results.add(new PsiElementResolveResult(psiElement));
            }
            ResolveResult[] resolveResultArray = results.toArray(new ResolveResult[results.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierReference", "multiResolve"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiClass findAnnoPsiClass(PsiLiteralExpression expression) {
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class);
        if (annotation == null) {
            return null;
        }
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
        if (module == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(qualifiedName, expression.getResolveScope());
    }
}

