/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import org.jetbrains.annotations.NotNull;

public class ByteSequence {
    private final byte[] myBytes;
    private final int myOffset;
    private final int myLen;

    public ByteSequence(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/util/io/ByteSequence", "<init>"));
        }
        this(bytes, 0, bytes.length);
    }

    public ByteSequence(@NotNull byte[] bytes, int offset2, int len) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/util/io/ByteSequence", "<init>"));
        }
        this.myBytes = bytes;
        this.myOffset = offset2;
        this.myLen = len;
    }

    @NotNull
    public byte[] getBytes() {
        if (this.myBytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/ByteSequence", "getBytes"));
        }
        return this.myBytes;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSequence sequence2 = (ByteSequence)o;
        int len = this.myLen;
        if (len != sequence2.myLen) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = sequence2.myBytes;
        int j = this.myOffset;
        int k = sequence2.myOffset;
        for (int i = 0; i < len; ++i) {
            if (thisBytes[j] == thatBytes[k]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int len = this.myLen;
        byte[] thisBytes = this.myBytes;
        int result2 = 1;
        int j = this.myOffset;
        for (int i = 0; i < len; ++i) {
            result2 = result2 * 31 + thisBytes[j];
        }
        return result2;
    }
}

