/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.KeyboardLayoutUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixingLayoutMatcher
extends MinusculeMatcher {
    @Nullable
    private final MinusculeMatcher myFixedMatcher;

    FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/FixingLayoutMatcher", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/codeStyle/FixingLayoutMatcher", "<init>"));
        }
        super(pattern, options, hardSeparators);
        String s = FixingLayoutMatcher.fixPattern(pattern);
        this.myFixedMatcher = s == null ? null : new MinusculeMatcher(s, options, hardSeparators);
    }

    @Nullable
    private static String fixPattern(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Override
    public boolean matches(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/FixingLayoutMatcher", "matches"));
        }
        return super.matches(name2) || this.myFixedMatcher != null && this.myFixedMatcher.matches(name2);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/FixingLayoutMatcher", "matchingFragments"));
        }
        FList<TextRange> ranges2 = super.matchingFragments(name2);
        if (this.myFixedMatcher == null || ranges2 != null && !ranges2.isEmpty()) {
            return ranges2;
        }
        return this.myFixedMatcher.matchingFragments(name2);
    }
}

