/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.CompiledReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplHistory;
import org.jetbrains.kotlin.cli.common.repl.ReplResettableCodeLine;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.repl.DelegatePackageMemberDeclarationProvider;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplAnalyzer;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.resolve.lazy.FileScopesCustomizer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.script.ScriptPriorities;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003()*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$2\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$2\u0006\u0010'\u001a\u00020 H\u0016R\u0013\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplResettableCodeLine;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "module", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "replState", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "scriptDeclarationFactory", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ScriptMutableDeclarationProviderFactory;", "getStateLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "topDownAnalysisContext", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalyzer", "Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "analyzeReplLine", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ReplLineAnalysisResult;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "doAnalyze", "linePsi", "resetToLine", "", "lineNumber", "", "line", "ReplLineAnalysisResult", "ResettableReplState", "ScriptMutableDeclarationProviderFactory", "kotlin-compiler"})
public final class GenericReplAnalyzer
implements ReplResettableCodeLine {
    private final TopDownAnalysisContext topDownAnalysisContext;
    private final LazyTopDownAnalyzer topDownAnalyzer;
    private final ResolveSession resolveSession;
    private final ScriptMutableDeclarationProviderFactory scriptDeclarationFactory;
    private final ResettableReplState replState;
    @NotNull
    private final ModuleDescriptorImpl module;
    @NotNull
    private final BindingTraceContext trace;
    @NotNull
    private final ReentrantReadWriteLock stateLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ModuleDescriptorImpl getModule() {
        ModuleDescriptorImpl moduleDescriptorImpl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            moduleDescriptorImpl = this.module;
        }
        finally {
            readLock.unlock();
        }
        return moduleDescriptorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BindingTraceContext getTrace() {
        BindingTraceContext bindingTraceContext;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            bindingTraceContext = this.trace;
        }
        finally {
            readLock.unlock();
        }
        return bindingTraceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ReplCodeLine> resetToLine(int lineNumber) {
        List<ReplCodeLine> list2;
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            list2 = this.replState.resetToLine(lineNumber);
        }
        finally {
            n = 0;
            int n5 = n3 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ReplCodeLine> resetToLine(@NotNull ReplCodeLine line) {
        Intrinsics.checkParameterIsNotNull(line, "line");
        return this.resetToLine(line.getNo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ReplLineAnalysisResult analyzeReplLine(@NotNull KtFile psiFile, @NotNull ReplCodeLine codeLine) {
        ReplLineAnalysisResult replLineAnalysisResult;
        int n;
        Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.topDownAnalysisContext.getScripts().clear();
            this.getTrace().clearDiagnostics();
            KtScript ktScript = psiFile.getScript();
            if (ktScript == null) {
                Intrinsics.throwNpe();
            }
            ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, codeLine.getNo());
            replLineAnalysisResult = this.doAnalyze(psiFile, codeLine);
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return replLineAnalysisResult;
    }

    private final ReplLineAnalysisResult doAnalyze(KtFile linePsi, ReplCodeLine codeLine) {
        boolean hasErrors;
        Diagnostics diagnostics;
        TopDownAnalysisContext context;
        block4: {
            boolean bl;
            this.scriptDeclarationFactory.setDelegateFactory(new FileBasedDeclarationProviderFactory(this.resolveSession.getStorageManager(), (Collection<KtFile>)CollectionsKt.listOf(linePsi)));
            this.replState.submitLine(linePsi, codeLine);
            TopDownAnalysisMode topDownAnalysisMode = this.topDownAnalysisContext.getTopDownAnalysisMode();
            Intrinsics.checkExpressionValueIsNotNull((Object)topDownAnalysisMode, "topDownAnalysisContext.topDownAnalysisMode");
            context = LazyTopDownAnalyzer.analyzeDeclarations$default(this.topDownAnalyzer, topDownAnalysisMode, CollectionsKt.listOf(linePsi), null, 4, null);
            if (this.getTrace().get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, linePsi) == null) {
                this.getTrace().record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, linePsi, this.resolveSession.getPackageFragment(FqName.ROOT));
            }
            diagnostics = this.getTrace().getBindingContext().getDiagnostics();
            Iterable $receiver$iv = diagnostics;
            for (Object element$iv : $receiver$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                if (!Intrinsics.areEqual((Object)it.getSeverity(), (Object)Severity.ERROR)) continue;
                bl = true;
                break block4;
            }
            bl = hasErrors = false;
        }
        if (hasErrors) {
            this.replState.lineFailure(linePsi, codeLine);
            Diagnostics diagnostics2 = diagnostics;
            Intrinsics.checkExpressionValueIsNotNull(diagnostics2, "diagnostics");
            return new ReplLineAnalysisResult.WithErrors(diagnostics2);
        }
        LazyScriptDescriptor lazyScriptDescriptor = context.getScripts().get(linePsi.getScript());
        if (lazyScriptDescriptor == null) {
            Intrinsics.throwNpe();
        }
        LazyScriptDescriptor scriptDescriptor = lazyScriptDescriptor;
        this.replState.lineSuccess(linePsi, codeLine, scriptDescriptor);
        ScriptDescriptor scriptDescriptor2 = scriptDescriptor;
        Diagnostics diagnostics3 = diagnostics;
        Intrinsics.checkExpressionValueIsNotNull(diagnostics3, "diagnostics");
        return new ReplLineAnalysisResult.Successful(scriptDescriptor2, diagnostics3);
    }

    @NotNull
    protected final ReentrantReadWriteLock getStateLock() {
        return this.stateLock;
    }

    public GenericReplAnalyzer(@NotNull KotlinCoreEnvironment environment2, @NotNull ReentrantReadWriteLock stateLock) {
        ComponentProvider $receiver$iv;
        ComponentProvider container2;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(stateLock, "stateLock");
        this.stateLock = stateLock;
        this.replState = new ResettableReplState();
        this.trace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
        ComponentProvider componentProvider = container2 = TopDownAnalyzerFacadeForJVM.createContainer$default(TopDownAnalyzerFacadeForJVM.INSTANCE, environment2.getProject(), CollectionsKt.emptyList(), this.getTrace(), environment2.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>(environment2){
            final /* synthetic */ KotlinCoreEnvironment $environment;

            @NotNull
            public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope scope) {
                Intrinsics.checkParameterIsNotNull(scope, "scope");
                return new JvmPackagePartProvider(this.$environment, scope);
            }
            {
                this.$environment = kotlinCoreEnvironment;
                super(1);
            }
        }, container.2.INSTANCE, null, 64, null);
        GenericReplAnalyzer genericReplAnalyzer = this;
        Object object = DslKt.getService($receiver$iv, ModuleDescriptorImpl.class);
        genericReplAnalyzer.module = object;
        $receiver$iv = container2;
        genericReplAnalyzer = this;
        object = DslKt.getService($receiver$iv, ScriptMutableDeclarationProviderFactory.class);
        genericReplAnalyzer.scriptDeclarationFactory = (ScriptMutableDeclarationProviderFactory)object;
        $receiver$iv = container2;
        genericReplAnalyzer = this;
        object = DslKt.getService($receiver$iv, ResolveSession.class);
        genericReplAnalyzer.resolveSession = (ResolveSession)object;
        this.topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.LocalDeclarations, DataFlowInfoFactory.EMPTY, this.resolveSession.getDeclarationScopeProvider());
        $receiver$iv = container2;
        genericReplAnalyzer = this;
        object = DslKt.getService($receiver$iv, LazyTopDownAnalyzer.class);
        genericReplAnalyzer.topDownAnalyzer = (LazyTopDownAnalyzer)object;
    }

    public /* synthetic */ GenericReplAnalyzer(KotlinCoreEnvironment kotlinCoreEnvironment, ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(kotlinCoreEnvironment, reentrantReadWriteLock);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ReplLineAnalysisResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "Successful", "WithErrors", "kotlin-compiler"})
    public static interface ReplLineAnalysisResult {
        @Nullable
        public ScriptDescriptor getScriptDescriptor();

        @NotNull
        public Diagnostics getDiagnostics();

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ReplLineAnalysisResult$Successful;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ReplLineAnalysisResult;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-compiler"})
        public static final class Successful
        implements ReplLineAnalysisResult {
            @NotNull
            private final ScriptDescriptor scriptDescriptor;
            @NotNull
            private final Diagnostics diagnostics;

            @Override
            @NotNull
            public ScriptDescriptor getScriptDescriptor() {
                return this.scriptDescriptor;
            }

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                return this.diagnostics;
            }

            public Successful(@NotNull ScriptDescriptor scriptDescriptor, @NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
                Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
                this.scriptDescriptor = scriptDescriptor;
                this.diagnostics = diagnostics;
            }

            @NotNull
            public final ScriptDescriptor component1() {
                return this.getScriptDescriptor();
            }

            @NotNull
            public final Diagnostics component2() {
                return this.getDiagnostics();
            }

            @NotNull
            public final Successful copy(@NotNull ScriptDescriptor scriptDescriptor, @NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
                Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
                return new Successful(scriptDescriptor, diagnostics);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Successful copy$default(Successful successful, ScriptDescriptor scriptDescriptor, Diagnostics diagnostics, int n, Object object) {
                if ((n & 1) != 0) {
                    scriptDescriptor = successful.getScriptDescriptor();
                }
                if ((n & 2) != 0) {
                    diagnostics = successful.getDiagnostics();
                }
                return successful.copy(scriptDescriptor, diagnostics);
            }

            public String toString() {
                return "Successful(scriptDescriptor=" + this.getScriptDescriptor() + ", diagnostics=" + this.getDiagnostics() + ")";
            }

            public int hashCode() {
                ScriptDescriptor scriptDescriptor = this.getScriptDescriptor();
                Diagnostics diagnostics = this.getDiagnostics();
                return (scriptDescriptor != null ? scriptDescriptor.hashCode() : 0) * 31 + (diagnostics != null ? diagnostics.hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Successful)) break block3;
                        Successful successful = (Successful)object;
                        if (!Intrinsics.areEqual(this.getScriptDescriptor(), successful.getScriptDescriptor()) || !Intrinsics.areEqual(this.getDiagnostics(), successful.getDiagnostics())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ReplLineAnalysisResult$WithErrors;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ReplLineAnalysisResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-compiler"})
        public static final class WithErrors
        implements ReplLineAnalysisResult {
            @NotNull
            private final Diagnostics diagnostics;

            @Override
            @Nullable
            public ScriptDescriptor getScriptDescriptor() {
                return null;
            }

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                return this.diagnostics;
            }

            public WithErrors(@NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
                this.diagnostics = diagnostics;
            }

            @NotNull
            public final Diagnostics component1() {
                return this.getDiagnostics();
            }

            @NotNull
            public final WithErrors copy(@NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
                return new WithErrors(diagnostics);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ WithErrors copy$default(WithErrors withErrors, Diagnostics diagnostics, int n, Object object) {
                if ((n & 1) != 0) {
                    diagnostics = withErrors.getDiagnostics();
                }
                return withErrors.copy(diagnostics);
            }

            public String toString() {
                return "WithErrors(diagnostics=" + this.getDiagnostics() + ")";
            }

            public int hashCode() {
                Diagnostics diagnostics = this.getDiagnostics();
                return diagnostics != null ? diagnostics.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof WithErrors)) break block3;
                        WithErrors withErrors = (WithErrors)object;
                        if (!Intrinsics.areEqual(this.getDiagnostics(), withErrors.getDiagnostics())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ScriptMutableDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProviderFactory;", "()V", "delegateFactory", "rootPackageProvider", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "diagnoseMissingPackageFragment", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "setDelegateFactory", "AdaptablePackageMemberDeclarationProvider", "kotlin-compiler"})
    private static final class ScriptMutableDeclarationProviderFactory
    implements DeclarationProviderFactory {
        private DeclarationProviderFactory delegateFactory;
        private AdaptablePackageMemberDeclarationProvider rootPackageProvider;

        public final void setDelegateFactory(@NotNull DeclarationProviderFactory delegateFactory) {
            Intrinsics.checkParameterIsNotNull(delegateFactory, "delegateFactory");
            this.delegateFactory = delegateFactory;
            PackageMemberDeclarationProvider packageMemberDeclarationProvider = delegateFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
            if (packageMemberDeclarationProvider == null) {
                Intrinsics.throwNpe();
            }
            PackageMemberDeclarationProvider provider = packageMemberDeclarationProvider;
            try {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("rootPackageProvider");
                }
                PackageMemberDeclarationProvider packageMemberDeclarationProvider2 = provider;
                Intrinsics.checkExpressionValueIsNotNull(packageMemberDeclarationProvider2, "provider");
                adaptablePackageMemberDeclarationProvider.addDelegateProvider(packageMemberDeclarationProvider2);
            }
            catch (UninitializedPropertyAccessException e) {
                PackageMemberDeclarationProvider packageMemberDeclarationProvider3 = provider;
                Intrinsics.checkExpressionValueIsNotNull(packageMemberDeclarationProvider3, "provider");
                this.rootPackageProvider = new AdaptablePackageMemberDeclarationProvider(packageMemberDeclarationProvider3);
            }
        }

        @Override
        @NotNull
        public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
            Intrinsics.checkParameterIsNotNull(classLikeInfo, "classLikeInfo");
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
            }
            ClassMemberDeclarationProvider classMemberDeclarationProvider = declarationProviderFactory2.getClassMemberDeclarationProvider(classLikeInfo);
            Intrinsics.checkExpressionValueIsNotNull(classMemberDeclarationProvider, "delegateFactory.getClass\u2026onProvider(classLikeInfo)");
            return classMemberDeclarationProvider;
        }

        @Override
        @Nullable
        public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            if (packageFqName.isRoot()) {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("rootPackageProvider");
                }
                return adaptablePackageMemberDeclarationProvider;
            }
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
            }
            return declarationProviderFactory2.getPackageMemberDeclarationProvider(packageFqName);
        }

        @Override
        public void diagnoseMissingPackageFragment(@NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
            }
            declarationProviderFactory2.diagnoseMissingPackageFragment(file2);
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/cli/jvm/repl/DelegatePackageMemberDeclarationProvider;", "delegateProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "(Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;)V", "addDelegateProvider", "", "provider", "kotlin-compiler"})
        public static final class AdaptablePackageMemberDeclarationProvider
        extends DelegatePackageMemberDeclarationProvider {
            private PackageMemberDeclarationProvider delegateProvider;

            public final void addDelegateProvider(@NotNull PackageMemberDeclarationProvider provider) {
                Intrinsics.checkParameterIsNotNull(provider, "provider");
                this.delegateProvider = new CombinedPackageMemberDeclarationProvider((Collection<? extends PackageMemberDeclarationProvider>)CollectionsKt.listOf(new PackageMemberDeclarationProvider[]{provider, this.delegateProvider}));
                this.setDelegate(this.delegateProvider);
            }

            public AdaptablePackageMemberDeclarationProvider(@NotNull PackageMemberDeclarationProvider delegateProvider) {
                Intrinsics.checkParameterIsNotNull(delegateProvider, "delegateProvider");
                super(delegateProvider);
                this.delegateProvider = delegateProvider;
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u001c\u001a\u00020\u0014J\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState;", "", "()V", "submittedLines", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo;", "Lkotlin/collections/HashMap;", "successfulLines", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistory;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "computeFileScopes", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "lineInfo", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "lineFailure", "", "ktFile", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "lineSuccess", "scriptDescriptor", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;", "resetToLine", "", "lineNumber", "", "line", "submitLine", "LineInfo", "kotlin-compiler"})
    public static final class ResettableReplState {
        private final ReplHistory<LineInfo.SuccessfulLine> successfulLines = new ReplHistory(null, 1, null);
        private final HashMap<KtFile, LineInfo> submittedLines;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ReplCodeLine> resetToLine(int lineNumber) {
            void $receiver$iv$iv;
            List<Pair<ReplCodeLine, LineInfo.SuccessfulLine>> removed = this.successfulLines.resetToLine(lineNumber);
            Iterable $receiver$iv = removed;
            for (Object element$iv : $receiver$iv) {
                Pair it = (Pair)element$iv;
                this.submittedLines.remove(((LineInfo.SuccessfulLine)it.getSecond()).getLinePsi());
            }
            $receiver$iv = removed;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair $i$f$forEach = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                ReplCodeLine replCodeLine = (ReplCodeLine)it.getFirst();
                collection.add(replCodeLine);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<ReplCodeLine> resetToLine(@NotNull ReplCodeLine line) {
            Intrinsics.checkParameterIsNotNull(line, "line");
            return this.resetToLine(line.getNo());
        }

        public final void submitLine(@NotNull KtFile ktFile, @NotNull ReplCodeLine codeLine) {
            Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
            Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
            LineInfo.SubmittedLine line = new LineInfo.SubmittedLine(ktFile, this.successfulLines.lastValue());
            Map map2 = this.submittedLines;
            LineInfo.SubmittedLine submittedLine = line;
            map2.put(ktFile, submittedLine);
            FileScopeProviderKt.setFileScopesCustomizer(ktFile, new FileScopesCustomizer(this, ktFile){
                final /* synthetic */ ResettableReplState this$0;
                final /* synthetic */ KtFile $ktFile;

                @NotNull
                public FileScopes createFileScopes(@NotNull FileScopeFactory fileScopeFactory) {
                    Object object;
                    block3: {
                        block2: {
                            LineInfo lineInfo;
                            LineInfo it;
                            Intrinsics.checkParameterIsNotNull(fileScopeFactory, "fileScopeFactory");
                            object = ResettableReplState.access$lineInfo(this.this$0, this.$ktFile);
                            if (object == null) break block2;
                            LineInfo lineInfo2 = it = (lineInfo = object);
                            Intrinsics.checkExpressionValueIsNotNull(lineInfo2, "it");
                            object = ResettableReplState.access$computeFileScopes(this.this$0, lineInfo2, fileScopeFactory);
                            if (object != null) break block3;
                        }
                        object = FileScopeFactory.createScopesForFile$default(fileScopeFactory, this.$ktFile, null, 2, null);
                    }
                    return object;
                }
                {
                    this.this$0 = $outer;
                    this.$ktFile = $captured_local_variable$1;
                }
            });
        }

        public final void lineSuccess(@NotNull KtFile ktFile, @NotNull ReplCodeLine codeLine, @NotNull LazyScriptDescriptor scriptDescriptor) {
            Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
            Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            LineInfo.SuccessfulLine successfulLine = new LineInfo.SuccessfulLine(ktFile, this.successfulLines.lastValue(), scriptDescriptor);
            Map map2 = this.submittedLines;
            LineInfo.SuccessfulLine successfulLine2 = successfulLine;
            map2.put(ktFile, successfulLine2);
            String string = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "ktFile.name");
            this.successfulLines.add(new CompiledReplCodeLine(string, codeLine), successfulLine);
        }

        public final void lineFailure(@NotNull KtFile ktFile, @NotNull ReplCodeLine codeLine) {
            Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
            Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
            Map map2 = this.submittedLines;
            LineInfo.FailedLine failedLine = new LineInfo.FailedLine(ktFile, this.successfulLines.lastValue());
            map2.put(ktFile, failedLine);
        }

        private final LineInfo lineInfo(KtFile ktFile) {
            return this.submittedLines.get(ktFile);
        }

        private final FileScopes computeFileScopes(LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
            HierarchicalScope element$iv;
            Object lexicalScopeAfterLastLine;
            block3: {
                Object object = lineInfo.getParentLine();
                if (object == null || (object = ((LineInfo.SuccessfulLine)object).getLineDescriptor()) == null || (object = ((LazyClassDescriptor)object).getScopeForInitializerResolution()) == null) {
                    return null;
                }
                lexicalScopeAfterLastLine = object;
                Sequence<HierarchicalScope> $receiver$iv = ScopeUtilsKt.getParentsWithSelf((HierarchicalScope)lexicalScopeAfterLastLine);
                Iterator<HierarchicalScope> iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    HierarchicalScope it = element$iv;
                    if (!(it instanceof ImportingScope)) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            HierarchicalScope hierarchicalScope = element$iv;
            if (hierarchicalScope == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.ImportingScope");
            }
            ImportingScope lastLineImports = (ImportingScope)hierarchicalScope;
            FileScopes scopesForThisLine = fileScopeFactory.createScopesForFile(lineInfo.getLinePsi(), lastLineImports);
            LexicalScope combinedLexicalScopes = ScopeUtilsKt.replaceImportingScopes((LexicalScope)lexicalScopeAfterLastLine, scopesForThisLine.getImportingScope());
            return new FileScopes(combinedLexicalScopes, scopesForThisLine.getImportingScope(), scopesForThisLine.getImportResolver());
        }

        public ResettableReplState() {
            ResettableReplState resettableReplState = this;
            HashMap hashMap = new HashMap();
            resettableReplState.submittedLines = hashMap;
        }

        @Nullable
        public static final /* synthetic */ LineInfo access$lineInfo(ResettableReplState $this, @NotNull KtFile ktFile) {
            return $this.lineInfo(ktFile);
        }

        @Nullable
        public static final /* synthetic */ FileScopes access$computeFileScopes(ResettableReplState $this, @NotNull LineInfo lineInfo, @NotNull FileScopeFactory fileScopeFactory) {
            return $this.computeFileScopes(lineInfo, fileScopeFactory);
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo;", "", "()V", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "getParentLine", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "FailedLine", "SubmittedLine", "SuccessfulLine", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$FailedLine;", "kotlin-compiler"})
        private static abstract class LineInfo {
            @NotNull
            public abstract KtFile getLinePsi();

            @Nullable
            public abstract SuccessfulLine getParentLine();

            private LineInfo() {
            }

            public /* synthetic */ LineInfo(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "kotlin-compiler"})
            public static final class SubmittedLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                public SubmittedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                    Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                }
            }

            @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "lineDescriptor", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;)V", "getLineDescriptor", "()Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "kotlin-compiler"})
            public static final class SuccessfulLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;
                @NotNull
                private final LazyScriptDescriptor lineDescriptor;

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                @NotNull
                public final LazyScriptDescriptor getLineDescriptor() {
                    return this.lineDescriptor;
                }

                public SuccessfulLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine, @NotNull LazyScriptDescriptor lineDescriptor) {
                    Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                    Intrinsics.checkParameterIsNotNull(lineDescriptor, "lineDescriptor");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                    this.lineDescriptor = lineDescriptor;
                }
            }

            @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$FailedLine;", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplAnalyzer$ResettableReplState$LineInfo$SuccessfulLine;", "kotlin-compiler"})
            public static final class FailedLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                public FailedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                    Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                }
            }
        }
    }
}

