/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.BackwardAnalysisInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.ControlFlowGraph;
import org.jetbrains.kotlin.codegen.optimization.common.VarFrame;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\u00a8\u0006\b"}, d2={"analyze", "", "F", "Lorg/jetbrains/kotlin/codegen/optimization/common/VarFrame;", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/kotlin/codegen/optimization/common/BackwardAnalysisInterpreter;", "kotlin-compiler"})
public final class BackwardAnalysisKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <F extends VarFrame<F>> List<F> analyze(@NotNull MethodNode node, @NotNull BackwardAnalysisInterpreter<F> interpreter) {
        boolean wereChanges;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(interpreter, "interpreter");
        ControlFlowGraph graph2 = ControlFlowGraph.Companion.build(node);
        InsnList insnList = node.instructions;
        Iterable iterable = $receiver$iv = (Iterable)new IntRange(1, insnList.size());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            F f = interpreter.newFrame(node.maxLocals);
            collection.add(f);
        }
        List frames2 = CollectionsKt.toMutableList((List)destination$iv$iv);
        AbstractInsnNode[] insnArray = insnList.toArray();
        do {
            wereChanges = false;
            for (int i = 0; i < insnArray.length; ++i) {
                AbstractInsnNode insn = insnArray[i];
                int index2 = insnList.indexOf(insn);
                VarFrame newFrame = interpreter.newFrame(node.maxLocals);
                AbstractInsnNode abstractInsnNode = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
                Iterator<Integer> iterator3 = graph2.getSuccessorsIndices(abstractInsnNode).iterator();
                while (iterator3.hasNext()) {
                    int successorIndex = ((Number)iterator3.next()).intValue();
                    newFrame.mergeFrom((VarFrame)((VarFrame)frames2.get(successorIndex)));
                }
                AbstractInsnNode abstractInsnNode2 = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode2, "insn");
                interpreter.def(newFrame, abstractInsnNode2);
                AbstractInsnNode abstractInsnNode3 = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode3, "insn");
                interpreter.use(newFrame, abstractInsnNode3);
                if (!(Intrinsics.areEqual((VarFrame)frames2.get(index2), newFrame) ^ true)) continue;
                frames2.set(index2, newFrame);
                wereChanges = true;
            }
        } while (wereChanges);
        return frames2;
    }
}

