/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsBinaryOperation
extends JsExpression {
    private JsExpression arg1;
    private JsExpression arg2;
    @NotNull
    private final JsBinaryOperator op;

    public JsBinaryOperation(@NotNull JsBinaryOperator op, @Nullable JsExpression arg1, @Nullable JsExpression arg2) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "org/jetbrains/kotlin/js/backend/ast/JsBinaryOperation", "<init>"));
        }
        this.op = op;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    public JsExpression getArg1() {
        return this.arg1;
    }

    public JsExpression getArg2() {
        return this.arg2;
    }

    public void setArg1(JsExpression arg1) {
        this.arg1 = arg1;
    }

    public void setArg2(JsExpression arg2) {
        this.arg2 = arg2;
    }

    @NotNull
    public JsBinaryOperator getOperator() {
        JsBinaryOperator jsBinaryOperator = this.op;
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsBinaryOperation", "getOperator"));
        }
        return jsBinaryOperator;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitBinaryExpression(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.op.isAssignment()) {
            visitor2.acceptLvalue(this.arg1);
        } else {
            visitor2.accept(this.arg1);
        }
        visitor2.accept(this.arg2);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.arg1 = this.op.isAssignment() ? v.acceptLvalue(this.arg1) : v.accept(this.arg1);
            this.arg2 = v.accept(this.arg2);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsExpression deepCopy() {
        JsExpression jsExpression = new JsBinaryOperation(this.op, AstUtil.deepCopy(this.arg1), AstUtil.deepCopy(this.arg2)).withMetadataFrom(this);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsBinaryOperation", "deepCopy"));
        }
        return jsExpression;
    }
}

