/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import com.google.common.collect.ImmutableSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J,\u0010\n\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AssignmentBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "getSupportTokens", "Lcom/google/common/collect/ImmutableSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "CharAssignmentIntrinsic", "kotlin-compiler"})
public final class AssignmentBOIF
implements BinaryOperationIntrinsicFactory {
    public static final AssignmentBOIF INSTANCE;

    public ImmutableSet<KtSingleValueToken> getSupportTokens() {
        return ImmutableSet.of(KtTokens.EQ);
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @Nullable KotlinType leftType, @Nullable KotlinType rightType) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (leftType != null && !KotlinBuiltIns.isCharOrNullableChar(leftType) && rightType != null && KotlinBuiltIns.isCharOrNullableChar(rightType)) {
            return CharAssignmentIntrinsic.INSTANCE;
        }
        return null;
    }

    private AssignmentBOIF() {
        INSTANCE = this;
    }

    static {
        new AssignmentBOIF();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AssignmentBOIF$CharAssignmentIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "kotlin-compiler"})
    private static final class CharAssignmentIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CharAssignmentIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            return new JsBinaryOperation(operator, left, JsAstUtils.charToBoxedChar(right));
        }

        private CharAssignmentIntrinsic() {
            INSTANCE = this;
        }

        static {
            new CharAssignmentIntrinsic();
        }
    }
}

