/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;

public final class KtStubbedPsiUtil {
    @Nullable
    public static KtDeclaration getContainingDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getContainingDeclaration"));
        }
        return KtStubbedPsiUtil.getPsiOrStubParent(element, KtDeclaration.class, true);
    }

    @Nullable
    public static <T extends KtDeclaration> T getContainingDeclaration(@NotNull PsiElement element, @NotNull Class<T> declarationClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getContainingDeclaration"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getContainingDeclaration"));
        }
        return (T)((KtDeclaration)KtStubbedPsiUtil.getPsiOrStubParent(element, declarationClass, true));
    }

    @Nullable
    public static <T extends KtElement> T getPsiOrStubParent(@NotNull PsiElement element, @NotNull Class<T> declarationClass, boolean strict) {
        Object stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getPsiOrStubParent"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getPsiOrStubParent"));
        }
        if (!strict && declarationClass.isInstance(element)) {
            return (T)((KtElement)element);
        }
        if (element instanceof KtElementImplStub && (stub = ((KtElementImplStub)element).getStub()) != null) {
            return (T)((KtElement)stub.getParentStubOfType(declarationClass));
        }
        return (T)((KtElement)PsiTreeUtil.getParentOfType(element, declarationClass, strict));
    }

    @Nullable
    public static <T extends KtElement> T getStubOrPsiChild(@NotNull KtElementImplStub<?> element, @NotNull TokenSet types, @NotNull ArrayFactory<T> factory2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getStubOrPsiChild"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getStubOrPsiChild"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/psi/KtStubbedPsiUtil", "getStubOrPsiChild"));
        }
        KtElement[] typeElements = (KtElement[])element.getStubOrPsiChildren(types, factory2);
        if (typeElements.length == 0) {
            return null;
        }
        return (T)typeElements[0];
    }

    private KtStubbedPsiUtil() {
    }
}

