/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetEditorsFactory;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacetConfiguration;
import com.intellij.javaee.ejb.facet.EjbFacetImpl;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfigurationBase;
import com.intellij.javaee.facet.JavaeeFacetEditorValidator;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.javaee.module.view.ejb.EjbFacetEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;

public class EjbFacetConfigurationImpl
extends JavaeeFacetConfigurationBase
implements EjbFacetConfiguration {
    private List<String> mySourceRoots = new ArrayList<String>();

    protected EjbFacetConfigurationImpl(ConfigFileMetaDataProvider metaDataProvider) {
        super(metaDataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacetEditorTab[] createEditorTabs(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        EjbFacetImpl facet = (EjbFacetImpl)context.getFacet();
        DumbService dumbService = DumbService.getInstance((Project)facet.getModule().getProject());
        dumbService.setAlternativeResolveEnabled(true);
        try {
            JavaeeVersion javaeeVersion = EjbUtil.getJavaeeVersion(EjbUtil.getVersion(facet));
            FacetLibrariesValidator validator = FacetEditorsFactory.getInstance().createLibrariesValidator(JavaeeLibrariesUtil.getJavaeeLibraryInfos(javaeeVersion), new FacetLibrariesValidatorDescription(javaeeVersion.getPresentableName()), context, validatorsManager);
            validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
            validatorsManager.registerValidator((FacetEditorValidator)new JavaeeFacetEditorValidator((JavaeeFacet)facet, context), new JComponent[0]);
            FacetEditorTab[] facetEditorTabArray = new FacetEditorTab[]{new EjbFacetEditor(facet, context, validatorsManager)};
            return facetEditorTabArray;
        }
        finally {
            dumbService.setAlternativeResolveEnabled(false);
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        Element child = element.getChild("ejbRoots");
        if (child != null) {
            List list = child.getChildren("root");
            for (Element root : list) {
                String url = root.getAttributeValue("url");
                this.mySourceRoots.add(url);
            }
        }
    }

    public void setSourceRoots(List<String> sourceRoots) {
        this.mySourceRoots = sourceRoots;
    }

    public List<String> getSourceRoots() {
        return this.mySourceRoots;
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        Element roots = new Element("ejbRoots");
        for (String url : this.mySourceRoots) {
            Element root = new Element("root");
            root.setAttribute("url", url);
            roots.addContent(root);
        }
        element.addContent(roots);
    }
}

