/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.permissions;

import com.intellij.jam.view.JamUserResponse;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.MethodIntf;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.ContainerTransaction;
import com.intellij.javaee.model.xml.ejb.ExcludeList;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodContainer;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.javaee.model.xml.ejb.MethodPermission;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.ArrayConsumer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.AbstractMethodParams;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodContainerHelper {
    protected abstract void processMethods(Processor<Method> var1);

    @NotNull
    private List<Method> collectAttributes(Condition<Method> condition) {
        ArrayList<Method> result = new ArrayList<Method>();
        this.processMethods((Processor<Method>)new FilteringProcessor(condition, (Processor)new CommonProcessors.CollectProcessor(result)));
        ArrayList<Method> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/permissions/MethodContainerHelper", "collectAttributes"));
        }
        return arrayList;
    }

    @NotNull
    public final List<Method> getEjbAttributes(EnterpriseBean ejb) {
        List<Method> list = this.collectAttributes((Condition<Method>)((Condition)attr -> Comparing.equal((String)((String)ejb.getEjbName().getValue()), (String)attr.getEnterpriseBean().getStringValue()) && attr.getMethodIntf().getValue() == null && "*".equals(attr.getMethod().getStringValue())));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/permissions/MethodContainerHelper", "getEjbAttributes"));
        }
        return list;
    }

    @Nullable
    private static PsiClass getPsiClassByType(EnterpriseBean ejb, MethodIntf methodIntf) {
        if (methodIntf == null) {
            return null;
        }
        switch (methodIntf) {
            case HOME: {
                return ejb instanceof EjbWithHome ? (PsiClass)((EjbWithHome)ejb).getHome().getValue() : null;
            }
            case LOCAL: {
                return ejb instanceof EjbWithHome ? (PsiClass)((EjbWithHome)ejb).getLocal().getValue() : null;
            }
            case LOCAL_HOME: {
                return ejb instanceof EjbWithHome ? (PsiClass)((EjbWithHome)ejb).getLocalHome().getValue() : null;
            }
            case MESSAGE_ENDPOINT: {
                return ejb instanceof MessageDrivenBean ? (PsiClass)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue() : null;
            }
            case REMOTE: {
                return ejb instanceof EjbWithHome ? (PsiClass)((EjbWithHome)ejb).getRemote().getValue() : null;
            }
            case SERVICE_ENDPOINT: {
                return ejb instanceof SessionBean ? (PsiClass)((SessionBean)ejb).getServiceEndpoint().getValue() : null;
            }
            case TIMER: {
                return (PsiClass)ejb.getEjbClass().getValue();
            }
        }
        return null;
    }

    protected boolean set(boolean set, String role) {
        return set;
    }

    public final List<Method> getClassAttributes(PsiClass psiClass, EnterpriseBean ejb) {
        return this.collectAttributes((Condition<Method>)((Condition)attr -> Comparing.equal((String)((String)ejb.getEjbName().getValue()), (String)attr.getEnterpriseBean().getStringValue()) && Comparing.equal((Object)psiClass, (Object)MethodContainerHelper.getPsiClassByType(ejb, (MethodIntf)attr.getMethodIntf().getValue())) && "*".equals(attr.getMethod().getStringValue())));
    }

    public final List<Method> getMethodAttributes(PsiMethod psiMethod, PsiClass psiClass, EnterpriseBean ejb) {
        return this.collectAttributes((Condition<Method>)((Condition)attr -> {
            if (!Comparing.equal((String)((String)ejb.getEjbName().getValue()), (String)attr.getEnterpriseBean().getStringValue())) {
                return false;
            }
            PsiClass psiClassByType = MethodContainerHelper.getPsiClassByType(ejb, (MethodIntf)attr.getMethodIntf().getValue());
            if (psiClassByType != null && !Comparing.equal((Object)psiClass, (Object)psiClassByType)) {
                return false;
            }
            return MethodContainerHelper.methodsHaveEqualSignatures(psiMethod, attr);
        }));
    }

    private static boolean methodsHaveEqualSignatures(PsiMethod psiMethod, Method attr) {
        return Comparing.equal((String)psiMethod.getName(), (String)attr.getMethod().getStringValue()) && AbstractMethodResolveConverter.methodParamsMatchSignature((AbstractMethodParams)attr.getMethodParams(), (PsiMethod)psiMethod);
    }

    @Nullable
    protected abstract Method getRelevantMethodAttribute(List<Method> var1, EnterpriseBean var2, String var3, boolean var4);

    public final void setEjbAttribute(EnterpriseBean ejb, String role, boolean set, JamUserResponse response) {
        List<Method> list = this.getEjbAttributes(ejb);
        set = this.set(set, role);
        Method newAttr = this.getRelevantMethod(list, ejb, role, set);
        if (set) {
            assert (newAttr != null);
            newAttr.getMethod().setStringValue("*");
        } else {
            MethodContainerHelper.deleteMethod(newAttr, response);
        }
    }

    private static void deleteMethod(Method newAttr, JamUserResponse response) {
        EjbUtil.deleteModelElement((JavaeeModelElement)newAttr, response);
    }

    @Nullable
    private Method getRelevantMethod(List<Method> list, EnterpriseBean ejb, String role, boolean wantToSet) {
        Method method = this.getRelevantMethodAttribute(list, ejb, role, wantToSet);
        if (method != null) {
            method.getEnterpriseBean().setStringValue((String)ejb.getEjbName().getValue());
        }
        return method;
    }

    @NotNull
    private static MethodIntf[] getClassRoles(PsiClass psiClass, EnterpriseBean ejb) {
        if (psiClass == null) {
            MethodIntf[] methodIntfArray = new MethodIntf[]{};
            if (methodIntfArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/permissions/MethodContainerHelper", "getClassRoles"));
            }
            return methodIntfArray;
        }
        PsiManager manager = psiClass.getManager();
        ArrayList<MethodIntf> result = new ArrayList<MethodIntf>();
        if (ejb instanceof EjbWithHome && manager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)((EjbWithHome)ejb).getHome().getValue())) {
            result.add(MethodIntf.HOME);
        }
        if (ejb instanceof EjbWithHome && manager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)((EjbWithHome)ejb).getLocal().getValue())) {
            result.add(MethodIntf.LOCAL);
        }
        if (ejb instanceof EjbWithHome && manager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)((EjbWithHome)ejb).getLocalHome().getValue())) {
            result.add(MethodIntf.LOCAL_HOME);
        }
        if (ejb instanceof MessageDrivenBean && manager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue())) {
            result.add(MethodIntf.MESSAGE_ENDPOINT);
        }
        if (ejb instanceof EjbWithHome && manager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)((EjbWithHome)ejb).getRemote().getValue())) {
            result.add(MethodIntf.REMOTE);
        }
        if (ejb instanceof SessionBean && manager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)((SessionBean)ejb).getServiceEndpoint().getValue())) {
            result.add(MethodIntf.SERVICE_ENDPOINT);
        }
        MethodIntf[] methodIntfArray = result.toArray(new MethodIntf[result.size()]);
        if (methodIntfArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/permissions/MethodContainerHelper", "getClassRoles"));
        }
        return methodIntfArray;
    }

    public final void setClassAttribute(PsiClass psiClass, EnterpriseBean ejb, String role, boolean set, JamUserResponse response) {
        List<Method> ejbAttributes = this.getClassAttributes(psiClass, ejb);
        set = this.set(set, role);
        Method newAttr = this.getRelevantMethod(ejbAttributes, ejb, role, set);
        if (set) {
            assert (newAttr != null);
            MethodIntf[] roles = MethodContainerHelper.getClassRoles(psiClass, ejb);
            if (roles.length > 0) {
                newAttr.getMethodIntf().setValue((Object)roles[0]);
            }
            newAttr.getMethod().setStringValue("*");
        } else {
            MethodContainerHelper.deleteMethod(newAttr, response);
        }
    }

    public final void setMethodAttribute(PsiMethod psiMethod, PsiClass psiClass, EnterpriseBean ejb, String role, boolean set, JamUserResponse response) {
        List<Method> ejbAttributes = this.getMethodAttributes(psiMethod, psiClass, ejb);
        set = this.set(set, role);
        Method newAttr = this.getRelevantMethod(ejbAttributes, ejb, role, set);
        if (set) {
            assert (newAttr != null);
            MethodIntf[] roles = MethodContainerHelper.getClassRoles(psiClass, ejb);
            if (roles.length > 0) {
                newAttr.getMethodIntf().setValue((Object)roles[0]);
            }
            newAttr.getMethod().setStringValue(psiMethod.getName());
            MethodParams methodParams = newAttr.getMethodParams();
            methodParams.undefine();
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                methodParams.addMethodParam().setValue((Object)parameter.getType());
            }
        } else {
            MethodContainerHelper.deleteMethod(newAttr, response);
        }
    }

    public static void processMethods(EjbFacet facet, MethodContainer container, ArrayConsumer<Object> consumer) {
        for (Method method : container.getMethods()) {
            EnterpriseBean bean = (EnterpriseBean)method.getEnterpriseBean().getValue();
            PsiClass psiClass = MethodContainerHelper.getPsiClassByType(bean, (MethodIntf)method.getMethodIntf().getValue());
            String name = method.getMethod().getStringValue();
            if ("*".equals(name)) {
                if (psiClass != null) {
                    consumer.consume(new Object[]{facet, bean, psiClass});
                } else {
                    consumer.consume(new Object[]{facet, bean});
                }
            }
            if (psiClass == null) continue;
            for (PsiMethod psiMethod : psiClass.findMethodsByName(name, true)) {
                if (!MethodContainerHelper.methodsHaveEqualSignatures(psiMethod, method)) continue;
                consumer.consume(new Object[]{facet, bean, psiClass, psiMethod});
            }
        }
    }

    public static boolean containsRoleWithName(MethodPermission permission, String role) {
        List roleNames = permission.getRoleNames();
        if (roleNames.isEmpty()) {
            return role == null;
        }
        for (GenericDomValue roleName : roleNames) {
            if (!Comparing.strEqual((String)roleName.getStringValue(), (String)role)) continue;
            return true;
        }
        return false;
    }

    public static class ContainerTransactionHelper
    extends MethodContainerHelper {
        private final AssemblyDescriptor myAssemblyDescriptor;

        public ContainerTransactionHelper(AssemblyDescriptor assemblyDescriptor) {
            this.myAssemblyDescriptor = assemblyDescriptor;
        }

        @Override
        protected void processMethods(Processor<Method> processor) {
            for (ContainerTransaction permission : this.myAssemblyDescriptor.getContainerTransactions()) {
                for (Method method : permission.getMethods()) {
                    processor.process((Object)method);
                }
            }
        }

        @Override
        protected boolean set(boolean set, String role) {
            return set && !Comparing.strEqual((String)role, null);
        }

        @Override
        protected Method getRelevantMethodAttribute(List<Method> ejbAttributes, EnterpriseBean ejb, String transAttribute, boolean wantToSet) {
            boolean empty = ejbAttributes.isEmpty();
            if (empty && !wantToSet) {
                return null;
            }
            Method newAttr = empty ? this.myAssemblyDescriptor.addContainerTransaction().addMethod() : ejbAttributes.get(0);
            ((ContainerTransaction)newAttr.getParent()).getTransAttribute().setStringValue(transAttribute);
            return newAttr;
        }
    }

    public static class MethodPermissionHelper
    extends MethodContainerHelper {
        private final AssemblyDescriptor myAssemblyDescriptor;

        public MethodPermissionHelper(AssemblyDescriptor assemblyDescriptor) {
            this.myAssemblyDescriptor = assemblyDescriptor;
        }

        @Override
        protected void processMethods(Processor<Method> processor) {
            for (MethodPermission permission : this.myAssemblyDescriptor.getMethodPermissions()) {
                for (Method method : permission.getMethods()) {
                    processor.process((Object)method);
                }
            }
        }

        @Override
        protected Method getRelevantMethodAttribute(List<Method> ejbAttributes, EnterpriseBean ejb, String role, boolean wantToSet) {
            Method newAttr = null;
            for (Method methodAttribute : ejbAttributes) {
                MethodPermission permission = (MethodPermission)methodAttribute.getParent();
                if (!MethodPermissionHelper.containsRoleWithName(permission, role)) continue;
                newAttr = methodAttribute;
                break;
            }
            if (newAttr == null) {
                if (!wantToSet) {
                    return null;
                }
                newAttr = this.myAssemblyDescriptor.addMethodPermission().addMethod();
            }
            MethodPermission permission = (MethodPermission)newAttr.getParent();
            if (role != null) {
                List roleNames = permission.getRoleNames();
                if (roleNames.isEmpty()) {
                    permission.addRoleName().setStringValue(role);
                } else {
                    ((GenericDomValue)roleNames.get(0)).setStringValue(role);
                }
            } else {
                permission.getUnchecked().setValue((Object)Boolean.TRUE);
            }
            return newAttr;
        }
    }

    public static class ExcludeListHelper
    extends MethodContainerHelper {
        private final ExcludeList myExcludeList;

        public ExcludeListHelper(ExcludeList excludeList) {
            this.myExcludeList = excludeList;
        }

        @Override
        protected void processMethods(Processor<Method> processor) {
            for (Method method : this.myExcludeList.getMethods()) {
                processor.process((Object)method);
            }
        }

        @Override
        protected Method getRelevantMethodAttribute(List<Method> ejbAttributes, EnterpriseBean ejb, String transAttribute, boolean wantToSet) {
            boolean empty = ejbAttributes.isEmpty();
            if (empty && !wantToSet) {
                return null;
            }
            return empty ? this.myExcludeList.addMethod() : ejbAttributes.get(0);
        }
    }
}

