/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.deployment.ui.DeploymentSettingsPanel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.run.configuration.AdditionalTabsProvider;
import com.intellij.javaee.run.configuration.CheckUtil;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.DeploymentSettingsImpl;
import com.intellij.javaee.run.configuration.DeploysArtifactsOnStartupOnly;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.run.configuration.JavaeeRunConfigurationCommonSettingsBean;
import com.intellij.javaee.run.configuration.LogCustomizer;
import com.intellij.javaee.run.configuration.LogFilesProvider;
import com.intellij.javaee.run.configuration.MarkArtifactForDeploymentQuickFix;
import com.intellij.javaee.run.configuration.PredefinedLogFilesProvider;
import com.intellij.javaee.run.configuration.RunnerSpecificLocalConfigurationBit;
import com.intellij.javaee.run.configuration.RunnerSpecificRemoteConfigurationBit;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.configuration.ServerModelEx;
import com.intellij.javaee.run.configuration.view.J2EERunConfigurationEditor;
import com.intellij.javaee.run.configuration.view.JavaeeRunConfigurationEditorContext;
import com.intellij.javaee.run.configuration.view.RunnerSpecificLocalPanel;
import com.intellij.javaee.run.configuration.view.RunnerSpecificRemotePanel;
import com.intellij.javaee.run.execution.ExecutionHelper;
import com.intellij.javaee.run.execution.J2EERemoteState;
import com.intellij.javaee.run.execution.JavaCommandLineLocalState;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.run.execution.PatchedLocalState;
import com.intellij.javaee.run.execution.update.HotSwapClassesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.ReloadClassesAndResourcesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.ReloadResourcesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.SelectUpdatingPolicyDialog;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.run.localRun.EnvironmentHelper;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.run.localRun.ScriptHelper;
import com.intellij.javaee.run.localRun.ScriptsHelper;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonStrategy
extends LocatableConfigurationBase
implements CommonModel,
RunConfiguration,
LocatableConfiguration,
RunConfigurationWithRunnerSettings,
RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.run.configuration.CommonStrategy");
    @NonNls
    public static final String FACET_ID_ATTRIBUTE = "FACET_ID";
    @NonNls
    public static final String FACET_ELEMENT = "JAVAEE_FACET";
    @NonNls
    private static final String APPLICATION_SERVER_NAME = "APPLICATION_SERVER_NAME";
    @NonNls
    private static final String ALTERNATIVE_JRE_ENABLED = "ALTERNATIVE_JRE_ENABLED";
    @NonNls
    private static final String ALTERNATIVE_JRE_PATH = "ALTERNATIVE_JRE_PATH";
    @NonNls
    private static final String SERVER_SETTINGS_ELEMENT = "server-settings";
    private final AppServerIntegration myIntegration;
    private ApplicationServer myApplicationServer;
    private String myApplicationServerName;
    private JavaeeRunConfigurationCommonSettingsBean mySettingsBean = new JavaeeRunConfigurationCommonSettingsBean();
    private ServerModel myServerModel;
    private final JavaCommandLineStartupPolicy myJavaCommandLineStartupPolicy;
    private final ExecutableObjectStartupPolicy myExecutableObjectStartupPolicy;
    private DeploymentSettingsImpl myDeploymentSettings;
    private boolean myAlternativeJreEnabled;
    private String myAlternativeJrePath;

    public CommonStrategy(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy) {
        this(name, integration, project, factory, serverModel, isLocal, javaPolicy, null);
    }

    public CommonStrategy(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, ExecutableObjectStartupPolicy executablePolicy) {
        this(name, integration, project, factory, serverModel, isLocal, null, executablePolicy);
    }

    private CommonStrategy(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy, ExecutableObjectStartupPolicy executablePolicy) {
        super(project, factory, name != null ? name : J2EEBundle.message((String)"default.run.configuration.name.unnamed", (Object[])new Object[0]));
        this.myIntegration = integration;
        this.myServerModel = serverModel;
        this.myServerModel.setCommonModel((CommonModel)this);
        this.mySettingsBean.PORT = this.myServerModel.getDefaultPort();
        this.setLocal(isLocal);
        this.myDeploymentSettings = CommonStrategy.createDeploymentSettings(project, this);
        this.myJavaCommandLineStartupPolicy = javaPolicy;
        this.myExecutableObjectStartupPolicy = executablePolicy;
        this.addPredefinedLogFiles();
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, null);
    }

    private static DeploymentSettingsImpl createDeploymentSettings(Project project, CommonStrategy commonStrategy) {
        DeploymentProvider deploymentProvider = commonStrategy.getDeploymentProvider();
        return deploymentProvider != null ? new DeploymentSettingsImpl(project, commonStrategy, deploymentProvider) : null;
    }

    private void addPredefinedLogFiles() {
        if (this.myServerModel instanceof PredefinedLogFilesProvider) {
            for (PredefinedLogFile predefined : ((PredefinedLogFilesProvider)this.myServerModel).getPredefinedLogFiles()) {
                this.addPredefinedLogFile(predefined);
            }
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        JavaeeRunConfigurationEditorContext editorContext = new JavaeeRunConfigurationEditorContext((SettingsEditorGroup<CommonStrategy>)group, this.getFactory(), this.getProject());
        LogConfigurationPanel logConfigurationPanel = new LogConfigurationPanel();
        J2EERunConfigurationEditor commonSettingsEditor = new J2EERunConfigurationEditor(this, (LogConfigurationPanel<? extends RunConfigurationBase>)logConfigurationPanel, editorContext);
        group.addEditor(J2EEBundle.message((String)"title.run.configuration.editor.server", (Object[])new Object[0]), (SettingsEditor)commonSettingsEditor);
        SettingsEditor<CommonStrategy> newDeploymentSettingsEditor = this.createArtifactDeploymentSettingsEditor(editorContext);
        if (newDeploymentSettingsEditor != null) {
            group.addEditor(J2EEBundle.message((String)"title.run.configuration.editor.deployment", (Object[])new Object[0]), newDeploymentSettingsEditor);
        }
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)logConfigurationPanel);
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/CommonStrategy", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public String suggestedName() {
        if (this.myApplicationServer != null) {
            return this.myApplicationServer.getName();
        }
        return this.myApplicationServerName;
    }

    @Nullable
    public UpdatingPolicy selectUpdatingPolicy(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javaee/run/configuration/CommonStrategy", "selectUpdatingPolicy"));
        }
        UpdatingPolicy policy = this.getUpdatingPolicy();
        Collection<? extends UpdatingPolicy> policies = UpdatingRunningApplicationUtil.getAvailablePolicies(executor, this, false);
        if (policies.isEmpty()) {
            return null;
        }
        if (this.mySettingsBean.SHOW_DIALOG_ON_UPDATE || policy == null || !policies.contains(policy)) {
            SelectUpdatingPolicyDialog dialog = new SelectUpdatingPolicyDialog(this.getProject(), this.getName(), null, true, policies, policy);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return null;
            }
            policy = dialog.getSelectedPolicy();
            this.mySettingsBean.UPDATING_POLICY = policy.getId();
            this.mySettingsBean.SHOW_DIALOG_ON_UPDATE = dialog.isShowDialogAgain();
        }
        return policy;
    }

    @Nullable
    public UpdatingPolicy getUpdateOnFrameDeactivationPolicy() {
        return CommonStrategy.getUpdateOnFrameDeactivationPolicy(this.mySettingsBean);
    }

    @Nullable
    public UpdatingPolicy getUpdatingPolicy() {
        return UpdatingRunningApplicationUtil.findPolicy(this.mySettingsBean.UPDATING_POLICY);
    }

    @Nullable
    private SettingsEditor<CommonStrategy> createArtifactDeploymentSettingsEditor(@NotNull JavaeeRunConfigurationEditorContext editorContext) {
        if (editorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorContext", "com/intellij/javaee/run/configuration/CommonStrategy", "createArtifactDeploymentSettingsEditor"));
        }
        DeploymentProvider deploymentProvider = this.getDeploymentProvider();
        if (deploymentProvider == null) {
            return null;
        }
        return new DeploymentSettingsPanel(this, deploymentProvider, editorContext);
    }

    public List<Artifact> getDeployedArtifacts() {
        if (this.myDeploymentSettings != null) {
            return this.myDeploymentSettings.getDeployedArtifacts();
        }
        if (this.myServerModel instanceof DeploysArtifactsOnStartupOnly) {
            return ((DeploysArtifactsOnStartupOnly)this.myServerModel).getArtifactsToDeploy();
        }
        return Collections.emptyList();
    }

    public List<Artifact> getArtifactsToBuild() {
        if (this.myDeploymentSettings != null) {
            return this.myDeploymentSettings.getArtifacts2Build();
        }
        if (this.myServerModel instanceof DeploysArtifactsOnStartupOnly) {
            return ((DeploysArtifactsOnStartupOnly)this.myServerModel).getArtifactsToDeploy();
        }
        return Collections.emptyList();
    }

    @Nullable
    public DeploymentModel getDeploymentModel(Artifact artifact) {
        return this.myDeploymentSettings != null ? this.myDeploymentSettings.getModel(artifact) : null;
    }

    public final AppServerIntegration getIntegration() {
        return this.myIntegration;
    }

    public JavaeeRunConfigurationCommonSettingsBean getSettingsBean() {
        return this.mySettingsBean;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javaee/run/configuration/CommonStrategy", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javaee/run/configuration/CommonStrategy", "getState"));
        }
        if (env.getConfigurationSettings() instanceof GenericDebuggerRunnerSettings) {
            GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)env.getConfigurationSettings();
            debuggerSettings.LOCAL = this.isLocal();
        }
        return this.isLocal() ? this.getLocalState(executor, env) : this.getRemoteState(env.getRunnerSettings(), env.getConfigurationSettings());
    }

    private RunProfileState getRemoteState(RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        return new J2EERemoteState(this);
    }

    @Nullable
    private RunProfileState getLocalState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javaee/run/configuration/CommonStrategy", "getLocalState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javaee/run/configuration/CommonStrategy", "getLocalState"));
        }
        JavaCommandLineStartupPolicy policy = this.myJavaCommandLineStartupPolicy;
        ExecutionHelper executionHelper = new ExecutionHelper(this);
        if (executionHelper.processRunInstance(executor)) {
            return null;
        }
        if (policy != null) {
            return new JavaCommandLineLocalState(policy, this, executor, env, executionHelper);
        }
        return new PatchedLocalState((RunnerSpecificLocalConfigurationBit)env.getConfigurationSettings(), this, env.getRunnerSettings(), executionHelper);
    }

    public boolean isLocal() {
        return this.mySettingsBean.LOCAL;
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/javaee/run/configuration/CommonStrategy", "checkRunnerSettings"));
        }
        if (configurationPerRunnerSettings != null && configurationPerRunnerSettings instanceof RunnerSpecificLocalConfigurationBit) {
            ((RunnerSpecificLocalConfigurationBit)configurationPerRunnerSettings).checkConfiguration(runnerSettings);
        }
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        ApplicationServer applicationServer = this.getApplicationServer();
        if (this.isApplicationServerNeeded() && (applicationServer == null || applicationServer.isDisposed())) {
            String serverName = this.getApplicationServerName();
            if (StringUtil.isEmpty((String)serverName)) {
                throw new RuntimeConfigurationError(J2EEBundle.message((String)"exception.text.application.server.not.specified", (Object[])new Object[0]));
            }
            throw new RuntimeConfigurationError(J2EEBundle.message((String)"exception.text.application.server.0.not.configured", (Object[])new Object[]{serverName}));
        }
        if (this.isAlternativeJreEnabled()) {
            String jrePath = this.getAlternativeJrePath();
            if (StringUtil.isEmpty((String)jrePath)) {
                throw new RuntimeConfigurationError(J2EEBundle.message((String)"exception.text.alternative.jre.not.specified", (Object[])new Object[0]));
            }
            try {
                this.getAlternativeJre();
            }
            catch (CantRunException exception) {
                throw new RuntimeConfigurationError(exception.getMessage());
            }
        }
        if (this.isLocal() && this.mySettingsBean.WORKING_DIRECTORY != null) {
            CheckUtil.checkExists((String)J2EEBundle.message((String)"directory.description.working.directory", (Object[])new Object[0]), (String)this.mySettingsBean.WORKING_DIRECTORY.replace('/', File.separatorChar), (boolean)true);
        }
        this.myServerModel.checkConfiguration();
        String urlString = this.getUrlToOpenInBrowser();
        if (this.mySettingsBean.OPEN_IN_BROWSER) {
            try {
                URL url = new URL(urlString);
                if (url.getPort() > 65535 || url.getHost() == null) {
                    throw new MalformedURLException();
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeConfigurationWarning(J2EEBundle.message((String)"exception.text.malformed.url", (Object[])new Object[]{urlString}));
            }
        }
        if (!this.getProject().isDefault()) {
            this.checkDeploymentModels();
            this.checkAllDescriptorsDefined();
        }
    }

    public boolean isApplicationServerNeeded() {
        ServerModel serverModel = this.getServerModel();
        if (!(serverModel instanceof ServerModelEx)) {
            return true;
        }
        return ((ServerModelEx)serverModel).isApplicationServerNeeded();
    }

    private void checkAllDescriptorsDefined() throws RuntimeConfigurationWarning {
        List<Artifact> artifacts = this.getDeployedArtifacts();
        LinkedHashSet facets = new LinkedHashSet();
        for (Artifact artifact : artifacts) {
            facets.addAll(JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(this.getProject(), artifact, null));
        }
        for (JavaeeFacet facet : facets) {
            ConfigFile[] defined = facet.getDescriptorsContainer().getConfigFiles();
            HashSet<ConfigFileMetaData> definedMetadatas = new HashSet<ConfigFileMetaData>();
            for (ConfigFile descriptor : defined) {
                definedMetadatas.add(descriptor.getMetaData());
            }
            Collection descriptions = ((JavaeeFacetType)facet.getType()).getDescriptorsMetaDataProvider().getMetaData(this.myIntegration);
            for (ConfigFileMetaData data : descriptions) {
                if (data.isOptional() || definedMetadatas.contains(data)) continue;
                RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning(J2EEBundle.message((String)"exception.text.descriptor.not.defined", (Object[])new Object[]{data.getTitle()}));
                warning.setQuickFix(() -> JavaeeFacetUtil.getInstance().showFacetDescriptorsSettingsEditor(facet));
                throw warning;
            }
        }
    }

    private void checkDeploymentModels() throws RuntimeConfigurationException {
        DeploymentProvider deploymentProvider = this.getDeploymentProvider();
        if (deploymentProvider == null) {
            return;
        }
        List<DeploymentModel> models = this.myDeploymentSettings.getDeploymentModels();
        if (models.isEmpty() && this.isLocal()) {
            MarkArtifactForDeploymentQuickFix quickFix = new MarkArtifactForDeploymentQuickFix(this.getProject(), deploymentProvider);
            throw new RuntimeConfigurationWarning(quickFix.getWarningMessage(), (Runnable)quickFix);
        }
    }

    public final void readExternal(Element element) throws InvalidDataException {
        JDomConvertingUtil.removeDuplicatedOptions((Element)element);
        Element serverSettingsElement = element.getChild(SERVER_SETTINGS_ELEMENT);
        if (serverSettingsElement == null) {
            serverSettingsElement = element;
        }
        this.myServerModel.readExternal(serverSettingsElement);
        this.myApplicationServerName = element.getAttributeValue(APPLICATION_SERVER_NAME);
        this.myApplicationServer = ApplicationServersManager.getInstance().findByName(this.myApplicationServerName);
        this.myAlternativeJreEnabled = Boolean.parseBoolean(element.getAttributeValue(ALTERNATIVE_JRE_ENABLED));
        this.myAlternativeJrePath = element.getAttributeValue(ALTERNATIVE_JRE_PATH);
        this.expandServerModelMacros(element);
        XmlSerializer.deserializeInto((Object)this.mySettingsBean, (Element)element);
        if (this.myDeploymentSettings != null) {
            this.myDeploymentSettings.readFrom(element);
        }
        super.readExternal(element);
        if (this.getPredefinedLogFiles().isEmpty() && this.getLogFiles().isEmpty()) {
            this.addPredefinedLogFiles();
        }
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void expandServerModelMacros(Element element) {
        ServerModelEx serverModel;
        List<Pair<String, String>> macros;
        if (this.myServerModel instanceof ServerModelEx && !(macros = (serverModel = (ServerModelEx)this.myServerModel).getExternalizationMacros()).isEmpty()) {
            ExpandMacroToPathMap map = new ExpandMacroToPathMap();
            for (Pair<String, String> macro : macros) {
                map.put(CommonStrategy.getMacroName((String)macro.getFirst()), (String)macro.getSecond());
            }
            map.substitute(element, true, true);
        }
    }

    private static String getMacroName(String name) {
        return "%IDEA_RUN:" + name + "%";
    }

    public final void writeExternal(Element element) throws WriteExternalException {
        XmlSerializer.serializeInto((Object)this.mySettingsBean, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (this.myDeploymentSettings != null) {
            this.myDeploymentSettings.writeTo(element);
        }
        if (this.myApplicationServer != null) {
            element.setAttribute(APPLICATION_SERVER_NAME, this.myApplicationServer.getName());
        } else if (this.myApplicationServerName != null) {
            element.setAttribute(APPLICATION_SERVER_NAME, this.myApplicationServerName);
        }
        element.setAttribute(ALTERNATIVE_JRE_ENABLED, Boolean.toString(this.myAlternativeJreEnabled));
        if (this.myAlternativeJrePath != null) {
            element.setAttribute(ALTERNATIVE_JRE_PATH, this.myAlternativeJrePath);
        }
        Element serverSettingsElement = new Element(SERVER_SETTINGS_ELEMENT);
        this.myServerModel.writeExternal(serverSettingsElement);
        element.addContent(serverSettingsElement);
        super.writeExternal(element);
        this.collapseServerModelMacros(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    public void collapseServerModelMacros(Element element) {
        ServerModelEx serverModel;
        List<Pair<String, String>> macros;
        if (this.myServerModel instanceof ServerModelEx && !(macros = (serverModel = (ServerModelEx)this.myServerModel).getExternalizationMacros()).isEmpty()) {
            ReplacePathToMacroMap macroMap = new ReplacePathToMacroMap();
            for (Pair<String, String> macro : macros) {
                macroMap.put((String)macro.getSecond(), CommonStrategy.getMacroName((String)macro.getFirst()));
            }
            macroMap.substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
        }
    }

    @NotNull
    public final Module[] getModules() {
        List<Artifact> artifacts = this.getDeployedArtifacts();
        if (artifacts.isEmpty()) {
            if (Module.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/CommonStrategy", "getModules"));
            }
            return Module.EMPTY_ARRAY;
        }
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, (Project)this.getProject());
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/CommonStrategy", "getModules"));
        }
        return moduleArray;
    }

    public CommonStrategy clone() {
        Element element = new Element("tag");
        try {
            this.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        CommonStrategy result = (CommonStrategy)super.clone();
        RunConfigurationExtension.cleanExtensionsUserData((RunConfigurationBase)result);
        try {
            result.myServerModel = (ServerModel)this.myServerModel.clone();
        }
        catch (Throwable e) {
            LOG.error(e);
            throw new InternalError();
        }
        result.myServerModel.setCommonModel((CommonModel)result);
        result.mySettingsBean = new JavaeeRunConfigurationCommonSettingsBean();
        result.myDeploymentSettings = CommonStrategy.createDeploymentSettings(this.getProject(), result);
        try {
            result.readExternal(element);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public final void setLocal(boolean b) {
        this.mySettingsBean.LOCAL = b;
    }

    public final ApplicationServer getApplicationServer() {
        return this.myApplicationServer;
    }

    public String getApplicationServerName() {
        return this.myApplicationServer != null ? this.myApplicationServer.getName() : this.myApplicationServerName;
    }

    public String getHost() {
        return this.isLocal() ? "localhost" : this.getRemoteHost();
    }

    public int getPort() {
        return this.isLocal() ? this.getServerModel().getLocalPort() : this.getRemotePort();
    }

    public final void setApplicationServer(ApplicationServer applicationServer) {
        this.myApplicationServer = applicationServer;
        this.myApplicationServerName = applicationServer != null ? applicationServer.getName() : null;
    }

    public void setApplicationServerName(String applicationServerName) {
        this.myApplicationServerName = applicationServerName;
        this.myApplicationServer = ApplicationServersManager.getInstance().findByName(applicationServerName, this.myIntegration);
    }

    public String getWorkingDirectory() {
        return this.mySettingsBean.WORKING_DIRECTORY;
    }

    public Collection<? extends DeploymentModel> getDeploymentModels() {
        if (this.myDeploymentSettings != null) {
            return this.myDeploymentSettings.getDeploymentModels();
        }
        return Collections.emptyList();
    }

    @Nullable
    public DeploymentSettings getDeploymentSettings() {
        return this.myDeploymentSettings;
    }

    public final String getRemoteHost() {
        if (this.isLocal()) {
            return "localhost";
        }
        return this.mySettingsBean.HOST;
    }

    public final String getUrlToOpenInBrowser() {
        String url = this.mySettingsBean.OPEN_IN_BROWSER_URL;
        return url == null ? this.getDefaultUrlForBrowser() : url;
    }

    public CompileScope getCompileScope() {
        CompileScope baseScope = ArtifactCompileScope.createScopeWithArtifacts((CompileScope)ArtifactCompileScope.createScopeForModulesInArtifacts((Project)this.getProject(), this.getDeployedArtifacts()), this.getArtifactsToBuild());
        return this.myServerModel instanceof ServerModelEx ? ((ServerModelEx)this.myServerModel).getCompileScope(baseScope) : baseScope;
    }

    public DeploymentProvider getDeploymentProvider() {
        return DeploymentManagerEx.getProvider(this);
    }

    @Nullable
    public ScriptHelper createStartupHelper(ConfigurationInfoProvider provider) {
        if (this.myExecutableObjectStartupPolicy != null) {
            try {
                return this.myExecutableObjectStartupPolicy.createStartupScriptHelper(provider.getRunner());
            }
            catch (AbstractMethodError e) {
                return new ScriptHelperWrapper(this.myExecutableObjectStartupPolicy.getStartupHelper());
            }
        }
        return null;
    }

    @Nullable
    public ScriptHelper createShutdownHelper(ConfigurationInfoProvider provider) {
        if (this.myExecutableObjectStartupPolicy != null) {
            try {
                return this.myExecutableObjectStartupPolicy.createShutdownScriptHelper(provider.getRunner());
            }
            catch (AbstractMethodError e) {
                return new ScriptHelperWrapper(this.myExecutableObjectStartupPolicy.getShutdownHelper());
            }
        }
        return null;
    }

    @Nullable
    public EnvironmentHelper getHelper() {
        if (this.myExecutableObjectStartupPolicy != null) {
            return this.myExecutableObjectStartupPolicy.getEnvironmentHelper();
        }
        return null;
    }

    public String getDefaultUrlForBrowser() {
        return this.myServerModel.getDefaultUrlForBrowser();
    }

    public SettingsEditor<CommonStrategy> getServerSpecificEditor() {
        return this.myServerModel.getEditor();
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        return this.myServerModel.createServerInstance();
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return this.myServerModel.getAddressesToCheck();
    }

    public OutputProcessor createOutputProcessor(ProcessHandler handler, J2EEServerInstance serverInstance) {
        return this.myServerModel.createOutputProcessor(handler, serverInstance);
    }

    public ServerModel getServerModel() {
        return this.myServerModel;
    }

    public int getRemotePort() {
        return this.mySettingsBean.PORT;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        if (this.myServerModel instanceof PredefinedLogFilesProvider) {
            return ((PredefinedLogFilesProvider)this.myServerModel).getOptionsForPredefinedLogFile(predefinedLogFile);
        }
        return null;
    }

    @Nullable
    public LogFilesProvider getLogProvider() {
        return this.myServerModel instanceof LogFilesProvider ? (LogFilesProvider)this.myServerModel : null;
    }

    public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        if (this.isLocal()) {
            return new RunnerSpecificLocalConfigurationBit(provider);
        }
        return new RunnerSpecificRemoteConfigurationBit(provider);
    }

    public void customizeLogConsole(LogConsole console) {
        if (this.myServerModel instanceof LogCustomizer) {
            ((LogCustomizer)this.myServerModel).customizeLogConsole(console);
        }
    }

    @Nullable
    public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        if (this.myJavaCommandLineStartupPolicy == null) {
            if (this.isLocal()) {
                return new RunnerSpecificLocalPanel();
            }
            if (runner instanceof JavaPatchableProgramRunner) {
                return new RunnerSpecificRemotePanel((JavaPatchableProgramRunner)runner);
            }
        }
        return null;
    }

    public void initialize() {
        this.removeAllLogFiles();
    }

    public boolean isSettingsNeeded() {
        return !this.isJavaPolicy();
    }

    public boolean isJavaPolicy() {
        return this.myJavaCommandLineStartupPolicy != null;
    }

    public void setUrlToOpenInBrowser(@Nullable String newUrl) {
        this.mySettingsBean.OPEN_IN_BROWSER_URL = this.getDefaultUrlForBrowser().equals(newUrl) ? null : newUrl;
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
        if (this.myServerModel instanceof AdditionalTabsProvider) {
            ((AdditionalTabsProvider)this.myServerModel).createAdditionalTabs(manager, startedProcess);
        }
    }

    public boolean isAlternativeJreEnabled() {
        return this.myAlternativeJreEnabled;
    }

    public void setAlternativeJreEnabled(boolean alternativeJreEnabled) {
        this.myAlternativeJreEnabled = alternativeJreEnabled;
    }

    @Nullable
    public String getAlternativeJrePath() {
        return this.myAlternativeJrePath;
    }

    public void setAlternativeJrePath(@Nullable String alternativeJrePath) {
        this.myAlternativeJrePath = alternativeJrePath;
    }

    @Nullable
    public Sdk getJre() {
        Project project;
        if (this.isAlternativeJreEnabled()) {
            try {
                Sdk alternativeJre = this.getAlternativeJre();
                if (alternativeJre != null) {
                    return alternativeJre;
                }
            }
            catch (CantRunException alternativeJre) {
                // empty catch block
            }
        }
        if ((project = this.getProject()).isDisposed()) {
            return null;
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectJdk != null && projectJdk.getSdkType() instanceof JavaSdkType) {
            return projectJdk;
        }
        LOG.debug("Neither alternative nor project JRE are configured");
        return null;
    }

    @Nullable
    private Sdk getAlternativeJre() throws CantRunException {
        String jrePath = this.getAlternativeJrePath();
        Project project = this.getProject();
        if (jrePath != null && !project.isDisposed()) {
            return JavaParametersUtil.createProjectJdk((Project)project, (String)jrePath);
        }
        return null;
    }

    @Nullable
    public static UpdatingPolicy getUpdateOnFrameDeactivationPolicy(JavaeeRunConfigurationCommonSettingsBean settingsBean) {
        if (settingsBean.UPDATE_ON_FRAME_DEACTIVATION) {
            if (settingsBean.UPDATE_CLASSES_ON_FRAME_DEACTIVATION) {
                return ReloadClassesAndResourcesUpdatingPolicy.getInstance();
            }
            if (settingsBean.HOT_SWAP_CLASSES_ON_FRAME_DEACTIVATION) {
                return HotSwapClassesUpdatingPolicy.getInstance();
            }
            return ReloadResourcesUpdatingPolicy.getInstance();
        }
        return null;
    }

    private static class ScriptHelperWrapper
    extends ScriptHelper {
        private final ScriptsHelper myDelegate;

        public ScriptHelperWrapper(ScriptsHelper delegate) {
            this.myDelegate = delegate;
        }

        public ExecutableObject getDefaultScript(CommonModel commonModel) {
            return this.myDelegate.getDefaultScript(commonModel);
        }
    }
}

