/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotSwapClassesUpdatingPolicy
extends UpdatingPolicy {
    @NonNls
    private static final String ID = "hot-swap-classes";

    public static UpdatingPolicy getInstance() {
        return UpdatingRunningApplicationUtil.findPolicy(ID);
    }

    public HotSwapClassesUpdatingPolicy() {
        super(ID);
    }

    @Override
    public String getDescription() {
        return J2EEBundle.message((String)"updating.policy.hot.swap.classes", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailableOnFrameDeactivation() {
        return true;
    }

    @Override
    public boolean isAvailableForExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javaee/run/execution/update/HotSwapClassesUpdatingPolicy", "isAvailableForExecutor"));
        }
        return executor.getId().equals(DefaultDebugExecutor.EXECUTOR_ID);
    }

    @Override
    public boolean isAvailableForConfiguration(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/run/execution/update/HotSwapClassesUpdatingPolicy", "isAvailableForConfiguration"));
        }
        return !UpdatingRunningApplicationUtil.isResourcesReloadingSupported(commonModel) && !commonModel.getDeployedArtifacts().isEmpty();
    }

    @Override
    public void runUpdate(@NotNull Project project, @Nullable Executor executor, @NotNull J2EEServerInstance serverInstance, @NotNull ProcessHandler processHandler, boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/HotSwapClassesUpdatingPolicy", "runUpdate"));
        }
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/run/execution/update/HotSwapClassesUpdatingPolicy", "runUpdate"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javaee/run/execution/update/HotSwapClassesUpdatingPolicy", "runUpdate"));
        }
        UpdatingRunningApplicationUtil.makeAndHotSwap(project, serverInstance.getCommonModel(), processHandler, null, true, onFrameDeactivation);
    }
}

