/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.jam.view.treetable.JamTreeTableViewExpander;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.actions.NewGroupPersistence;
import com.intellij.jpa.generation.DatabaseSchemaImporter;
import com.intellij.jpa.generation.GenerationSettings;
import com.intellij.jpa.generation.ui.DatabaseRelationshipData;
import com.intellij.jpa.generation.ui.DatabaseRelationshipDialog;
import com.intellij.jpa.generation.ui.DatabaseRelationshipRoleNodeDescriptor;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.manipulators.PersistenceFacetManipulator;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JdbcTypesUtil;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxCellEditor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.DomCollectionControl;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSchemaImportDialog
extends DialogWrapper
implements TypeSafeDataProvider {
    static final Comparator<DasTable> TABLE_COMPARATOR = (o1, o2) -> QNameUtil.getQualifiedName((DasObject)o1).compareTo(QNameUtil.getQualifiedName((DasObject)o2));
    static final Comparator<DasColumn> TABLE_FIELD_COMPARATOR = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private final Project myProject;
    private final PsiNameHelper myPsiNameHelper;
    private final Map<Object, DatabaseSchemaImporter.MappingInfo> myInfoMap;
    private final Map<DasTable, List<DatabaseRelationshipData.Role>> myRelationsMap;
    private final List<DatabaseRelationshipData> myDefaultRelations;
    private String myFirstTreeError;
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JLabel myPackageLabel;
    private ReferenceEditorComboWithBrowseButton myPackageComponent;
    private JCheckBox myCbAddToUnit;
    private TextFieldWithBrowseButton myMappingName;
    private ComboboxWithBrowseButton myCbUnits;
    private JCheckBox myCbGenerateAnnotations;
    private JCheckBox myCbPreferPrimitiveTypes;
    private ComboboxWithBrowseButton myDatasourceComponent;
    private JTextField myTfEntityNameSuffix;
    private JTextField myTfEntityNamePrefix;
    private CaptionComponent myCaptionComponent;
    private JCheckBox myCbGuessRelationships;
    private JPanel myPackagePanel;
    private JCheckBox myCbGenerateSeparateXML;
    private JCheckBox myCbGenerateSingleXml;
    private JCheckBox myCbGenerateColumnProps;
    private final MyJavaeeTreeView myTreeView;
    private final PersistenceFacet myFacet;
    private final String myUnitName;
    private DbDataSource myDatasource;
    private boolean myPreferPrimitiveTypes;
    private String myEntityNameSuffix;
    private String myEntityNamePrefix;

    public DatabaseSchemaImportDialog(PersistenceFacet facet, String unitName) {
        super(facet.getModule().getProject(), true);
        this.$$$setupUI$$$();
        this.myInfoMap = new HashMap<Object, DatabaseSchemaImporter.MappingInfo>();
        this.myRelationsMap = new HashMap<DasTable, List<DatabaseRelationshipData.Role>>();
        this.myDefaultRelations = new ArrayList<DatabaseRelationshipData>();
        this.myPreferPrimitiveTypes = true;
        this.myEntityNameSuffix = "Entity";
        this.myEntityNamePrefix = "";
        this.setTitle(JpaMessages.message((String)"dialog.title.import.database.schema", (Object[])new Object[0]));
        this.myFacet = facet;
        this.myUnitName = unitName;
        this.myProject = facet.getModule().getProject();
        this.myTreeView = new MyJavaeeTreeView(this.myProject);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTreeView.getTreeTableView());
        this.setupControls();
        this.myPsiNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        this.init();
        this.restoreDialogValues();
        this.refreshControls();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.jpa.generation.ui.DatabaseSchemaImportDialog";
    }

    protected void doOKAction() {
        this.storeDialogValues();
        if (this.askUserIfItsOkToCloseAndLoseEverything(true)) {
            super.doOKAction();
        }
    }

    private void restoreDialogValues() {
        DbDataSource selected;
        GenerationSettings settings = GenerationSettings.getInstance();
        this.myTfEntityNamePrefix.setText(settings.getEntityPrefix());
        this.myTfEntityNameSuffix.setText(settings.getEntitySuffix());
        if (this.myCbGenerateAnnotations.isEnabled()) {
            this.myCbGenerateAnnotations.setSelected(settings.isGenerateAnnotations());
        }
        boolean generateSingle = settings.isGenerateSingleXml() && !settings.isGenerateSeparateXml();
        this.myCbGenerateSingleXml.setSelected(generateSingle);
        this.myCbGenerateSeparateXML.setSelected(settings.isGenerateSeparateXml());
        this.myCbGenerateColumnProps.setSelected(settings.isGenerateColumnProperties());
        this.myMappingName.setEnabled(generateSingle);
        if (this.myCbAddToUnit.isEnabled()) {
            this.myCbAddToUnit.setSelected(settings.isAddToUnit());
            this.myCbUnits.setEnabled(this.myUnitName == null && this.myCbAddToUnit.isSelected());
        }
        this.myPreferPrimitiveTypes = settings.isPreferPrimitiveTypes();
        this.myCbPreferPrimitiveTypes.setSelected(this.myPreferPrimitiveTypes);
        this.myCbGuessRelationships.setSelected(settings.isGenerateDefaultRelationships());
        String uniqueID = PropertiesComponent.getInstance((Project)this.myProject).getValue("JPA.DatabaseSchemaImportDialog");
        DbDataSource dbDataSource = selected = uniqueID == null ? null : DbPsiFacade.getInstance((Project)this.myProject).findDataSource(uniqueID);
        if (selected != null) {
            ((JComboBox)this.myDatasourceComponent.getChildComponent()).setSelectedItem(selected);
        }
    }

    private void storeDialogValues() {
        GenerationSettings settings = GenerationSettings.getInstance();
        settings.setEntityPrefix(this.myEntityNamePrefix);
        settings.setEntitySuffix(this.myEntityNameSuffix);
        settings.setGenerateAnnotations(this.myCbGenerateAnnotations.isSelected());
        settings.setGenerateSingleXml(this.myCbGenerateSingleXml.isSelected());
        settings.setGenerateSeparateXml(this.myCbGenerateSeparateXML.isSelected());
        settings.setGenerateColumnProperties(this.myCbGenerateColumnProps.isSelected());
        settings.setAddToUnit(this.myCbAddToUnit.isSelected());
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry("ImportMappingsDialog.RecentPackages", this.myPackageComponent.getText());
        settings.setPreferPrimitiveTypes(this.myCbPreferPrimitiveTypes.isSelected());
        settings.setGenerateDefaultRelationships(this.myCbGuessRelationships.isSelected());
        if (this.myDatasource != null) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue("JPA.DatabaseSchemaImportDialog", this.myDatasource.getUniqueId());
        }
    }

    private boolean askUserIfItsOkToCloseAndLoseEverything(boolean okAction) {
        return this.getDatasource() == null || DasUtil.getTables((DbDataSource)this.getDatasource()).size() == 0 || Messages.showYesNoDialog((Component)this.getContentPane(), (String)(okAction ? JpaMessages.message((String)"message.text.confirm.generate.orm", (Object[])new Object[0]) : JpaMessages.message((String)"message.text.confirm.discard.orm", (Object[])new Object[0])), (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public void doCancelAction() {
        this.storeDialogValues();
        if (this.askUserIfItsOkToCloseAndLoseEverything(false)) {
            super.doCancelAction();
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDatasourceComponent.getComboBox();
    }

    protected void dispose() {
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.myTreeView.getTreeTableView());
        Disposer.dispose((Disposable)this.myTreeView);
        super.dispose();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ui/DatabaseSchemaImportDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("newEJBmap_to_datasource");
    }

    public String getPackageName() {
        return this.myPackageComponent.getText();
    }

    public boolean isGenerateSeparateXmlPerEntity() {
        return this.myCbGenerateSeparateXML.isSelected();
    }

    public boolean isGenerateColumnProperties() {
        return this.myCbGenerateColumnProps.isSelected();
    }

    private String getPrimaryKeyType(DasTable tableData) {
        DasColumn pkField = null;
        for (DasColumn fieldData : DasUtil.getColumns((DasObject)tableData)) {
            if (!DasUtil.isPrimary((DasColumn)fieldData)) continue;
            if (pkField != null) {
                return DatabaseSchemaImporter.getDefaultPrimaryKeyType(this.getInfo((Object)tableData).type);
            }
            pkField = fieldData;
        }
        return this.getInfo(pkField).type;
    }

    protected ValidationInfo doValidate() {
        HashMap<Object, String> errorMap = new HashMap<Object, String>();
        this.recalcTreeErrors(errorMap);
        this.myTreeView.refreshTreeTable().doWhenDone(() -> {
            for (Object o : errorMap.keySet()) {
                this.getInfo(o).errorMessage = (String)errorMap.get(o);
            }
            this.myTreeView.getTreeTableView().revalidate();
            this.myTreeView.getTreeTableView().repaint();
        });
        String message = this.getDialogErrorText();
        if (message != null) {
            return new ValidationInfo(message);
        }
        return null;
    }

    @Nullable
    public String getDialogErrorText() {
        if (this.myDatasourceComponent.getComboBox().getSelectedItem() == null) {
            return JpaMessages.message((String)"ids.error.no.datasource.selected", (Object[])new Object[0]);
        }
        if (!this.myPsiNameHelper.isQualifiedName(this.myPackageComponent.getText())) {
            return JpaMessages.message((String)"ids.error.invalid.package", (Object[])new Object[]{this.myPackageComponent.getText()});
        }
        if (!this.myPsiNameHelper.isIdentifier(this.myEntityNamePrefix + "_")) {
            return JpaMessages.message((String)"ids.error.inalid.entity.prefix", (Object[])new Object[]{this.myEntityNamePrefix});
        }
        if (!this.myPsiNameHelper.isIdentifier("_" + this.myEntityNameSuffix)) {
            return JpaMessages.message((String)"ids.error.inalid.entity.suffix", (Object[])new Object[]{this.myEntityNameSuffix});
        }
        if (this.myCbGenerateSingleXml.isSelected()) {
            String mappingPath = this.myMappingName.getText();
            if (StringUtil.isEmpty((String)mappingPath) || LocalFileSystem.getInstance().findFileByPath(mappingPath) == null) {
                return JpaMessages.message((String)"ids.error.xml.mapping.file.invalid", (Object[])new Object[]{mappingPath});
            }
        } else if (!this.myCbGenerateAnnotations.isSelected() && !this.myCbGenerateSeparateXML.isSelected()) {
            return JpaMessages.message((String)"ids.error.no.mapping.selected", (Object[])new Object[0]);
        }
        if (this.myCbAddToUnit.isSelected() && StringUtil.isEmpty((String)((String)this.myCbUnits.getComboBox().getSelectedItem()))) {
            return JpaMessages.message((String)"ids.error.no.unit.selected", (Object[])new Object[0]);
        }
        if (this.myCbGenerateAnnotations.isSelected() && this.myFacet.getPersistenceUnits().isEmpty()) {
            return JpaMessages.message((String)"ids.error.unit.required", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(this.myFacet.getPersistenceUnitClass())});
        }
        boolean atLeastOneTableEnabled = false;
        for (DasTable tableData : DasUtil.getTables((DbDataSource)this.myDatasource)) {
            if (!this.getInfo((Object)tableData).enabled) continue;
            atLeastOneTableEnabled = true;
            break;
        }
        if (!atLeastOneTableEnabled) {
            return JpaMessages.message((String)"ids.error.no.table.selected", (Object[])new Object[0]);
        }
        if (this.myFirstTreeError != null) {
            return this.myFirstTreeError;
        }
        return null;
    }

    private void setupControls() {
        this.myCaptionComponent.setIcon(JavaeeIcons.DB_SCHEMA_IMPORT_BIG);
        this.configureDataSourceCombo(null);
        this.myTreeView.getTreeTableView().getTableHeader().setVisible(true);
        this.myTreeView.getTreeTableView().setIntercellSpacing(new Dimension(1, 0));
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)this.myTreeView.getComponent(), "Center");
        this.myPanel.doLayout();
        this.myDatasourceComponent.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DatabaseSchemaImportDialog.this.dataSourceChanged();
                }
            }
        });
        this.myDatasourceComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbDataSource dataSource = (DbDataSource)DatabaseSchemaImportDialog.this.myDatasourceComponent.getComboBox().getSelectedItem();
                List created = DataSourceManagerDialog.showDialog((Project)DatabaseSchemaImportDialog.this.myProject, (DbDataSource)dataSource);
                DatabaseSchemaImportDialog.this.configureDataSourceCombo((DbDataSource)ContainerUtil.getFirstItem((List)created));
            }
        });
        this.myPackageComponent = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageChooserDialog chooser = new PackageChooserDialog(JpaMessages.message((String)"dialog.title.choose.jpa.classes.package", (Object[])new Object[0]), DatabaseSchemaImportDialog.this.myProject);
                chooser.selectPackage(DatabaseSchemaImportDialog.this.myPackageComponent.getText());
                chooser.show();
                PsiPackage aPackage = chooser.getSelectedPackage();
                if (aPackage != null) {
                    DatabaseSchemaImportDialog.this.myPackageComponent.setText(aPackage.getQualifiedName());
                }
            }
        }, "", this.myProject, false, "ImportMappingsDialog.RecentPackages");
        this.myPackageLabel.setLabelFor((Component)this.myPackageComponent);
        this.myPackagePanel.add((Component)this.myPackageComponent, "Center");
        DatabaseSchemaImportDialog.setupMappingsAndUnitCombos(this.myFacet, this.myMappingName, this.myCbUnits, this.myUnitName, this.myCbAddToUnit);
        this.myCbGenerateSingleXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseSchemaImportDialog.this.myCbGenerateSeparateXML.setSelected(false);
                DatabaseSchemaImportDialog.this.myMappingName.setEnabled(DatabaseSchemaImportDialog.this.myCbGenerateSingleXml.isSelected());
                DatabaseSchemaImportDialog.this.myCbAddToUnit.setEnabled(DatabaseSchemaImportDialog.this.myUnitName == null);
            }
        });
        this.myCbGenerateSeparateXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseSchemaImportDialog.this.myCbGenerateSingleXml.setSelected(false);
                DatabaseSchemaImportDialog.this.myMappingName.setEnabled(DatabaseSchemaImportDialog.this.myCbGenerateSingleXml.isSelected());
            }
        });
        boolean canHaveAnnos = LanguageLevel.JDK_1_5.compareTo((Enum)LanguageLevelUtil.getEffectiveLanguageLevel((Module)this.myFacet.getModule())) <= 0;
        this.myCbGenerateAnnotations.setSelected(canHaveAnnos);
        this.myCbGenerateAnnotations.setEnabled(canHaveAnnos);
        this.myCbPreferPrimitiveTypes.setSelected(this.myPreferPrimitiveTypes);
        this.myCbPreferPrimitiveTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = DatabaseSchemaImportDialog.this.myCbPreferPrimitiveTypes.isSelected();
                if (selected != DatabaseSchemaImportDialog.this.myPreferPrimitiveTypes) {
                    DatabaseSchemaImportDialog.this.myPreferPrimitiveTypes = selected;
                    for (Map.Entry entry : DatabaseSchemaImportDialog.this.myInfoMap.entrySet()) {
                        Object key = entry.getKey();
                        if (!(key instanceof DasColumn)) continue;
                        DasColumn columnInfo = (DasColumn)key;
                        DatabaseSchemaImporter.MappingInfo info = (DatabaseSchemaImporter.MappingInfo)entry.getValue();
                        info.type = DatabaseSchemaImportDialog.this.myPreferPrimitiveTypes && columnInfo.isNotNull() ? PsiTypesUtil.unboxIfPossible((String)info.type) : PsiTypesUtil.boxIfPossible((String)info.type);
                    }
                    DatabaseSchemaImportDialog.this.myTreeView.refreshTreeTable();
                }
            }
        });
        this.myCbGuessRelationships.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseSchemaImportDialog.this.recalcDefaultRelationships();
                DatabaseSchemaImportDialog.this.myTreeView.refreshTreeTable();
            }
        });
        DocumentAdapter suffixPrefixAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                boolean suffixChanged;
                String prefix = DatabaseSchemaImportDialog.this.myTfEntityNamePrefix.getText();
                String suffix = DatabaseSchemaImportDialog.this.myTfEntityNameSuffix.getText();
                boolean prefixChanged = !prefix.equals(DatabaseSchemaImportDialog.this.myEntityNamePrefix);
                boolean bl = suffixChanged = !suffix.equals(DatabaseSchemaImportDialog.this.myEntityNameSuffix);
                if (!suffixChanged && !prefixChanged) {
                    return;
                }
                int prefixLen = DatabaseSchemaImportDialog.this.myEntityNamePrefix.length();
                int suffixLen = DatabaseSchemaImportDialog.this.myEntityNameSuffix.length();
                boolean changed = false;
                for (Map.Entry entry : DatabaseSchemaImportDialog.this.myInfoMap.entrySet()) {
                    String newName;
                    boolean processSuffix;
                    if (!(entry.getKey() instanceof DasTable)) continue;
                    DatabaseSchemaImporter.MappingInfo info = (DatabaseSchemaImporter.MappingInfo)entry.getValue();
                    String entityName = info.name;
                    int curLen = entityName.length();
                    boolean processPrefix = prefixChanged && entityName.startsWith(DatabaseSchemaImportDialog.this.myEntityNamePrefix);
                    boolean bl2 = processSuffix = suffixChanged && entityName.endsWith(DatabaseSchemaImportDialog.this.myEntityNameSuffix);
                    if (!processPrefix && !processSuffix) continue;
                    changed = true;
                    int start = processPrefix ? prefixLen : 0;
                    int length = curLen - (processSuffix ? suffixLen : 0);
                    info.name = newName = (processPrefix ? prefix : "") + entityName.substring(start, length) + (processSuffix ? suffix : "");
                    info.type = newName;
                    DatabaseSchemaImportDialog.this.updateRelationOnTypeChanges(entry.getKey());
                }
                DatabaseSchemaImportDialog.this.myEntityNamePrefix = prefix;
                DatabaseSchemaImportDialog.this.myEntityNameSuffix = suffix;
                if (changed) {
                    DatabaseSchemaImportDialog.this.myTreeView.refreshTreeTable();
                }
            }
        };
        this.myTfEntityNamePrefix.setText(this.myEntityNamePrefix);
        this.myTfEntityNameSuffix.setText(this.myEntityNameSuffix);
        this.myTfEntityNamePrefix.getDocument().addDocumentListener((DocumentListener)suffixPrefixAdapter);
        this.myTfEntityNameSuffix.getDocument().addDocumentListener((DocumentListener)suffixPrefixAdapter);
    }

    public static void setupMappingsAndUnitCombos(final PersistenceFacet facet, final TextFieldWithBrowseButton mappingName, final ComboboxWithBrowseButton cbUnits, final String myUnitName, final JCheckBox cbAddToUnit) {
        String unitName;
        int sIndex;
        mappingName.getButton().setIcon(IconUtil.getAddIcon());
        mappingName.setEnabled(false);
        mappingName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map metaDatas = facet.getSupportedDomMappingFormats();
                List actions = ContainerUtil.mapNotNull(metaDatas.keySet(), metaData -> new AnAction(metaData.getTitle(), metaData.getTitle(), StdFileTypes.XML.getIcon(), (ConfigFileMetaData)metaData, metaDatas, mappingName){
                    final /* synthetic */ ConfigFileMetaData val$metaData;
                    final /* synthetic */ Map val$metaDatas;
                    final /* synthetic */ TextFieldWithBrowseButton val$mappingName;
                    {
                        this.val$metaData = configFileMetaData;
                        this.val$metaDatas = map;
                        this.val$mappingName = textFieldWithBrowseButton;
                        super(arg0, arg1, arg2);
                    }

                    public void actionPerformed(AnActionEvent e1) {
                        String result = DatabaseSchemaImportDialog.chooseFile(facet.getModule(), this.val$metaData, (Class)this.val$metaDatas.get(this.val$metaData));
                        this.val$mappingName.setText(result == null ? "" : result);
                    }
                });
                DatabaseSchemaImportDialog.runPopup(actions, (JComponent)mappingName.getButton(), DataManager.getInstance().getDataContext((Component)cbAddToUnit));
            }
        });
        cbUnits.getButton().setIcon(IconUtil.getAddIcon());
        cbUnits.setEnabled(false);
        cbUnits.getComboBox().setEditable(false);
        cbUnits.getComboBox().setModel(new DefaultComboBoxModel<Object>(DatabaseSchemaImportDialog.getPersistenceUnitNames(facet).toArray()));
        if (myUnitName != null) {
            cbUnits.getComboBox().setSelectedItem(myUnitName);
            cbUnits.setButtonEnabled(false);
            cbUnits.setEnabled(false);
            cbAddToUnit.setSelected(true);
            cbAddToUnit.setEnabled(false);
        }
        int n = sIndex = (unitName = TypePresentationService.getService().getTypePresentableName(facet.getPersistenceUnitClass())) != null ? unitName.toLowerCase().indexOf(115) : -1;
        if (sIndex > -1) {
            unitName = unitName.substring(0, sIndex) + '\u001b' + unitName.substring(sIndex);
        }
        cbAddToUnit.setText(JpaMessages.message((String)"checkbox.database.schema.import.add.to.unit", (Object[])new Object[]{unitName}));
        cbUnits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersistenceManipulator manipulator = PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)facet, PersistenceFacetManipulator.class);
                assert (manipulator != null);
                Runnable runnable = () -> DatabaseSchemaImportDialog.updateUnitCombobox(facet, cbUnits);
                List createUnitActions = ContainerUtil.mapNotNull((Collection)manipulator.getCreateActions(), action -> action.getGroupId() == 10 ? NewGroupPersistence.createAnAction(facet.getModule().getProject(), action, runnable) : null);
                DatabaseSchemaImportDialog.runPopup(createUnitActions, (JComponent)cbUnits.getButton(), DataManager.getInstance().getDataContext((Component)cbAddToUnit));
            }
        });
        cbAddToUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cbUnits.setEnabled(myUnitName == null && cbAddToUnit.isSelected());
            }
        });
    }

    private static void runPopup(List<AnAction> actions, JComponent underneathOf, DataContext dataContext) {
        if (actions.size() != 0) {
            if (actions.size() == 1) {
                AnAction action = actions.get(0);
                AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)dataContext);
                action.update(event);
                if (event.getPresentation().isEnabled()) {
                    action.actionPerformed(event);
                }
            } else {
                Collections.sort(actions, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getTemplatePresentation().getText()), (Comparable)((Object)o2.getTemplatePresentation().getText())));
                DefaultActionGroup group = new DefaultActionGroup("", true);
                for (AnAction action : actions) {
                    group.add(action);
                }
                JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)group, dataContext, null, false).showUnderneathOf((Component)underneathOf);
            }
        }
    }

    private static void updateUnitCombobox(PersistenceFacet facet, ComboboxWithBrowseButton cbUnits) {
        List<String> currentNames = DatabaseSchemaImportDialog.getPersistenceUnitNames(facet);
        ArrayList<String> currentNamesCopy = new ArrayList<String>(currentNames);
        DefaultComboBoxModel model = (DefaultComboBoxModel)cbUnits.getComboBox().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            currentNamesCopy.remove(model.getElementAt(i));
        }
        String selectedElement = currentNamesCopy.size() > 0 ? currentNamesCopy.get(0) : (currentNames.contains(model.getSelectedItem()) ? (String)model.getSelectedItem() : (currentNames.size() > 0 ? currentNames.get(0) : null));
        model.removeAllElements();
        for (String currentName : currentNames) {
            model.addElement(currentName);
        }
        model.setSelectedItem(selectedElement);
    }

    private static List<String> getPersistenceUnitNames(PersistenceFacet facet) {
        List strings = ContainerUtil.mapNotNull((Collection)facet.getPersistenceUnits(), (Function)new NullableFunction<PersistencePackage, String>(){

            public String fun(PersistencePackage persistenceUnit) {
                return JamCommonUtil.isInLibrary((CommonModelElement)persistenceUnit) ? null : (String)persistenceUnit.getName().getValue();
            }
        });
        Collections.sort(strings);
        return strings;
    }

    @Nullable
    public static String chooseFile(Module module, ConfigFileMetaData metaData, Class<? extends PersistenceMappings> domClass) {
        VirtualFile file = JpaUtil.chooseXmlFile(module, metaData, domClass, JpaMessages.message((String)"title.new.persistence.mappings", (Object[])new Object[0]), new ConfigFile[0]);
        return file == null ? null : file.getPath();
    }

    private void configureDataSourceCombo(@Nullable DbDataSource selection) {
        DbDataSource curSelection = (DbDataSource)this.myDatasourceComponent.getComboBox().getSelectedItem();
        DbUIUtil.configureDataSourceComboBox((JComboBox)this.myDatasourceComponent.getComboBox(), (Iterable)DbPsiFacade.getInstance((Project)this.myProject).getDataSources(), (boolean)false);
        this.myDatasourceComponent.getComboBox().setSelectedItem(ObjectUtils.chooseNotNull((Object)selection, (Object)curSelection));
        this.dataSourceChanged();
    }

    private void refreshControls() {
        this.dataSourceChanged();
    }

    private void recalcTreeErrors(Map<Object, String> errorMap) {
        this.myFirstTreeError = null;
        if (this.myDatasource != null) {
            Processor processor = o -> {
                String errors = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    @Nullable
                    public String compute() {
                        return DatabaseSchemaImportDialog.this.getErrorMessage(o);
                    }
                });
                errorMap.put(o, errors);
                if (errors != null && this.myFirstTreeError == null) {
                    this.myFirstTreeError = errors;
                }
                return true;
            };
            if (!ContainerUtil.process((Iterable)DasUtil.getTables((DbDataSource)this.myDatasource), (Processor)processor)) {
                return;
            }
            for (DasTable tableData : DasUtil.getTables((DbDataSource)this.myDatasource)) {
                if (!ContainerUtil.process((Iterable)DasUtil.getColumns((DasObject)tableData), (Processor)processor)) {
                    return;
                }
                List<DatabaseRelationshipData.Role> roleList = this.myRelationsMap.get(tableData);
                if (roleList == null || ContainerUtil.process(roleList, (Processor)processor)) continue;
                return;
            }
        }
    }

    private void dataSourceChanged() {
        this.myDatasource = (DbDataSource)this.myDatasourceComponent.getComboBox().getSelectedItem();
        this.recalcDefaultRelationships();
        this.myTreeView.reset();
    }

    private void recalcDefaultRelationships() {
        boolean selected = this.myCbGuessRelationships.isSelected();
        for (DatabaseRelationshipData relation : this.myDefaultRelations) {
            DatabaseSchemaImporter.removeFromMap(this.myRelationsMap, relation.getSource().getTable(), relation.getSource());
            DatabaseSchemaImporter.removeFromMap(this.myRelationsMap, relation.getTarget().getTable(), relation.getTarget());
        }
        this.myDefaultRelations.clear();
        if (selected && this.myDatasource != null) {
            this.myDefaultRelations.addAll(DatabaseSchemaImporter.calculateDefaultRelationships((Iterable<? extends DasTable>)DasUtil.getTables((DbDataSource)this.myDatasource), this.myRelationsMap, this.myPsiNameHelper));
            for (DatabaseRelationshipData relationshipData : this.myDefaultRelations) {
                this.updateRelationshipInfo(relationshipData.getSource());
                this.updateRelationshipInfo(relationshipData.getTarget());
            }
        }
    }

    public List<DatabaseRelationshipData.Role> getRelationships(DasTable tableData) {
        List<DatabaseRelationshipData.Role> list = this.myRelationsMap.get(tableData);
        return list == null ? Collections.emptyList() : list;
    }

    private void deleteRelationship(DatabaseRelationshipData.Role data) {
        Iterator<DatabaseRelationshipData.Role> it = this.myRelationsMap.get(data.getTable()).iterator();
        while (it.hasNext()) {
            DatabaseRelationshipData.Role role = it.next();
            if (role != data) continue;
            it.remove();
            break;
        }
    }

    private void addOrUpdateRelationship(DatabaseRelationshipData relation, boolean add) {
        DatabaseRelationshipData.Role sourceRole = relation.getSource();
        DatabaseRelationshipData.Role targetRole = relation.getTarget();
        if (add) {
            DatabaseSchemaImporter.addToMap(this.myRelationsMap, sourceRole.getTable(), sourceRole);
            DatabaseSchemaImporter.addToMap(this.myRelationsMap, targetRole.getTable(), targetRole);
        }
        this.updateRelationshipInfo(sourceRole);
        this.updateRelationshipInfo(targetRole);
        this.myTreeView.refreshTreeTable();
    }

    private void updateRelationshipInfo(DatabaseRelationshipData.Role sourceRole) {
        DatabaseSchemaImporter.MappingInfo sourceInfo = this.getInfo(sourceRole);
        sourceInfo.name = sourceRole.getAttribute();
        sourceInfo.type = this.getCmrAttributeType(sourceRole);
    }

    private String getCmrAttributeType(DatabaseRelationshipData.Role role) {
        JavaContainerType type = role.getContainerType();
        String typeName = this.getInfo((Object)role.getOppositeRole().getTable()).type;
        return type == null ? typeName : type.getCollectionTypeText(LanguageLevelUtil.getEffectiveLanguageLevel((Module)this.myFacet.getModule()).isAtLeast(LanguageLevel.JDK_1_5), typeName, role.getMapKey() == null ? this.getPrimaryKeyType(role.getOppositeRole().getTable()) : this.getInfo((Object)role.getMapKey()).type);
    }

    private void updateRelationOnTypeChanges(Object element) {
        DasColumn fieldData;
        DasTable tableData = element instanceof DasTable ? (DasTable)element : null;
        DasColumn dasColumn = fieldData = element instanceof DasColumn ? (DasColumn)element : null;
        assert (tableData != null || fieldData != null);
        for (List<DatabaseRelationshipData.Role> roles : this.myRelationsMap.values()) {
            for (DatabaseRelationshipData.Role role : roles) {
                if (role.getOppositeRole().getTable() != tableData && role.getMapKey() != fieldData) continue;
                this.getInfo((Object)role).type = this.getCmrAttributeType(role);
            }
        }
    }

    public DbDataSource getDatasource() {
        return this.myDatasource;
    }

    private String getPrettyEntityName(DasTable tableData) {
        String name = DatabaseSchemaImporter.getPrettyName(tableData.getName(), true, this.myPsiNameHelper);
        return this.myEntityNamePrefix + name + this.myEntityNameSuffix;
    }

    @Nullable
    public String getEntityName(DasTable tableData) {
        return tableData == null ? null : this.getInfo((Object)tableData).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSchemaImporter.MappingInfo getInfo(Object obj) {
        Map<Object, DatabaseSchemaImporter.MappingInfo> map = this.myInfoMap;
        synchronized (map) {
            DatabaseSchemaImporter.MappingInfo result = this.myInfoMap.get(obj);
            if (result == null) {
                result = this.createInfo(obj);
                this.myInfoMap.put(obj, result);
            }
            return result;
        }
    }

    private DatabaseSchemaImporter.MappingInfo createInfo(Object obj) {
        String type;
        String name;
        boolean enabled;
        if (obj instanceof DasTable) {
            enabled = false;
            name = this.getPrettyEntityName((DasTable)obj);
            type = this.getPrettyEntityName((DasTable)obj);
        } else if (obj instanceof DasColumn) {
            DasColumn fieldData = (DasColumn)obj;
            enabled = false;
            name = DatabaseSchemaImporter.getPrettyFieldName(fieldData, this.myPsiNameHelper);
            type = JdbcTypesUtil.getJavaType((DasColumn)fieldData, (boolean)this.myPreferPrimitiveTypes, (DatabaseDialect)DbImplUtil.getDatabaseDialect((DbElement)this.myDatasource));
        } else if (obj instanceof DatabaseRelationshipData.Role) {
            DatabaseRelationshipData.Role role = (DatabaseRelationshipData.Role)obj;
            enabled = StringUtil.isNotEmpty((String)role.getAttribute()) && this.getInfo((Object)role.getTable()).enabled;
            name = role.getAttribute();
            type = this.getInfo((Object)role.getOppositeRole().getTable()).type;
        } else {
            if (obj != null) {
                throw new AssertionError(obj);
            }
            enabled = false;
            name = null;
            type = null;
        }
        return new DatabaseSchemaImporter.MappingInfo(enabled, name, type);
    }

    private boolean getDefaultEnabled(Object obj) {
        if (obj instanceof DasTable) {
            return DatabaseSchemaImportDialog.isTableTypeAccepted((DasTable)obj);
        }
        if (obj instanceof DasColumn) {
            DasColumn fieldData = (DasColumn)obj;
            return DasUtil.isPrimary((DasColumn)fieldData) || !DasUtil.isForeign((DasColumn)fieldData);
        }
        if (obj instanceof DatabaseRelationshipData.Role) {
            DatabaseRelationshipData.Role role = (DatabaseRelationshipData.Role)obj;
            return StringUtil.isNotEmpty((String)role.getAttribute()) && role.getContainerType() == null && this.getInfo((Object)role.getOppositeRole().getTable()).enabled;
        }
        return false;
    }

    private static boolean isTableTypeAccepted(DasTable obj) {
        return DbImplUtil.isDataTable((ObjectKind)obj.getKind());
    }

    @Nullable
    private String getErrorMessage(Object element) {
        DatabaseSchemaImporter.MappingInfo info = this.getInfo(element);
        if (!info.enabled) {
            return null;
        }
        if (!this.myPsiNameHelper.isIdentifier(info.name, LanguageLevel.HIGHEST)) {
            return JpaMessages.message((String)"db.schema.import.not.identifier", (Object[])new Object[]{info.name});
        }
        Condition condition = data -> {
            if (data == element) {
                return false;
            }
            DatabaseSchemaImporter.MappingInfo info2 = this.getInfo(data);
            return info2.enabled && !"".equals(info.name) && Comparing.equal((String)info.name, (String)info2.name);
        };
        if (element instanceof DasTable) {
            if (ContainerUtil.find((Iterable)DasUtil.getTables((DbDataSource)this.myDatasource), (Condition)condition) != null) {
                return JpaMessages.message((String)"db.schema.import.duplicate.entity.name", (Object[])new Object[]{info.name});
            }
        } else {
            DasTable tableData;
            DasTable dasTable = tableData = element instanceof DasColumn ? ((DasColumn)element).getTable() : ((DatabaseRelationshipData.Role)element).getTable();
            if (ContainerUtil.find((Iterable)DasUtil.getColumns((DasObject)tableData), (Condition)condition) != null || ContainerUtil.find(this.getRelationships(tableData), (Condition)condition) != null) {
                return JpaMessages.message((String)"db.schema.import.duplicate.attribute.name", (Object[])new Object[]{info.name});
            }
        }
        if (element instanceof DatabaseRelationshipData.Role) {
            DatabaseRelationshipData.Role role = (DatabaseRelationshipData.Role)element;
            DasTable targetTable = role.getOppositeRole().getTable();
            if (!this.getInfo((Object)targetTable).enabled) {
                return JpaMessages.message((String)"db.schema.import.opposite.table.not.enabled", (Object[])new Object[]{QNameUtil.getQualifiedName((DasObject)targetTable)});
            }
            if (role.getMapKey() != null) {
                DatabaseSchemaImporter.MappingInfo mapKeyInfo = this.getInfo(role.getMapKey());
                if (!mapKeyInfo.enabled) {
                    return JpaMessages.message((String)"db.schema.import.map.key.field.not.enabled", (Object[])new Object[]{mapKeyInfo.name});
                }
            }
        } else if (element instanceof DasColumn) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            try {
                PsiType type = elementFactory.createTypeFromText(info.type, null);
                String problem = this.myFacet.getModelValidator(null).getAttributeTypeProblem(PersistenceCommonUtil.getTypeInfo((PsiType)type), (PersistentAttributeType)JpaAttributeType.BASIC, "java.sql.Clob".equals(info.type) || "java.sql.Blob".equals(info.type));
                if (problem != null) {
                    return problem;
                }
            }
            catch (IncorrectOperationException e) {
                return JpaMessages.message((String)"db.schema.import.invalid.type", (Object[])new Object[]{info.type});
            }
        }
        return null;
    }

    public PersistencePackage getPersistenceUnit() {
        Class<PersistenceUnit> aClass;
        if (this.myCbAddToUnit.isSelected()) {
            final String unitName = (String)this.myCbUnits.getComboBox().getSelectedItem();
            PersistencePackage unit = (PersistencePackage)ContainerUtil.find((Iterable)this.myFacet.getPersistenceUnits(), (Condition)new Condition<PersistencePackage>(){

                public boolean value(PersistencePackage o) {
                    return unitName.equals(o.getName().getValue());
                }
            });
            if (unit != null) {
                return unit;
            }
        }
        Class<PersistenceUnit> aClass1 = DomElement.class.isAssignableFrom(aClass = this.myFacet.getPersistenceUnitClass()) ? aClass : PersistenceUnit.class;
        return (PersistencePackage)DomManager.getDomManager((Project)this.myFacet.getModule().getProject()).createMockElement(aClass1, this.myFacet.getModule(), true);
    }

    @Nullable
    public PersistenceMappings getPersistenceMapping() {
        PersistenceMappings mappings;
        PersistenceMappings annoMappings;
        PersistenceMappings persistenceMappings = annoMappings = this.myCbGenerateAnnotations.isSelected() ? this.myFacet.getAnnotationEntityMappings() : null;
        if (this.myCbGenerateSingleXml.isSelected()) {
            String mappingFileName = this.myMappingName.getText();
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mappingFileName);
            PsiFile psiFile = file == null ? null : PsiManager.getInstance((Project)this.myFacet.getModule().getProject()).findFile(file);
            PersistenceMappings domMappings = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)psiFile, PersistenceMappings.class, (Module)this.myFacet.getModule());
            mappings = domMappings != null ? (annoMappings == null ? domMappings : (PersistenceMappings)DomService.getInstance().createModelMerger().mergeModels(PersistenceMappings.class, (Object[])new PersistenceMappings[]{domMappings, annoMappings})) : annoMappings;
        } else {
            mappings = annoMappings;
        }
        return mappings;
    }

    public void calcData(DataKey key, DataSink sink) {
        if (PersistenceDataKeys.PERSISTENCE_FACET == key) {
            sink.put(PersistenceDataKeys.PERSISTENCE_FACET, (Object)this.myFacet);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        CaptionComponent captionComponent;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        ComboboxWithBrowseButton comboboxWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:5px:noGrow,fill:609px:grow,left:5px:noGrow", "fill:d:noGrow,top:4dlu:noGrow,fill:d:noGrow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,fill:d:noGrow"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:max(d;4px):grow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new CellConstraints(2, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.database.schema.import.generation"), (int)0, (int)0, null, null));
        this.myCbGenerateAnnotations = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.annotations"));
        jPanel4.add((Component)jCheckBox7, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbAddToUnit = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.add.to.unit"));
        jPanel4.add((Component)jCheckBox6, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMappingName = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel4.add((Component)textFieldWithBrowseButton, new CellConstraints(3, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbUnits = comboboxWithBrowseButton2 = new ComboboxWithBrowseButton();
        jPanel4.add((Component)comboboxWithBrowseButton2, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbGenerateSeparateXML = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.separate.xml"));
        jPanel4.add((Component)jCheckBox5, new CellConstraints(5, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbGenerateSingleXml = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.single.xml"));
        jPanel4.add((Component)jCheckBox4, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbGenerateColumnProps = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.column.properties"));
        jPanel4.add((Component)jCheckBox3, new CellConstraints(5, 1, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("left:5px:noGrow,fill:d:noGrow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:d:noGrow,left:4dlu:noGrow,fill:d:grow,left:5px:noGrow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:d:noGrow"));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new CellConstraints(2, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.database.schema.import.general"), (int)0, (int)0, null, null));
        this.myDatasourceComponent = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel5.add((Component)comboboxWithBrowseButton, new CellConstraints(4, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myTfEntityNameSuffix = jTextField2 = new JTextField();
        jPanel5.add((Component)jTextField2, new CellConstraints(8, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JpaBundle").getString("label.database.schema.import.entity.suffix"));
        jPanel5.add((Component)jLabel2, new CellConstraints(6, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myPackageLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JpaBundle").getString("label.database.schema.import.package"));
        jPanel5.add((Component)jLabel, new CellConstraints(2, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JpaBundle").getString("label.database.schema.import.entity.prefix"));
        jPanel5.add((Component)jLabel3, new CellConstraints(6, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myTfEntityNamePrefix = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new CellConstraints(8, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow", "center:d:grow"));
        jPanel5.add((Component)jPanel6, new CellConstraints(2, 5, 7, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbPreferPrimitiveTypes = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.prefer.primitive.types"));
        jPanel6.add((Component)jCheckBox2, new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new CellConstraints(5, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbGuessRelationships = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.default.relationships"));
        jPanel6.add((Component)jCheckBox, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/JpaBundle").getString("combobox.title.choose.datasource"));
        jPanel5.add((Component)jLabel4, new CellConstraints(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myPackagePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new CellConstraints(4, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCaptionComponent = captionComponent = new CaptionComponent();
        captionComponent.setText(ResourceBundle.getBundle("messages/JpaBundle").getString("caption.database.schema.import.text"));
        captionComponent.setDescriptionText(ResourceBundle.getBundle("messages/JpaBundle").getString("caption.database.schema.import.description"));
        jPanel3.add((Component)captionComponent, new CellConstraints(2, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel, new CellConstraints(2, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.database.schema.import.schema"), (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class DbElementDescriptor
    extends JamNodeDescriptor<DbElement> {
        public DbElementDescriptor(Project project, JamNodeDescriptor<?> parent, DbElement element) {
            super(project, parent, null, (Object)element);
        }

        public SimpleNode[] getChildren() {
            DbElement element = (DbElement)this.getElement();
            List list = ContainerUtil.newSmartList();
            for (DbElement child : element.getDbChildren(DbElement.class, ObjectKind.NONE)) {
                if (!(child instanceof DasColumn) && !(child instanceof DasTable)) continue;
                list.add(new DbElementDescriptor(this.getProject(), this, child));
            }
            if (element instanceof DbTable) {
                for (DatabaseRelationshipData.Role info : DatabaseSchemaImportDialog.this.getRelationships((DasTable)element)) {
                    list.add(new DatabaseRelationshipRoleNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), info));
                }
            }
            return list.toArray(new SimpleNode[list.size()]);
        }

        public boolean isAlwaysLeaf() {
            return this.getElement() instanceof DasColumn;
        }

        protected String getNewNodeText() {
            return DbPresentation.getPresentableName((DasObject)((DasObject)this.getElement()), (boolean)true);
        }

        protected Icon getNewIcon() {
            return ((DbElement)this.getElement()).getIcon();
        }

        public boolean isValid() {
            return ((DbElement)this.getElement()).isValid();
        }

        public DbElement updateElement() {
            if (!((DbElement)this.getElement()).isValid()) {
                return null;
            }
            return (DbElement)this.getElement();
        }

        public String getTooltip() {
            return ((DbElement)this.getElement()).getTypeName();
        }

        public int getWeight() {
            return ((DbElement)this.getElement()).getWeight();
        }
    }

    private class MyNodeDescriptor
    extends JamNodeDescriptor<Object> {
        protected MyNodeDescriptor(Project project) {
            super(project, null, null, null);
        }

        protected String getNewNodeText() {
            return null;
        }

        public JamNodeDescriptor[] getChildren() {
            if (DatabaseSchemaImportDialog.this.myDatasource == null) {
                return EMPTY_ARRAY;
            }
            ArrayList<DbElementDescriptor> result = new ArrayList<DbElementDescriptor>();
            for (DasTable element : DasUtil.getTables((DbDataSource)DatabaseSchemaImportDialog.this.myDatasource)) {
                if (!DatabaseSchemaImportDialog.isTableTypeAccepted(element)) continue;
                result.add(new DbElementDescriptor(this.getProject(), this, (DbElement)element));
            }
            return result.toArray(new JamNodeDescriptor[result.size()]);
        }
    }

    private class MyJavaeeTreeView
    extends JamTreeTableView {
        public MyJavaeeTreeView(Project project) {
            super(project, new MyNodeDescriptor(project));
            this.getTreeTableView().setFocusCycleRoot(true);
            this.getTreeTableView().setShowVerticalLines(true);
            this.getTreeTableView().setIntercellSpacing(new Dimension(1, 0));
            this.getTreeTableView().setSelectionBackground((Color)new JBColor(StripeTableCellRenderer.darken((Color)JBColor.LIGHT_GRAY), new Color(13, 41, 62)));
            this.init();
            new TreeTableSpeedSearch((TreeTable)this.getTreeTableView()).setComparator(new SpeedSearchComparator(false, false));
        }

        public void updateUsagesCache() {
            this.recacheColumn(0);
        }

        @Override
        protected boolean isShowTree() {
            return DatabaseSchemaImportDialog.this.myDatasource != null && !DasUtil.getTables((DbDataSource)DatabaseSchemaImportDialog.this.myDatasource).isEmpty();
        }

        @Override
        @NotNull
        protected String getEmptyPaneText() {
            String string = DatabaseSchemaImportDialog.this.myDatasource == null ? JpaMessages.message((String)"message.text.select.datasource", (Object[])new Object[0]) : JpaMessages.message((String)"message.text.no.tables.found.try.refresh", (Object[])new Object[]{DatabaseSchemaImportDialog.this.myDatasource.getName()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ui/DatabaseSchemaImportDialog$MyJavaeeTreeView", "getEmptyPaneText"));
            }
            return string;
        }

        @Override
        @Nullable
        protected ActionGroup createPopupActionGroup() {
            return this.createToolbarActions();
        }

        private TableCellRenderer getErrorTableCellRenderer(JamNodeDescriptor o, final TableCellRenderer renderer) {
            final String errorMessage = DatabaseSchemaImportDialog.this.getInfo((Object)o.getElement()).errorMessage;
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (errorMessage != null) {
                        component.setForeground((Color)JBColor.RED);
                    } else {
                        component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    }
                    if (component instanceof JComponent) {
                        JComponent jcomp = (JComponent)component;
                        jcomp.setToolTipText((String)(errorMessage != null ? errorMessage : (value == null ? null : value.toString())));
                        jcomp.setBorder(errorMessage == null ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : BorderFactory.createLineBorder((Color)JBColor.RED));
                    }
                    return component;
                }
            };
        }

        @Override
        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new ColumnInfo<JamNodeDescriptor, Boolean>(" "){

                public int getWidth(JTable table) {
                    return new JCheckBox().getPreferredSize().width + 1;
                }

                public Boolean valueOf(JamNodeDescriptor object) {
                    return DatabaseSchemaImportDialog.this.getInfo((Object)object.getElement()).enabled;
                }

                public void setValue(JamNodeDescriptor o, Boolean aValue) {
                    DatabaseSchemaImporter.MappingInfo info = DatabaseSchemaImportDialog.this.getInfo(o.getElement());
                    if (info.enabled == aValue) {
                        return;
                    }
                    info.enabled = aValue;
                    JamNodeDescriptor parent = (JamNodeDescriptor)o.getParentDescriptor();
                    if (parent != null && parent.getElement() != null) {
                        boolean hasSelected = false;
                        SimpleNode[] simpleNodeArray = parent.getChildren();
                        int n = simpleNodeArray.length;
                        for (int i = 0; i < n; ++i) {
                            SimpleNode sibling = simpleNodeArray[i];
                            if (!DatabaseSchemaImportDialog.this.getInfo((Object)sibling.getElement()).enabled) continue;
                            hasSelected = true;
                            break;
                        }
                        DatabaseSchemaImportDialog.this.getInfo((Object)parent.getElement()).enabled = hasSelected;
                        MyJavaeeTreeView.this.cacheNode(parent);
                    }
                    for (SimpleNode child : o.getChildren()) {
                        Object obj = child.getElement();
                        DatabaseSchemaImporter.MappingInfo childInfo = DatabaseSchemaImportDialog.this.getInfo(obj);
                        boolean newValue = aValue != false && StringUtil.isNotEmpty((String)childInfo.name);
                        childInfo.enabled = newValue && DatabaseSchemaImportDialog.this.getDefaultEnabled(obj);
                        MyJavaeeTreeView.this.cacheNode((JamNodeDescriptor)child);
                    }
                }

                public boolean isCellEditable(JamNodeDescriptor o) {
                    return true;
                }

                public TableCellRenderer getRenderer(JamNodeDescriptor o) {
                    return new BooleanTableCellRenderer(){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            component.setToolTipText(Boolean.TRUE.equals(value) ? JpaMessages.message((String)"dialog.datasource.include", (Object[])new Object[0]) : JpaMessages.message((String)"dialog.datasource.exclude", (Object[])new Object[0]));
                            return component;
                        }
                    };
                }

                public TableCellEditor getEditor(JamNodeDescriptor item) {
                    return new BooleanTableCellEditor();
                }
            }, new TreeColumnInfo(JpaMessages.message((String)"dialog.datasource.schema.import.column.database", (Object[])new Object[0])), new ColumnInfo<JamNodeDescriptor, String>(JpaMessages.message((String)"dialog.datasource.schema.import.column.map.as", (Object[])new Object[0])){

                public int getAdditionalWidth() {
                    return 120;
                }

                public String valueOf(JamNodeDescriptor object) {
                    return DatabaseSchemaImportDialog.this.getInfo((Object)object.getElement()).name;
                }

                public void setValue(JamNodeDescriptor o, String aValue) {
                    Object element = o.getElement();
                    DatabaseSchemaImporter.MappingInfo info = DatabaseSchemaImportDialog.this.getInfo(element);
                    if (Comparing.equal((String)info.name, (String)aValue)) {
                        return;
                    }
                    info.name = aValue;
                    if (element instanceof DasTable) {
                        DatabaseSchemaImportDialog.this.getInfo((Object)element).type = aValue;
                        DatabaseSchemaImportDialog.this.updateRelationOnTypeChanges(element);
                    } else if (element instanceof DatabaseRelationshipData.Role) {
                        ((DatabaseRelationshipData.Role)element).setAttribute(info.name);
                    }
                    DatabaseSchemaImportDialog.this.myTreeView.refreshTreeTable();
                }

                public boolean isCellEditable(JamNodeDescriptor o) {
                    return true;
                }

                public TableCellRenderer getCustomizedRenderer(JamNodeDescriptor o, TableCellRenderer renderer) {
                    return MyJavaeeTreeView.this.getErrorTableCellRenderer(o, renderer);
                }

                public TableCellEditor getEditor(JamNodeDescriptor item) {
                    DefaultCellEditor editor = new DefaultCellEditor(new JTextField()){

                        @Override
                        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                            ((JComponent)component).setBorder(null);
                            Color color = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, false, false, row, column).getBackground();
                            component.setBackground(color);
                            return component;
                        }
                    };
                    editor.setClickCountToStart(1);
                    return editor;
                }
            }, new ColumnInfo<JamNodeDescriptor, String>(JpaMessages.message((String)"dialog.datasource.schema.import.column.type", (Object[])new Object[0])){

                public int getAdditionalWidth() {
                    return 120;
                }

                public String valueOf(JamNodeDescriptor object) {
                    return DatabaseSchemaImportDialog.this.getInfo((Object)object.getElement()).type;
                }

                public void setValue(JamNodeDescriptor o, String aValue) {
                    DatabaseSchemaImporter.MappingInfo info = DatabaseSchemaImportDialog.this.getInfo(o.getElement());
                    if (Comparing.equal((String)info.type, (String)aValue)) {
                        return;
                    }
                    info.type = aValue;
                    DatabaseSchemaImportDialog.this.updateRelationOnTypeChanges(o.getElement());
                }

                public boolean isCellEditable(JamNodeDescriptor o) {
                    return o.getElement() instanceof DasColumn;
                }

                public TableCellRenderer getCustomizedRenderer(JamNodeDescriptor o, TableCellRenderer renderer) {
                    return MyJavaeeTreeView.this.getErrorTableCellRenderer(o, renderer);
                }

                public TableCellEditor getEditor(final JamNodeDescriptor item) {
                    ComboBoxCellEditor editor = new ComboBoxCellEditor(){

                        protected boolean isComboboxEditable() {
                            return true;
                        }

                        protected List<String> getComboBoxItems() {
                            String type = DatabaseSchemaImportDialog.this.getInfo((Object)item.getElement()).type;
                            if (item.getElement() instanceof DasColumn) {
                                DasColumn columnInfo = (DasColumn)item.getElement();
                                List<String> list = Arrays.asList(JdbcTypesUtil.getJavaTypeVariants((DasTypedObject)columnInfo, (DatabaseDialect)DbImplUtil.getDatabaseDialect((DbElement)DatabaseSchemaImportDialog.this.myDatasource), (boolean)DatabaseSchemaImportDialog.this.myPreferPrimitiveTypes));
                                if (!list.contains(type)) {
                                    ArrayList<String> result = new ArrayList<String>();
                                    result.add(type);
                                    result.addAll(list);
                                    return result;
                                }
                                return list;
                            }
                            return Collections.singletonList(type);
                        }

                        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                            Color color = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, false, false, row, column).getBackground();
                            ((JComboBox)component).getEditor().getEditorComponent().setBackground(color);
                            return component;
                        }
                    };
                    editor.setClickCountToStart(1);
                    return editor;
                }
            }};
        }

        @Override
        @Nullable
        protected ActionGroup createActionGroup(boolean isPopup) {
            AnAction addRelationship = new AnAction(JpaMessages.message((String)"action.text.add.relationship", (Object[])new Object[0]), null, DomCollectionControl.ADD_ICON){

                public void actionPerformed(AnActionEvent e) {
                    DatabaseRelationshipDialog dialog;
                    DasColumn tableFieldData;
                    DasTable tableData;
                    DatabaseRelationshipData data = new DatabaseRelationshipData();
                    NodeDescriptor nodeDescriptor = MyJavaeeTreeView.this.getSelectedDescriptor();
                    if (nodeDescriptor == null) {
                        return;
                    }
                    if (nodeDescriptor.getElement() instanceof DasTable) {
                        tableData = (DasTable)nodeDescriptor.getElement();
                        tableFieldData = null;
                    } else {
                        tableFieldData = nodeDescriptor.getElement() instanceof DasColumn ? (DasColumn)nodeDescriptor.getElement() : null;
                        tableData = (DasTable)nodeDescriptor.getParentDescriptor().getElement();
                    }
                    data.getSource().setTable(tableData);
                    if (tableFieldData != null) {
                        DasColumn tableFieldDataTarget;
                        if (!DasUtil.getForeignKeys((DasTable)tableFieldData.getTable()).isEmpty()) {
                            DasColumn tmp = null;
                            block0: for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)tableFieldData.getTable())) {
                                MultiRef.It colIt = key.getColumnsRef().iterate();
                                MultiRef.It refIt = key.getRefColumns().iterate();
                                while (colIt.hasNext() && refIt.hasNext()) {
                                    colIt.next();
                                    refIt.next();
                                    if (tableFieldData != colIt.resolve()) continue;
                                    data.getTarget().setTable(key.getRefTable());
                                    tmp = (DasColumn)refIt.resolve();
                                    break block0;
                                }
                            }
                            tableFieldDataTarget = tmp;
                        } else {
                            tableFieldDataTarget = null;
                        }
                        data.getSource().setAttribute(DatabaseSchemaImportDialog.this.getInfo((Object)tableFieldData).name);
                        data.getJoins().add(new DatabaseRelationshipData.Join(tableFieldData, null, null, tableFieldDataTarget));
                    }
                    if ((dialog = new DatabaseRelationshipDialog(MyJavaeeTreeView.this.getProject(), this.getTemplatePresentation().getText(), data, DatabaseSchemaImportDialog.this)).showAndGet()) {
                        DatabaseSchemaImportDialog.this.getInfo((Object)data.getSource().getTable()).enabled = true;
                        DatabaseSchemaImportDialog.this.getInfo((Object)data.getTarget().getTable()).enabled = true;
                        DatabaseSchemaImportDialog.this.addOrUpdateRelationship(data, true);
                    }
                }

                public void update(AnActionEvent e) {
                    Object element;
                    boolean enabled = false;
                    NodeDescriptor nodeDescriptor = MyJavaeeTreeView.this.getSelectedDescriptor();
                    if (nodeDescriptor != null && ((element = nodeDescriptor.getElement()) instanceof DasTable || element instanceof DasColumn || element instanceof DatabaseRelationshipData.Role)) {
                        enabled = true;
                    }
                    e.getPresentation().setEnabled(enabled);
                }
            };
            AnAction editRelationship = new AnAction(JpaMessages.message((String)"action.text.edit.relationship", (Object[])new Object[0]), null, DomCollectionControl.EDIT_ICON){

                public void actionPerformed(AnActionEvent e) {
                    NodeDescriptor nodeDescriptor = MyJavaeeTreeView.this.getSelectedDescriptor();
                    if (nodeDescriptor == null) {
                        return;
                    }
                    DatabaseRelationshipData.Role role = (DatabaseRelationshipData.Role)nodeDescriptor.getElement();
                    DatabaseRelationshipDialog dialog = new DatabaseRelationshipDialog(MyJavaeeTreeView.this.getProject(), this.getTemplatePresentation().getText(), role.getRelationship(), DatabaseSchemaImportDialog.this);
                    if (dialog.showAndGet()) {
                        DatabaseSchemaImportDialog.this.addOrUpdateRelationship(role.getRelationship(), false);
                    }
                }

                public void update(AnActionEvent e) {
                    Object element;
                    boolean enabled = false;
                    NodeDescriptor nodeDescriptor = MyJavaeeTreeView.this.getSelectedDescriptor();
                    if (nodeDescriptor != null && (element = nodeDescriptor.getElement()) instanceof DatabaseRelationshipData.Role) {
                        enabled = true;
                    }
                    e.getPresentation().setEnabled(enabled);
                }
            };
            AnAction deleteRelationship = new AnAction(JpaMessages.message((String)"action.text.delete.relationship", (Object[])new Object[0]), null, DomCollectionControl.REMOVE_ICON){

                public void actionPerformed(AnActionEvent e) {
                    NodeDescriptor nodeDescriptor = MyJavaeeTreeView.this.getSelectedDescriptor();
                    if (nodeDescriptor == null) {
                        return;
                    }
                    DatabaseRelationshipData.Role role = (DatabaseRelationshipData.Role)nodeDescriptor.getElement();
                    DatabaseSchemaImportDialog.this.deleteRelationship(role);
                    DatabaseSchemaImportDialog.this.deleteRelationship(role.getOppositeRole());
                }

                public void update(AnActionEvent e) {
                    Object element;
                    boolean enabled = false;
                    NodeDescriptor nodeDescriptor = MyJavaeeTreeView.this.getSelectedDescriptor();
                    if (nodeDescriptor != null && (element = nodeDescriptor.getElement()) instanceof DatabaseRelationshipData.Role) {
                        enabled = true;
                    }
                    e.getPresentation().setEnabled(enabled);
                }
            };
            AnAction refreshDataSource = new AnAction(JpaMessages.message((String)"action.text.synchronize.datasource.contents", (Object[])new Object[0]), null, PlatformIcons.SYNCHRONIZE_ICON){

                public void actionPerformed(AnActionEvent e) {
                    LocalDataSource dataSource = (LocalDataSource)DatabaseSchemaImportDialog.this.myDatasource.getDelegate();
                    DataSourceUiUtil.performManualSyncTask((Project)DatabaseSchemaImportDialog.this.myProject, (LoaderContext)LoaderContext.loadAll((LocalDataSource)dataSource)).whenCompleteAsync((res, ex) -> DatabaseSchemaImportDialog.this.dataSourceChanged(), AsyncUtil.EDT_EXECUTOR);
                }

                public void update(AnActionEvent e) {
                    boolean enabled = DatabaseSchemaImportDialog.this.myDatasource instanceof DbDataSourceImpl && DatabaseSchemaImportDialog.this.myDatasource.getDelegate() instanceof LocalDataSource;
                    e.getPresentation().setEnabled(enabled);
                }
            };
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(addRelationship);
            group.add(editRelationship);
            group.add(deleteRelationship);
            group.addSeparator();
            group.add(refreshDataSource);
            if (!isPopup) {
                group.addSeparator();
                group.add((AnAction)new MySelectAllAction(JpaMessages.message((String)"action.text.select.all", (Object[])new Object[0]), PlatformIcons.SELECT_ALL_ICON, true));
                group.add((AnAction)new MySelectAllAction(JpaMessages.message((String)"action.text.unselect.all", (Object[])new Object[0]), PlatformIcons.UNSELECT_ALL_ICON, false));
                group.addSeparator();
                JamTreeTableViewExpander expander = new JamTreeTableViewExpander(this);
                CommonActionsManager actionsManager = CommonActionsManager.getInstance();
                group.add(actionsManager.createExpandAllAction((TreeExpander)expander, (JComponent)this.getTreeTableView()));
                group.add(actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)this.getTreeTableView()));
            }
            return group;
        }

        private class MySelectAllAction
        extends AnAction {
            private final boolean mySelectAll;

            public MySelectAllAction(String title, Icon icon, boolean selectAll) {
                super(title, title, icon);
                this.mySelectAll = selectAll;
            }

            public void actionPerformed(AnActionEvent e) {
                for (DatabaseSchemaImporter.MappingInfo mappingInfo : DatabaseSchemaImportDialog.this.myInfoMap.values()) {
                    mappingInfo.enabled = this.mySelectAll;
                }
                DatabaseSchemaImportDialog.this.myTreeView.refreshTreeTable();
            }

            public void update(AnActionEvent e) {
                boolean enabled = false;
                if (DatabaseSchemaImportDialog.this.myDatasource != null) {
                    for (DatabaseSchemaImporter.MappingInfo mappingInfo : DatabaseSchemaImportDialog.this.myInfoMap.values()) {
                        if (mappingInfo.enabled == this.mySelectAll) continue;
                        enabled = true;
                        break;
                    }
                }
                e.getPresentation().setEnabled(enabled);
            }
        }
    }
}

