/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.psi.QlCompositeElement;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQlInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/highlighting/AbstractQlInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/jpa/highlighting/AbstractQlInspection", "checkFile"));
        }
        if (file instanceof QlFile) {
            QlFile qlFile = (QlFile)file;
            if (!this.isFileAccepted(qlFile)) {
                return null;
            }
            return AbstractQlInspection.convertAnnotations2ProblemDescriptors(AbstractQlInspection.checkQl(qlFile), manager, qlFile, isOnTheFly, true, true);
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/AbstractQlInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    protected abstract boolean isFileAccepted(QlFile var1);

    @NotNull
    public String getGroupDisplayName() {
        String string = JpaMessages.message((String)"group.names.jpa.issues", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/AbstractQlInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public static Annotation addToList(Annotation annotation, List<Annotation> highlights) {
        highlights.add(annotation);
        return annotation;
    }

    public static List<Annotation> checkQl(QlFile qlFile) {
        final ArrayList<Annotation> highlights = new ArrayList<Annotation>();
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession((PsiFile)qlFile)){

            public Annotation createErrorAnnotation(@NotNull TextRange range, String message) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/highlighting/AbstractQlInspection$1", "createErrorAnnotation"));
                }
                return AbstractQlInspection.addToList(super.createErrorAnnotation(range, message), highlights);
            }

            public Annotation createErrorAnnotation(@NotNull PsiElement elt, String message) {
                if (elt == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/jpa/highlighting/AbstractQlInspection$1", "createErrorAnnotation"));
                }
                return AbstractQlInspection.addToList(super.createErrorAnnotation(elt, message), highlights);
            }

            public Annotation createInfoAnnotation(@NotNull PsiElement elt, String message) {
                if (elt == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/jpa/highlighting/AbstractQlInspection$1", "createInfoAnnotation"));
                }
                return AbstractQlInspection.addToList(super.createInfoAnnotation(elt, message), highlights);
            }

            public Annotation createWarningAnnotation(@NotNull PsiElement elt, String message) {
                if (elt == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/jpa/highlighting/AbstractQlInspection$1", "createWarningAnnotation"));
                }
                return AbstractQlInspection.addToList(super.createWarningAnnotation(elt, message), highlights);
            }
        };
        final QlVisitor qlAnnotationVisitor = qlFile.getQlModel().createAnnotationVisitor((AnnotationHolder)annotationHolder);
        qlFile.accept(new QlRecursiveVisitor(){

            @Override
            public void visitCompositeElement(@NotNull QlCompositeElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/AbstractQlInspection$2", "visitCompositeElement"));
                }
                QlStatement top = (QlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, QlStatement.class, (boolean)false);
                boolean errors = top != null && PsiTreeUtil.hasErrorElements((PsiElement)top);
                int oldSize = highlights.size();
                super.visitCompositeElement(element);
                if (errors || highlights.size() != oldSize) {
                    return;
                }
                element.accept(qlAnnotationVisitor);
            }
        });
        return highlights;
    }

    @Nullable
    public static ProblemDescriptor[] convertAnnotations2ProblemDescriptors(List<Annotation> highlights, InspectionManager manager, PsiFile file, boolean onTheFly, boolean reportErrors, boolean reportWarnings) {
        if (highlights.isEmpty()) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (Annotation highlight : highlights) {
            PsiElement endElement;
            if (highlight.getStartOffset() == highlight.getEndOffset() || highlight.getSeverity() == HighlightSeverity.INFORMATION || highlight.getSeverity() == HighlightSeverity.WARNING && !reportErrors || highlight.getSeverity() == HighlightSeverity.ERROR && !reportWarnings) continue;
            PsiElement startElement = file.findElementAt(highlight.getStartOffset());
            PsiElement psiElement = endElement = highlight.getStartOffset() == highlight.getEndOffset() ? startElement : file.findElementAt(highlight.getEndOffset() - 1);
            if (startElement == null || endElement == null) continue;
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            List quickFixes = highlight.getQuickFixes();
            if (quickFixes != null) {
                for (Annotation.QuickFixInfo quickFixInfo : quickFixes) {
                    IntentionAction intentionAction = quickFixInfo.quickFix;
                    LocalQuickFix quickFix = intentionAction instanceof LocalQuickFix ? (LocalQuickFix)intentionAction : JpaInspectionUtil.convertToQuickFix(intentionAction);
                    fixes.add(quickFix);
                }
            }
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes().equals((Object)highlight.getEnforcedTextAttributes())) {
                highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            problems.add(manager.createProblemDescriptor(startElement, endElement, highlight.getMessage(), highlightType, onTheFly, fixes.toArray(new LocalQuickFix[fixes.size()])));
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }
}

