/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerSet;
import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.jpa.JpaProjectComponent;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.jpa.model.annotations.mapping.NamedQueryBaseImpl;
import com.intellij.jpa.model.annotations.mapping.ScopedEntityMappingsImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.helpers.PersistenceMappingsModelHelper;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMappingsImpl
extends CommonModelElement.ModuleBase
implements JamEntityMappings,
PersistenceMappingsModelHelper {
    private final Module myModule;
    private final CachedValue<List<EntityImpl>> myEntitiesValue;
    private final CachedValue<List<MappedSuperclassImpl>> mySuperclassesValue;
    private final CachedValue<List<EmbeddableImpl>> myEmbeddablesValue;

    public EntityMappingsImpl(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "<init>"));
        }
        this.myModule = module;
        Project project = this.myModule.getProject();
        Factory scopeFactory = () -> GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)false);
        this.myEntitiesValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{EntityImpl.ENTITY_META});
        this.mySuperclassesValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{MappedSuperclassImpl.MAPPED_SUPERCLASS_META});
        this.myEmbeddablesValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{EmbeddableImpl.EMBEDDABLE_META});
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "getModule"));
        }
        return module;
    }

    @NotNull
    public PersistenceMappingsModelHelper getModelHelper() {
        EntityMappingsImpl entityMappingsImpl = this;
        if (entityMappingsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "getModelHelper"));
        }
        return entityMappingsImpl;
    }

    public GenericValue<PsiPackage> getPackage() {
        return AnnotationGenericValue.NULL;
    }

    public List<NamedQueryBaseImpl.NamedImpl> getNamedQueries() {
        return Collections.emptyList();
    }

    public List<NamedQueryBaseImpl.NativeImpl> getNamedNativeQueries() {
        return Collections.emptyList();
    }

    public EntityListenerSet getDefaultEntityListeners() {
        return new MyEntityListenerSet();
    }

    public List<EntityListenerImpl> getEntityListeners() {
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        ArrayList<EntityListenerImpl> result = new ArrayList<EntityListenerImpl>();
        for (PsiClass psiClass : (Collection)((CachedValue)this.myModule.getProject().getUserData(JpaProjectComponent.ENTITY_LISTENER_CLASSES_KEY)).getValue()) {
            if (!searchScope.contains(psiClass.getContainingFile().getVirtualFile())) continue;
            ContainerUtil.addIfNotNull(result, (Object)EntityListenerImpl.ENTITY_LISTENER_META.getJamElement((PsiModifierListOwner)psiClass));
        }
        return result;
    }

    public List<EntityImpl> getEntities() {
        return (List)this.myEntitiesValue.getValue();
    }

    public List<EmbeddableImpl> getEmbeddables() {
        return (List)this.myEmbeddablesValue.getValue();
    }

    public List<MappedSuperclassImpl> getMappedSuperclasses() {
        return (List)this.mySuperclassesValue.getValue();
    }

    public static Condition<PsiClass> createUnitMappingsCondition(@Nullable GlobalSearchScope searchScope, @Nullable Collection<String> classNames, Collection<String> jarNames, Collection<String> packageNames) {
        return aClass -> {
            if (aClass == null) {
                return false;
            }
            String qName = aClass.getQualifiedName();
            if (classNames != null && classNames.contains(qName)) {
                return true;
            }
            if (packageNames != null && !packageNames.isEmpty()) {
                PsiPackage aPackage;
                PsiDirectory psiDirectory = aClass.getContainingFile().getContainingDirectory();
                PsiPackage psiPackage = aPackage = psiDirectory == null ? null : JavaDirectoryService.getInstance().getPackage(psiDirectory);
                if (aPackage != null && packageNames.contains(aPackage.getQualifiedName())) {
                    return true;
                }
            }
            VirtualFile virtualFile = aClass.getContainingFile().getVirtualFile();
            if (jarNames != null && !jarNames.isEmpty()) {
                VirtualFile jarFile;
                JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                if (virtualFile != null && virtualFile.getFileSystem() == jarFileSystem && (jarFile = jarFileSystem.getVirtualFileForJar(virtualFile)) != null && jarNames.contains(jarFile.getName())) {
                    return true;
                }
            }
            return EntityMappingsImpl.allEmpty(classNames, packageNames, jarNames) && searchScope != null && searchScope.contains(virtualFile);
        };
    }

    public static boolean allEmpty(Collection<String> ... collections) {
        for (Collection<String> collection : collections) {
            if (collection == null || collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public EntityMappings createCustomMappings(Condition<PsiClass> condition) {
        return new ScopedEntityMappingsImpl(this, condition);
    }

    public PropertyMemberType getDeclaredAccess() {
        return null;
    }

    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List<EntityListenerImpl> list = this.getEntityListeners();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "getPersistentListeners"));
        }
        return list;
    }

    @NotNull
    public List<EntityImpl> getPersistentEntities() {
        List<EntityImpl> list = this.getEntities();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "getPersistentEntities"));
        }
        return list;
    }

    @NotNull
    public List<MappedSuperclassImpl> getPersistentSuperclasses() {
        List<MappedSuperclassImpl> list = this.getMappedSuperclasses();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "getPersistentSuperclasses"));
        }
        return list;
    }

    @NotNull
    public List<EmbeddableImpl> getPersistentEmbeddables() {
        List<EmbeddableImpl> list = this.getEmbeddables();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl", "getPersistentEmbeddables"));
        }
        return list;
    }

    private class MyEntityListenerSet
    extends CommonModelElement.ModuleBase
    implements EntityListenerSet,
    JamElement {
        private MyEntityListenerSet() {
        }

        public List<? extends EntityListener> getEntityListeners() {
            return Collections.emptyList();
        }

        @NotNull
        public Module getModule() {
            Module module = EntityMappingsImpl.this.getModule();
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl$MyEntityListenerSet", "getModule"));
            }
            return module;
        }
    }
}

