/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.javaee.model.xml.converters.PersistentUnitJarFileConverter;
import com.intellij.jpa.model.xml.impl.converters.PersistentUnitFileConverterImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentUnitJarFileConverterImpl
extends PersistentUnitJarFileConverter
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)context.getReferenceXmlElement(), context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    @Nullable
    public String toString(@Nullable PsiFile t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        DomElement element = context.getInvocationElement();
        XmlFile persistenceXml = DomUtil.getFile((DomElement)element);
        return PersistentUnitFileConverterImpl.getUnitRootRelativePath(t.getVirtualFile(), persistenceXml);
    }

    public PsiElement resolve(PsiFile o, ConvertContext context) {
        return this.isFileAccepted(o) ? super.resolve((Object)o, context) : null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitJarFileConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        FileReferenceSet set = PersistentUnitFileConverterImpl.createUnitRelativeFileReferenceSet(context, s, element, offset, (Condition<PsiFile>)((Condition)psiFile -> this.isFileAccepted((PsiFile)psiFile)));
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitJarFileConverterImpl", "createReferences"));
        }
        return fileReferenceArray;
    }

    private boolean isFileAccepted(PsiFile psiFile) {
        return psiFile != null && psiFile.getFileType() instanceof ArchiveFileType;
    }

    @NotNull
    public Collection<? extends PsiFile> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitJarFileConverterImpl", "getVariants"));
        }
        return list;
    }
}

