/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.util;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastBinaryExpressionWithTypeKind;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\f"}, d2={"isArrayInitializer", "", "Lorg/jetbrains/uast/UElement;", "isAssignment", "isConstructorCall", "isInstanceCheck", "isMethodCall", "isNestedArrayInitializer", "isNewArray", "isNewArrayWithDimensions", "isNewArrayWithInitializer", "isTypeCast", "uast-common_main"})
@JvmName(name="UastExpressionUtils")
public final class UastExpressionUtils {
    public static final boolean isConstructorCall(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement;
        return Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getKind() : null), (Object)UastCallKind.CONSTRUCTOR_CALL);
    }

    public static final boolean isMethodCall(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement;
        return Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getKind() : null), (Object)UastCallKind.METHOD_CALL);
    }

    public static final boolean isNewArray(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return UastExpressionUtils.isNewArrayWithDimensions($receiver) || UastExpressionUtils.isNewArrayWithInitializer($receiver);
    }

    public static final boolean isNewArrayWithDimensions(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement;
        return Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getKind() : null), (Object)UastCallKind.NEW_ARRAY_WITH_DIMENSIONS);
    }

    public static final boolean isNewArrayWithInitializer(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement;
        return Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getKind() : null), (Object)UastCallKind.NEW_ARRAY_WITH_INITIALIZER);
    }

    @Deprecated(message="Use isArrayInitializer()", replaceWith=@ReplaceWith(imports={}, expression="isArrayInitializer()"))
    public static final boolean isNestedArrayInitializer(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return UastExpressionUtils.isArrayInitializer($receiver);
    }

    public static final boolean isArrayInitializer(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement;
        return Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getKind() : null), (Object)UastCallKind.NESTED_ARRAY_INITIALIZER);
    }

    public static final boolean isTypeCast(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UBinaryExpressionWithType)) {
            uElement = null;
        }
        UBinaryExpressionWithType uBinaryExpressionWithType = (UBinaryExpressionWithType)uElement;
        return (uBinaryExpressionWithType != null ? uBinaryExpressionWithType.getOperationKind() : null) instanceof UastBinaryExpressionWithTypeKind.TypeCast;
    }

    public static final boolean isInstanceCheck(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UBinaryExpressionWithType)) {
            uElement = null;
        }
        UBinaryExpressionWithType uBinaryExpressionWithType = (UBinaryExpressionWithType)uElement;
        return (uBinaryExpressionWithType != null ? uBinaryExpressionWithType.getOperationKind() : null) instanceof UastBinaryExpressionWithTypeKind.InstanceCheck;
    }

    public static final boolean isAssignment(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UElement uElement = $receiver;
        if (!(uElement instanceof UBinaryExpression)) {
            uElement = null;
        }
        UBinaryExpression uBinaryExpression = (UBinaryExpression)uElement;
        return (uBinaryExpression != null ? uBinaryExpression.getOperator() : null) instanceof UastBinaryOperator.AssignOperator;
    }
}

