/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.DefaultGradleConfiguration;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtension;
import org.jetbrains.plugins.gradle.model.DefaultGradleProperty;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleConfiguration;
import org.jetbrains.plugins.gradle.model.GradleExtension;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;

public class DefaultGradleExtensions
implements GradleExtensions {
    private static final long serialVersionUID = 1L;
    private File myParentProjectDir;
    @NotNull
    private final List<GradleExtension> myExtensions = new ArrayList<GradleExtension>();
    @NotNull
    private final List<GradleProperty> myGradleProperties = new ArrayList<GradleProperty>();
    @NotNull
    private final List<ExternalTask> myTasks = new ArrayList<ExternalTask>();
    private final List<GradleConfiguration> myConfigurations = new ArrayList<GradleConfiguration>();

    public DefaultGradleExtensions() {
    }

    public DefaultGradleExtensions(GradleExtensions extensions) {
        this.myParentProjectDir = extensions.getParentProjectDir();
        for (GradleExtension extension : extensions.getExtensions()) {
            this.myExtensions.add(new DefaultGradleExtension(extension));
        }
        for (GradleProperty property : extensions.getGradleProperties()) {
            this.myGradleProperties.add(new DefaultGradleProperty(property));
        }
        for (ExternalTask entry : extensions.getTasks()) {
            this.myTasks.add(new DefaultExternalTask(entry));
        }
        for (ExternalTask entry : extensions.getConfigurations()) {
            this.myConfigurations.add(new DefaultGradleConfiguration((GradleConfiguration)entry));
        }
    }

    @Nullable
    public File getParentProjectDir() {
        return this.myParentProjectDir;
    }

    public void setParentProjectDir(File parentProjectDir) {
        this.myParentProjectDir = parentProjectDir;
    }

    @NotNull
    public List<GradleExtension> getExtensions() {
        List<GradleExtension> list = this.myExtensions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultGradleExtensions", "getExtensions"));
        }
        return list;
    }

    @NotNull
    public List<GradleProperty> getGradleProperties() {
        List<GradleProperty> list = this.myGradleProperties;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultGradleExtensions", "getGradleProperties"));
        }
        return list;
    }

    @NotNull
    public List<ExternalTask> getTasks() {
        List<ExternalTask> list = this.myTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultGradleExtensions", "getTasks"));
        }
        return list;
    }

    @NotNull
    public List<GradleConfiguration> getConfigurations() {
        List<GradleConfiguration> list = this.myConfigurations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultGradleExtensions", "getConfigurations"));
        }
        return list;
    }
}

