/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssSimpleNamedStubElementType;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssCustomPropertySelfReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDeclarationImpl
extends CssNamedStubElement<CssNamedStub<CssDeclaration>>
implements CssDeclaration {
    private volatile CssPropertyDescriptor myCachedDescriptor;
    private volatile long myDescriptorModCount = -1L;

    public CssDeclarationImpl(CssNamedStub<CssDeclaration> stub, CssSimpleNamedStubElementType type) {
        super(stub, type);
    }

    public CssDeclarationImpl(ASTNode node) {
        super(node);
    }

    public String getName() {
        return this.getPropertyName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssDeclarationImpl", "setName"));
        }
        PsiElement element = this.getPropertyNameElement();
        if (element != null) {
            if (this.isCustomProperty() && !name.startsWith("--")) {
                name = "--" + name;
            }
            CssPsiUtil.replaceToken((PsiElement)element, (String)name);
        }
        return this;
    }

    @NotNull
    public String getPropertyName() {
        CssNamedStub stub = (CssNamedStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getPropertyName"));
            }
            return string;
        }
        PsiElement _firstChild = this.getPropertyNameElement();
        if (_firstChild != null) {
            String name = _firstChild.getText();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '\\') continue;
                b.append(c);
            }
            String string = b.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getPropertyName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getPropertyName"));
        }
        return "";
    }

    @Nullable
    public PsiElement getPropertyNameElement() {
        ASTNode firstIdentifier = (ASTNode)this.findChildByType(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_HASH}));
        return firstIdentifier != null ? firstIdentifier.getPsi() : null;
    }

    @Nullable
    public CssTermList getValue() {
        return (CssTermList)this.findChildByType(CssElementTypes.CSS_TERM_LIST);
    }

    @NotNull
    public TextRange getTrimmedValueTextRange() {
        TextRange textRange = CssPsiUtil.getValueTextRange((CssValueOwner)this);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getTrimmedValueTextRange"));
        }
        return textRange;
    }

    @NotNull
    public TextRange getValueTextRange() {
        TextRange textRange = CssPsiUtil.getValueTextRange((CssValueOwner)this);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getValueTextRange"));
        }
        return textRange;
    }

    public boolean isShorthandProperty() {
        CssPropertyDescriptor descriptor = this.getDescriptor();
        return descriptor != null && descriptor.isShorthandValue();
    }

    public boolean isCustomProperty() {
        return StringUtil.startsWith((CharSequence)this.getPropertyName(), (CharSequence)"--");
    }

    @NotNull
    public String[] expandShorthandProperty() {
        CssPropertyDescriptor descriptor = this.getDescriptor();
        String[] stringArray = descriptor == null ? ArrayUtil.EMPTY_STRING_ARRAY : descriptor.expand((CssDeclaration)this);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "expandShorthandProperty"));
        }
        return stringArray;
    }

    public String[] getShorthandValue(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/CssDeclarationImpl", "getShorthandValue"));
        }
        PsiElement[] values = this.getShorthandPsiValue(propertyName);
        if (values == null) {
            return null;
        }
        if (values.length == 1 || values.length == 2 && values[0].getText().equals(values[1].getText())) {
            PsiElement term;
            if ("background-size".equalsIgnoreCase(propertyName)) {
                return new String[]{values[0].getText() + " " + values[0].getText()};
            }
            if ("background-position".equalsIgnoreCase(propertyName) && (term = values[0]) instanceof CssTerm && ((CssTerm)term).getTermType() != CssTermTypes.IDENT) {
                return new String[]{values[0].getText() + " " + values[0].getText()};
            }
        }
        String[] result = ArrayUtil.newStringArray((int)values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getText();
        }
        return result;
    }

    @Nullable
    public PsiElement[] getShorthandPsiValue(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/CssDeclarationImpl", "getShorthandPsiValue"));
        }
        if (!this.isShorthandProperty()) {
            return null;
        }
        CssPropertyDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        String[] propertyNames = this.expandShorthandProperty();
        if (!Arrays.asList(propertyNames).contains(propertyName)) {
            return null;
        }
        return descriptor.getShorthandPsiValue((CssDeclaration)this, propertyName);
    }

    public boolean isImportant() {
        return CssPsiUtil.findToken((CssElement)this, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IMPORTANT})) != null;
    }

    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssDeclarationImpl)) {
            return false;
        }
        CssDeclarationImpl declaration = (CssDeclarationImpl)((Object)object);
        CssTermList value = this.getValue();
        CssTermList declarationValue = declaration.getValue();
        return this.getPropertyName().equalsIgnoreCase(declaration.getPropertyName()) && value != null && declarationValue != null && value.getText().equals(declarationValue.getText());
    }

    public int equalityHashCode() {
        return 31 * this.getPropertyName().toLowerCase(Locale.US).hashCode() + CssPsiUtil.hashCodeForElement((PsiElement)this.getValue());
    }

    public void setValue(String propertyValue) throws IncorrectOperationException {
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)this);
        CssTermList newValue = CssElementFactory.getInstance((Project)this.getProject()).createPropertyValue(propertyValue, language);
        CssTermList oldValue = this.getValue();
        if (oldValue != null) {
            oldValue.replace((PsiElement)newValue);
        }
    }

    @Nullable
    public CssPropertyDescriptor getDescriptor() {
        PsiManagerEx manager = this.getManager();
        if (manager == null) {
            return null;
        }
        long curModCount = manager.getModificationTracker().getModificationCount();
        if (this.myDescriptorModCount != curModCount) {
            this.myCachedDescriptor = CssDescriptorsUtil.getPropertyDescriptor((CssDeclaration)this);
            this.myDescriptorModCount = curModCount;
        }
        return this.myCachedDescriptor;
    }

    public boolean isHack() {
        String text = this.getText().trim();
        if (CssUtil.isHackPropertyName(text)) {
            return true;
        }
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)this);
        return nextVisibleLeaf instanceof PsiComment && CssUtil.isHackComment(nextVisibleLeaf.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssDeclarationImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssDeclaration((CssDeclaration)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getDescriptors() {
        Collection<? extends CssPropertyDescriptor> collection = this.getDescriptors((PsiElement)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getDescriptors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/CssDeclarationImpl", "getDescriptors"));
        }
        Collection collection = CssDescriptorsUtil.getPropertyDescriptors((String)this.getPropertyName(), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getDescriptors"));
        }
        return collection;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.isCustomProperty() ? AllIcons.Css.Custom_property : null;
    }

    public ItemPresentation getPresentation() {
        return new CssNamedItemPresentation((PsiNamedElement)this, StringUtil.trimStart((String)this.getName(), (String)"--"));
    }

    public PsiReference getReference() {
        PsiElement element;
        if (this.isCustomProperty() && (element = this.getPropertyNameElement()) != null) {
            int startOffset = this.getTextOffset() - this.getTextRange().getStartOffset();
            return new CssCustomPropertySelfReference(this, TextRange.from((int)startOffset, (int)this.getName().length()));
        }
        return super.getReference();
    }
}

