/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.AtRulePresentation;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.CssMediaStub;
import com.intellij.psi.css.impl.stubs.CssMediaStubElementType;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMediaImpl
extends CssStubElement<CssMediaStub>
implements CssMedia {
    public CssMediaImpl(@NotNull CssMediaStub stub, @NotNull CssMediaStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssMediaImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssMediaImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssMediaImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssMediaImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public CssRuleset[] getRulesets() {
        CssRuleset[] cssRulesetArray = (CssRuleset[])this.getStubOrPsiChildren(CssElementTypes.CSS_RULESET, CssRuleset.ARRAY_FACTORY);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediaImpl", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @Nullable
    public CssMediumList getMediumList() {
        return (CssMediumList)PsiTreeUtil.getChildOfType((PsiElement)this, CssMediumList.class);
    }

    @NotNull
    public String getName() {
        if ("@media" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediaImpl", "getName"));
        }
        return "@media";
    }

    @NotNull
    public Set<CssMediaType> getMediaTypes() {
        CssMediaStub stub = (CssMediaStub)this.getStub();
        if (stub != null) {
            Set<CssMediaType> set = stub.getMediaTypes();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediaImpl", "getMediaTypes"));
            }
            return set;
        }
        CssMediumList mediumList = this.getMediumList();
        Set set = mediumList != null ? mediumList.getTypes() : ContainerUtil.newHashSet((Object[])new CssMediaType[]{CssMediaType.SCREEN});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediaImpl", "getMediaTypes"));
        }
        return set;
    }

    public ItemPresentation getPresentation() {
        return new AtRulePresentation((CssAtRule)this, ("media " + CssPsiUtil.getTokenText((PsiElement)this.getMediumList())).trim());
    }

    @NotNull
    public CssContextType getType() {
        CssContextType cssContextType = CssContextType.MEDIA;
        if (cssContextType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediaImpl", "getType"));
        }
        return cssContextType;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssMediaImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitAtRule((CssAtRule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

