/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssNavigableDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PseudoSelectorsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final PseudoSelectorInsertHandler INSERT_HANDLER = new PseudoSelectorInsertHandler();

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/PseudoSelectorsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/PseudoSelectorsCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        CssPseudoSelector pseudoSelector = (CssPseudoSelector)PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{CssPseudoSelector.class});
        int colonsCount = pseudoSelector != null ? pseudoSelector.getColonPrefixLength() : PseudoSelectorsCompletionProvider.calculateColonsCount(parameters.getEditor().getDocument(), position.getTextRange().getStartOffset());
        MultiMap map = MultiMap.create();
        for (CssPseudoSelectorDescriptor descriptor : CssDescriptorsUtil.getAllPseudoSelectorDescriptors((PsiElement)position)) {
            map.putValue((Object)(descriptor.getId() + String.valueOf(descriptor.getColonPrefixLength())), (Object)descriptor);
        }
        for (Map.Entry entry : map.entrySet()) {
            Set<VirtualFile> importedFiles;
            PsiElement navElement;
            CssElementDescriptor descriptor = CssCompositeElementDescriptor.create((Collection)((Collection)entry.getValue()));
            CssPseudoSelectorDescriptor mainDescriptor = PseudoSelectorsCompletionProvider.getMainDescriptor(descriptor);
            if (mainDescriptor == null) continue;
            int colonsDiff = Math.abs(mainDescriptor.getColonPrefixLength() - colonsCount);
            int priority = 10 - colonsDiff;
            if (descriptor instanceof CssNavigableDescriptor && (navElement = ((CssNavigableDescriptor)descriptor).getElement()) != null && (importedFiles = CssUtil.getImportedFiles(position.getContainingFile().getOriginalFile(), position, false)).contains(navElement.getContainingFile().getVirtualFile())) {
                ++priority;
            }
            result.addElement(CssCompletionUtil.lookupItemForDescriptor(descriptor, INSERT_HANDLER, priority));
        }
    }

    @Nullable
    private static CssPseudoSelectorDescriptor getMainDescriptor(@Nullable CssElementDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        CssElementDescriptor mainDescriptor = descriptor instanceof CssCompositeElementDescriptor ? ((CssCompositeElementDescriptor)descriptor).getDescriptorFromLatestSpec() : descriptor;
        return (CssPseudoSelectorDescriptor)ObjectUtils.tryCast((Object)mainDescriptor, CssPseudoSelectorDescriptor.class);
    }

    private static int calculateColonsCount(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/impl/util/completion/provider/PseudoSelectorsCompletionProvider", "calculateColonsCount"));
        }
        int colonsCount = 0;
        CharSequence content = document.getCharsSequence();
        while (offset > 0 && content.charAt(offset - 1) == ':') {
            ++colonsCount;
            --offset;
        }
        return colonsCount;
    }

    private static class PseudoSelectorInsertHandler
    implements InsertHandler<LookupElement> {
        private PseudoSelectorInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            CssPseudoSelectorDescriptor pseudoSelectorDescriptor;
            Object elementObject = item.getObject();
            if (elementObject instanceof CssDescriptorOwner) {
                elementObject = ContainerUtil.getFirstItem((Collection)((CssDescriptorOwner)elementObject).getDescriptors());
            }
            if (elementObject instanceof CssElementDescriptor && (pseudoSelectorDescriptor = PseudoSelectorsCompletionProvider.getMainDescriptor((CssElementDescriptor)elementObject)) != null) {
                PseudoSelectorInsertHandler.handleColons(context, pseudoSelectorDescriptor);
                if (pseudoSelectorDescriptor.hasArguments()) {
                    PseudoSelectorInsertHandler.handleParentheses(context);
                }
            }
        }

        private static void handleParentheses(InsertionContext context) {
            Editor editor = context.getEditor();
            if (context.getCompletionChar() == '(') {
                context.setAddCompletionChar(false);
            }
            Project project = editor.getProject();
            if (!PseudoSelectorInsertHandler.isStringAtLeftParenthesis(editor) && project != null) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"()");
                int offset = editor.getCaretModel().getOffset() - 1;
                if (offset > 0) {
                    editor.getCaretModel().moveToOffset(offset);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }

        private static void handleColons(InsertionContext context, CssPseudoSelectorDescriptor descriptor) {
            int offset = context.getStartOffset();
            int colonsCount = PseudoSelectorsCompletionProvider.calculateColonsCount(context.getDocument(), offset);
            int expectedColonsCount = descriptor.getColonPrefixLength();
            if (expectedColonsCount > colonsCount) {
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)":");
            } else {
                offset = context.getStartOffset() - colonsCount;
                for (int i = 0; i < colonsCount - expectedColonsCount; ++i) {
                    context.getDocument().deleteString(offset, offset + 1);
                }
            }
        }

        private static boolean isStringAtLeftParenthesis(Editor editor) {
            int startOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == '(';
        }
    }
}

