/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.inspections.suppress.CssSuppressAllForAtRuleCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressAllForRulesetCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressForAtRuleCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressForRulesetCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressForStatementCommentFix;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSuppressionUtil {
    private static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("/\\*\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*\\*/");

    public static boolean isSuppressedFor(final @Nullable PsiElement element, final @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "isSuppressedFor"));
        }
        if (element == null) {
            return true;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (CssSuppressionUtil.getSuppressedInStatement(element, toolId) != null) {
                    return true;
                }
                if (CssSuppressionUtil.getSuppressedInRuleset(element, toolId) != null) {
                    return true;
                }
                if (CssSuppressionUtil.getSuppressedInBlockAtRule(element, toolId) != null) {
                    return true;
                }
                return false;
            }
        });
    }

    @Nullable
    public static PsiElement getSuppressibleStatement(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssOneLineStatement.class});
    }

    @Nullable
    public static PsiElement getSuppressibleRuleset(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssRuleset.class});
    }

    @Nullable
    public static PsiElement getSuppressibleAtRule(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
    }

    @Nullable
    private static PsiElement getSuppressedInStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressedInStatement"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressedInStatement"));
        }
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, CssOneLineStatement.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    private static PsiElement getSuppressedInRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressedInRuleset"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressedInRuleset"));
        }
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, CssRuleset.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    private static PsiElement getSuppressedInBlockAtRule(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressedInBlockAtRule"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressedInBlockAtRule"));
        }
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, CssAtRule.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressQuickFixes(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressQuickFixes"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new CssSuppressForStatementCommentFix(toolId), new CssSuppressForRulesetCommentFix(toolId), new CssSuppressAllForRulesetCommentFix(), new CssSuppressForAtRuleCommentFix(toolId), new CssSuppressAllForAtRuleCommentFix()};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil", "getSuppressQuickFixes"));
        }
        return suppressQuickFixArray;
    }
}

