/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.velocity.psi.VtlExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VtlExpressionTypeCalculator {
    public static final VtlExpressionTypeCalculator EQUALITY = new VtlExpressionTypeCalculator(){

        @Override
        @Nullable
        public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
            if (leftOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$1", "calculateBinary"));
            }
            if (rightOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$1", "calculateBinary"));
            }
            return PsiType.BOOLEAN;
        }
    };
    public static final VtlExpressionTypeCalculator PLUS_CALCULATOR = new VtlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
            if (leftOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$2", "calculateBinary"));
            }
            if (rightOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$2", "calculateBinary"));
            }
            PsiType rightType = rightOperand.getPsiType();
            if (rightType == null || rightType.equalsToText("java.lang.String")) {
                return rightType;
            }
            PsiType leftType = leftOperand.getPsiType();
            if (leftType == null || leftType.equalsToText("java.lang.String")) {
                return leftType;
            }
            return VtlExpressionTypeCalculator.checkAndReturnNumeric(leftType, rightType);
        }
    };
    public static final VtlExpressionTypeCalculator MINUS_CALCULATOR = new VtlExpressionTypeCalculator(){

        @Override
        public PsiType calculateUnary(@NotNull VtlExpression operand) {
            if (operand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$3", "calculateUnary"));
            }
            PsiType type = operand.getPsiType();
            return type != null && TypeConversionUtil.isNumericType((PsiType)type) ? type : null;
        }
    };
    public static final VtlExpressionTypeCalculator MULTIPLICATIVE_CALCULATOR = new VtlExpressionTypeCalculator(){};

    private VtlExpressionTypeCalculator() {
    }

    @Nullable
    public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
        if (leftOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator", "calculateBinary"));
        }
        if (rightOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator", "calculateBinary"));
        }
        PsiType rightType = rightOperand.getPsiType();
        if (rightType == null) {
            return null;
        }
        PsiType leftType = leftOperand.getPsiType();
        if (leftType == null) {
            return null;
        }
        return VtlExpressionTypeCalculator.checkAndReturnNumeric(leftType, rightType);
    }

    @Nullable
    public PsiType calculateUnary(@NotNull VtlExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/velocity/psi/VtlExpressionTypeCalculator", "calculateUnary"));
        }
        throw new AssertionError(this);
    }

    private static PsiType checkAndReturnNumeric(PsiType leftType, PsiType rightType) {
        if (TypeConversionUtil.isNumericType((PsiType)leftType) && TypeConversionUtil.isNumericType((PsiType)rightType)) {
            return TypeConversionUtil.unboxAndBalanceTypes((PsiType)leftType, (PsiType)rightType);
        }
        return null;
    }

    public static class BooleanExpressionTypeCalculator
    extends VtlExpressionTypeCalculator {
        private final PsiType myOperandType;

        public BooleanExpressionTypeCalculator(PsiType operandType) {
            this.myOperandType = operandType;
        }

        @Override
        public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
            if (leftOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$BooleanExpressionTypeCalculator", "calculateBinary"));
            }
            if (rightOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$BooleanExpressionTypeCalculator", "calculateBinary"));
            }
            if (!this.isCorrectOperandType(leftOperand.getPsiType()) || !this.isCorrectOperandType(rightOperand.getPsiType())) {
                return null;
            }
            return PsiType.BOOLEAN;
        }

        private boolean isCorrectOperandType(PsiType opType) {
            return opType == null || this.myOperandType.isConvertibleFrom(opType);
        }

        @Override
        public PsiType calculateUnary(@NotNull VtlExpression operand) {
            if (operand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$BooleanExpressionTypeCalculator", "calculateUnary"));
            }
            if (!this.isCorrectOperandType(operand.getPsiType())) {
                return null;
            }
            return PsiType.BOOLEAN;
        }
    }
}

