/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.velocity.Icons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlEditorHighlighter;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFileType
extends LanguageFileType
implements TemplateLanguageFileType {
    public static final VtlFileType INSTANCE = new VtlFileType();

    private VtlFileType() {
        super((Language)VtlLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/velocity/psi/files/VtlFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/velocity/psi/files/VtlFileType$1", "getEditorHighlighter"));
                }
                return new VtlEditorHighlighter(project, virtualFile, colors);
            }
        });
    }

    @NotNull
    @NonNls
    public String getName() {
        if ("VTL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileType", "getName"));
        }
        return "VTL";
    }

    @NotNull
    public String getDescription() {
        String string = VelocityBundle.message("file.type.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if ("vm" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileType", "getDefaultExtension"));
        }
        return "vm";
    }

    @Nullable
    public Icon getIcon() {
        return Icons.VTL_ICON;
    }

    @NotNull
    @NonNls
    public String[] getExtensions() {
        String[] stringArray = new String[]{this.getDefaultExtension(), "ft", "vsl"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileType", "getExtensions"));
        }
        return stringArray;
    }
}

