/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PathUtil {
    @NotNull
    public static String normalize(@NotNull String path) {
        int slashIndex;
        int index;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/util/PathUtil", "normalize"));
        }
        path = FileUtil.toSystemIndependentName((String)path);
        path = StringUtil.trimEnd((String)path, (String)"/");
        while (path.contains("/./")) {
            path = path.replace("/./", "/");
        }
        path = StringUtil.trimStart((String)path, (String)"./");
        path = StringUtil.trimEnd((String)path, (String)"/.");
        while ((index = path.indexOf("/..")) >= 0 && (slashIndex = path.substring(0, index).lastIndexOf(47)) >= 0) {
            path = path.substring(0, slashIndex) + path.substring(index + 3);
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "normalize"));
        }
        return string;
    }

    @NotNull
    public static String getRelative(@NotNull String baseRoot, @NotNull String path) {
        if (baseRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRoot", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
        }
        int prefix = PathUtil.findCommonPathPrefixLength(baseRoot = PathUtil.normalize(baseRoot), path = PathUtil.normalize(path));
        if (prefix != 0) {
            baseRoot = baseRoot.substring(prefix);
            path = path.substring(prefix);
            if (!baseRoot.isEmpty()) {
                String string = PathUtil.normalize(PathUtil.revertRelativePath(baseRoot.substring(1)) + path);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
                }
                return string;
            }
            if (!path.isEmpty()) {
                String string = path.substring(1);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
                }
                return string;
            }
            if ("." == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
            }
            return ".";
        }
        if (FileUtil.isAbsolute((String)path)) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
            }
            return string;
        }
        String string = PathUtil.normalize(PathUtil.revertRelativePath(baseRoot) + "/" + path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "getRelative"));
        }
        return string;
    }

    private static int findCommonPathPrefixLength(@NotNull String path1, @NotNull String path2) {
        int beg;
        int new_end;
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "org/jetbrains/idea/eclipse/util/PathUtil", "findCommonPathPrefixLength"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "org/jetbrains/idea/eclipse/util/PathUtil", "findCommonPathPrefixLength"));
        }
        int end = -1;
        while ((new_end = PathUtil.endOfToken(path1, beg = end + 1)) == PathUtil.endOfToken(path2, beg) && path1.substring(beg, new_end).equals(path2.substring(beg, new_end)) && (end = new_end) != path1.length()) {
        }
        return end < 0 ? 0 : end;
    }

    private static int endOfToken(String s, int index) {
        return (index = s.indexOf(47, index)) == -1 ? s.length() : index;
    }

    @NotNull
    private static String revertRelativePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/util/PathUtil", "revertRelativePath"));
        }
        if (path.equals(".")) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "revertRelativePath"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("..");
        int count = PathUtil.normalize(path).split("/").length;
        while (--count > 0) {
            sb.append("/..");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/util/PathUtil", "revertRelativePath"));
        }
        return string;
    }
}

