/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.AopProvider;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.IntroductionManipulator;
import com.intellij.aop.JavaArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.jam.PointcutContainer;
import com.intellij.aop.psi.AopPointcutExpressionLanguage;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopLanguageInjector
implements ConcatenationAwareInjector {
    private static final Set<String> POINTCUT_ANNOTATIONS = new THashSet(Arrays.asList("org.aspectj.lang.annotation.Pointcut", "org.aspectj.lang.annotation.After", "org.aspectj.lang.annotation.AfterReturning", "org.aspectj.lang.annotation.AfterThrowing", "org.aspectj.lang.annotation.Around", "org.aspectj.lang.annotation.Before"));
    private static final Key<PsiMethod> AOP_METHOD_KEY = Key.create((String)"AopMethod");
    private static final Key<PsiField> AOP_FIELD_KEY = Key.create((String)"AopField");
    private static final ElementPattern AOP_ANNO_PATTERN = ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().withText((ElementPattern)StandardPatterns.string().longerThan(1))).and(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)StandardPatterns.string().oneOf(POINTCUT_ANNOTATIONS), "value"), PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.aspectj.lang.annotation.AfterReturning", "org.aspectj.lang.annotation.AfterThrowing"}), "pointcut")}))).inside(true, (ElementPattern)PsiJavaPatterns.psiMethod().save(AOP_METHOD_KEY));
    private static final ElementPattern AOP_INTRO_PATTERN = ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().withText((ElementPattern)StandardPatterns.string().longerThan(1))).annotationParam("org.aspectj.lang.annotation.DeclareParents", "value")).inside(true, (ElementPattern)PsiJavaPatterns.psiField().save(AOP_FIELD_KEY));

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/aop/jam/AopLanguageInjector", "getLanguagesToInject"));
        }
        if (operands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operands", "com/intellij/aop/jam/AopLanguageInjector", "getLanguagesToInject"));
        }
        if (operands.length == 0) {
            return;
        }
        final PsiElement host = operands[0];
        ProcessingContext context = new ProcessingContext();
        if (AOP_ANNO_PATTERN.accepts((Object)host, context) && !host.getProject().isDefault()) {
            PsiMethod method = (PsiMethod)context.get(AOP_METHOD_KEY);
            if (method != null && AopLanguageInjector.getAopAdvisedElementsSearcher(host) != null) {
                PointcutContainer container = JamAopModel.getAdvice(method);
                if (container == null) {
                    container = JamAopModel.getPointcut(method);
                }
                if (container != null) {
                    final JavaArgNamesManipulator manipulator = new JavaArgNamesManipulator(container);
                    LocalAopModel model = new LocalAopModel(host, method){

                        @Override
                        public AopAdvisedElementsSearcher getAdvisedElementsSearcher() {
                            return AopLanguageInjector.getAopAdvisedElementsSearcher(host);
                        }

                        @Override
                        @NotNull
                        public ArgNamesManipulator getArgNamesManipulator() {
                            JavaArgNamesManipulator javaArgNamesManipulator = manipulator;
                            if (javaArgNamesManipulator == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopLanguageInjector$1", "getArgNamesManipulator"));
                            }
                            return javaArgNamesManipulator;
                        }
                    };
                    host.putUserData(LocalAopModel.KEY, (Object)model);
                    List<PsiLanguageInjectionHost> validOperands = AopLanguageInjector.validStringLiteralExpressions(operands);
                    if (!validOperands.isEmpty()) {
                        registrar.startInjecting((Language)AopPointcutExpressionLanguage.getInstance());
                        for (PsiLanguageInjectionHost operand : validOperands) {
                            TextRange range = AopLanguageInjector.getLiteralRange((PsiElement)operand);
                            registrar.addPlace(null, null, operand, range);
                        }
                        registrar.doneInjecting();
                    }
                }
            }
        } else if (AOP_INTRO_PATTERN.accepts((Object)host, context) && !host.getProject().isDefault() && AopLanguageInjector.getAopAdvisedElementsSearcher(host) != null) {
            PsiField field = (PsiField)context.get(AOP_FIELD_KEY);
            PsiAnnotation annotation = field.getModifierList().findAnnotation("org.aspectj.lang.annotation.DeclareParents");
            host.putUserData(LocalAopModel.KEY, (Object)new JavaIntroLocalAopModel(host, annotation, field));
            registrar.startInjecting((Language)AopPointcutExpressionLanguage.getInstance());
            for (int i = 0; i < operands.length; ++i) {
                PsiElement operand = operands[i];
                if (!(operand instanceof PsiLanguageInjectionHost)) continue;
                TextRange range = AopLanguageInjector.getLiteralRange(operand);
                registrar.addPlace(i == 0 ? "target(" : null, i == operands.length - 1 ? ")" : null, (PsiLanguageInjectionHost)operand, range);
            }
            registrar.doneInjecting();
        }
    }

    private static List<PsiLanguageInjectionHost> validStringLiteralExpressions(PsiElement ... operands) {
        ArrayList<PsiLanguageInjectionHost> validOperands = new ArrayList<PsiLanguageInjectionHost>(operands.length);
        for (PsiElement operand : operands) {
            if (!(operand instanceof PsiLiteralExpressionImpl) || !(((PsiLiteralExpression)operand).getValue() instanceof String)) continue;
            validOperands.add((PsiLanguageInjectionHost)operand);
        }
        return validOperands;
    }

    private static TextRange getLiteralRange(PsiElement operand) {
        int length = operand.getTextLength();
        return TextRange.from((int)1, (int)(length == 1 ? length - 1 : length - 2));
    }

    @Nullable
    public static AopAdvisedElementsSearcher getAopAdvisedElementsSearcher(PsiElement element) {
        List<AopProvider> providers = AopLanguageInjector.getAopProviders(element);
        if (providers.isEmpty()) {
            return null;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return null;
        }
        return providers.get(0).getAdvisedElementsSearcher((PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)psiClass));
    }

    @NotNull
    public static List<AopProvider> getAopProviders(PsiElement element) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            List<AopProvider> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopLanguageInjector", "getAopProviders"));
            }
            return list;
        }
        List list = ContainerUtil.findAll((Object[])Extensions.getExtensions(AopProvider.EXTENSION_POINT_NAME), aopProvider -> aopProvider.getAdvisedElementsSearcher((PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)psiClass)) != null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopLanguageInjector", "getAopProviders"));
        }
        return list;
    }

    private static class JavaIntroLocalAopModel
    extends LocalAopModel {
        private final PsiAnnotation myAnnotation;
        private final PsiField myField;

        public JavaIntroLocalAopModel(PsiElement host, PsiAnnotation annotation, PsiField field) {
            super(host, null);
            this.myAnnotation = annotation;
            this.myField = field;
        }

        @Override
        public AopAdvisedElementsSearcher getAdvisedElementsSearcher() {
            return AopLanguageInjector.getAopAdvisedElementsSearcher(this.getHost());
        }

        @Override
        @Nullable
        public IntroductionManipulator getIntroductionManipulator() {
            return new IntroductionManipulator(){

                @Override
                @NotNull
                public PsiElement getCommonProblemElement() {
                    PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = myAnnotation.getNameReferenceElement();
                    if (psiJavaCodeReferenceElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopLanguageInjector$JavaIntroLocalAopModel$1", "getCommonProblemElement"));
                    }
                    return psiJavaCodeReferenceElement;
                }

                @Override
                public AopIntroduction getIntroduction() {
                    return JamAopModel.getIntroduction(myField);
                }

                @Override
                public void defineDefaultImpl(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                    VirtualFile virtualFile = myField.getContainingFile().getVirtualFile();
                    JamCommonUtil.setAnnotationAttributeValue((PsiAnnotation)myAnnotation, (String)"defaultImpl", (String)"a");
                    PsiAnnotationMemberValue value = myField.getModifierList().findAnnotation("org.aspectj.lang.annotation.DeclareParents").findDeclaredAttributeValue("defaultImpl");
                    int offset = value.getTextRange().getStartOffset();
                    value.delete();
                    new OpenFileDescriptor(project, virtualFile, offset).navigate(true);
                }

                @Override
                @NonNls
                public String getDefaultImplAttributeName() {
                    return "defaultImpl";
                }

                @Override
                @NotNull
                public PsiElement getInterfaceElement() {
                    PsiTypeElement psiTypeElement = myField.getTypeElement();
                    if (psiTypeElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopLanguageInjector$JavaIntroLocalAopModel$1", "getInterfaceElement"));
                    }
                    return psiTypeElement;
                }

                @Override
                @Nullable
                public PsiElement getDefaultImplElement() {
                    return myAnnotation.findDeclaredAttributeValue("defaultImpl");
                }
            };
        }
    }
}

