/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.gwt.facet.DefaultGwtFacetSettingsEditor;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.MultipleGwtFacetSettingsEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.indexing.FileContent;
import icons.GwtStudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtFacetType
extends FacetType<GwtFacet, GwtFacetConfiguration> {
    public static final FacetTypeId<GwtFacet> ID = new FacetTypeId("gwt");

    GwtFacetType() {
        super(ID, "gwt", "GWT");
    }

    public static GwtFacetType getInstance() {
        return (GwtFacetType)FacetType.findInstance(GwtFacetType.class);
    }

    public GwtFacetConfiguration createDefaultConfiguration() {
        return new GwtFacetConfiguration();
    }

    public GwtFacet createFacet(@NotNull Module module, String name, @NotNull GwtFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/facet/GwtFacetType", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gwt/facet/GwtFacetType", "createFacet"));
        }
        return new GwtFacet(this, module, name, configuration);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    public String getHelpTopic() {
        return "IntelliJ.IDEA.Procedures.Java.EE.Development.Managing.Facets.Facet.Specific.Settings.GWT";
    }

    public Icon getIcon() {
        return GwtStudioIcons.Google_small;
    }

    public DefaultFacetSettingsEditor createDefaultConfigurationEditor(@NotNull Project project, @NotNull GwtFacetConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/facet/GwtFacetType", "createDefaultConfigurationEditor"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gwt/facet/GwtFacetType", "createDefaultConfigurationEditor"));
        }
        return new DefaultGwtFacetSettingsEditor(project, configuration);
    }

    public MultipleFacetSettingsEditor createMultipleConfigurationsEditor(@NotNull Project project, @NotNull FacetEditor[] editors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/facet/GwtFacetType", "createMultipleConfigurationsEditor"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/gwt/facet/GwtFacetType", "createMultipleConfigurationsEditor"));
        }
        return new MultipleGwtFacetSettingsEditor(project, editors);
    }

    public static class GwtFrameworkDetector
    extends FacetBasedFrameworkDetector<GwtFacet, GwtFacetConfiguration> {
        public GwtFrameworkDetector() {
            super("gwt-detector");
        }

        @NotNull
        public FacetType<GwtFacet, GwtFacetConfiguration> getFacetType() {
            GwtFacetType gwtFacetType = GwtFacetType.getInstance();
            if (gwtFacetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetType$GwtFrameworkDetector", "getFacetType"));
            }
            return gwtFacetType;
        }

        @NotNull
        public FileType getFileType() {
            LanguageFileType languageFileType = StdFileTypes.XML;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetType$GwtFrameworkDetector", "getFileType"));
            }
            return languageFileType;
        }

        @NotNull
        public ElementPattern<FileContent> createSuitableFilePattern() {
            FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName(StandardPatterns.string().endsWith(".gwt.xml"));
            if (fileContentPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetType$GwtFrameworkDetector", "createSuitableFilePattern"));
            }
            return fileContentPattern;
        }

        public void setupFacet(@NotNull GwtFacet facet, ModifiableRootModel model) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/facet/GwtFacetType$GwtFrameworkDetector", "setupFacet"));
            }
            GwtFacetConfiguration configuration = (GwtFacetConfiguration)facet.getConfiguration();
            GwtFacet.setupGwtSdkAndLibraries(configuration, model, configuration.getSdk());
        }
    }
}

