/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.gwt.run.HostedModeWarDirectoryCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HostedModeWarDirectoryGenerator {
    private static final boolean CLEAN_FILES_CREATED_BY_DEV_MODE = Boolean.parseBoolean(System.getProperty("idea.gwt.clean.files.created.by.dev.mode", "true"));
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.run.HostedModeWarDirectoryGenerator");
    private final File myOutputRoot;
    private final File myCacheFile;
    private final List<Couple<File>> myFilesToCopy = new ArrayList<Couple<File>>();

    public HostedModeWarDirectoryGenerator(File outputRoot, File cacheFile) {
        this.myOutputRoot = HostedModeWarDirectoryGenerator.getCanonicalFile(outputRoot);
        this.myCacheFile = cacheFile;
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return file;
        }
    }

    public void addFile(VirtualFile file, String relativePath) {
        File root = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        if (root.exists()) {
            String normalizedPath = StringUtil.trimStart((String)FileUtil.toSystemDependentName((String)relativePath), (String)File.separator);
            this.addFile(root, normalizedPath, this.myOutputRoot.getAbsolutePath());
        }
    }

    private void addFile(File file, String relativePath, String outputRoot) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                this.addFile(child, relativePath.isEmpty() ? child.getName() : relativePath + File.separator + child.getName(), outputRoot);
            }
        } else {
            File target = new File(outputRoot, relativePath);
            this.myFilesToCopy.add((Couple<File>)Couple.of((Object)file, (Object)target));
        }
    }

    public void generate(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/HostedModeWarDirectoryGenerator", "generate"));
        }
        new Task.Modal(project, "Preparing WAR Directory for GWT Dev Mode", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/gwt/run/HostedModeWarDirectoryGenerator$1", "run"));
                }
                HostedModeWarDirectoryGenerator.this.doGenerate(indicator, CLEAN_FILES_CREATED_BY_DEV_MODE);
            }
        }.queue();
    }

    private boolean doGenerate(@NotNull ProgressIndicator indicator, boolean cleanFilesGeneratedByDevModeProcess) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/gwt/run/HostedModeWarDirectoryGenerator", "doGenerate"));
        }
        HostedModeWarDirectoryCache cache = new HostedModeWarDirectoryCache(this.myCacheFile);
        cache.load();
        boolean updated = false;
        try {
            THashSet toDelete = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            indicator.setText("Processing files...");
            if (cleanFilesGeneratedByDevModeProcess) {
                THashSet targetFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                for (Couple<File> pair : this.myFilesToCopy) {
                    targetFiles.add(pair.getSecond());
                }
                FileUtil.processFilesRecursively((File)this.myOutputRoot, arg_0 -> HostedModeWarDirectoryGenerator.lambda$doGenerate$0((Set)targetFiles, (Set)toDelete, arg_0));
            } else {
                toDelete.addAll(cache.getTargetPaths());
                int i = 0;
                for (Couple<File> pair : this.myFilesToCopy) {
                    indicator.setFraction((double)i++ / (double)this.myFilesToCopy.size());
                    indicator.checkCanceled();
                    File source = (File)pair.getFirst();
                    String targetPath = cache.getTargetPath(source.getPath());
                    if (targetPath == null || !source.exists()) continue;
                    toDelete.remove(targetPath);
                }
            }
            int i = 0;
            indicator.setText("Deleting obsolete files...");
            for (String targetPath : toDelete) {
                indicator.setFraction((double)i++ / (double)toDelete.size());
                indicator.checkCanceled();
                LOG.debug("Deleting " + targetPath);
                updated = true;
                FileUtil.delete((File)new File(targetPath));
            }
            HashSet<String> removeFromCache = new HashSet<String>(cache.getSourcePaths());
            THashSet targetPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            i = 0;
            indicator.setText("Copying files...");
            for (Couple<File> pair : this.myFilesToCopy) {
                long actualTimestamp;
                indicator.setFraction((double)i++ / (double)this.myFilesToCopy.size());
                indicator.checkCanceled();
                File source = (File)pair.getFirst();
                File target = (File)pair.getSecond();
                if (!source.exists() || !targetPaths.add(target.getAbsolutePath())) continue;
                String sourcePath = source.getPath();
                String targetPath = target.getAbsolutePath();
                long timestamp = cache.getTimestamp(sourcePath);
                if (timestamp != (actualTimestamp = source.lastModified()) || !targetPath.equals(cache.getTargetPath(sourcePath)) || !target.exists()) {
                    FileUtil.copy((File)source, (File)target);
                    updated = true;
                    LOG.debug("Copying " + sourcePath + " to " + targetPath);
                    cache.updateTimestamp(sourcePath, actualTimestamp, targetPath);
                }
                removeFromCache.remove(sourcePath);
            }
            cache.remove(removeFromCache);
            cache.save();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return updated;
    }

    public void updateResources(final Project project, final @Nullable String configurationName) {
        FileDocumentManager.getInstance().saveAllDocuments();
        new Task.Backgroundable(project, "Updating GWT Dev Mode Resources", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/gwt/run/HostedModeWarDirectoryGenerator$2", "run"));
                }
                boolean updated = HostedModeWarDirectoryGenerator.this.doGenerate(indicator, false);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String time = DateFormatUtil.formatTime((long)Clock.getTime());
                    StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                    if (statusBar != null && configurationName != null) {
                        statusBar.setInfo("GWT Dev Mode resources for '" + configurationName + "' " + (updated ? "updated at " + time : "are up-to-date"));
                    }
                });
            }
        }.queue();
    }

    private static /* synthetic */ boolean lambda$doGenerate$0(Set targetFiles, Set toDelete, File file) {
        if (file.isFile() && !targetFiles.contains(file)) {
            toDelete.add(file.getAbsolutePath());
        }
        return true;
    }
}

