/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.ws.WSBundle;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.BaseWebServicesInspection;
import com.intellij.ws.inspections.InsertAnnotationFix;
import com.intellij.ws.inspections.MarkWebServiceMembersBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonJaxWsWebServicesInspection
extends MarkWebServiceMembersBase {
    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/NonJaxWsWebServicesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkMember(ProblemsHolder problemsHolder, PsiMember psiMember) {
    }

    @Override
    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
        BaseWebServicesInspection.ExternallyBoundClassContext context = NonJaxWsWebServicesInspection.getClassContext(c);
        WSIndexEntry[] entries = context.getEntries(ModuleUtil.findModuleForPsiElement((PsiElement)c));
        if (entries.length == 0 || entries[0] == null) {
            return;
        }
        if (context.annotation == null && "Web service".equals(entries[0].getWsStatus((PsiMember)c))) {
            problemsHolder.registerProblem(NonJaxWsWebServicesInspection.findNameIdentifier((PsiMember)c), WSBundle.message("webservices.inspections.nonjaxwswebservices.inspectionwebservice.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AnnotateAsWebServiceFix()});
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = WSBundle.message("webservices.inspections.nonjaxwswebservices.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/NonJaxWsWebServicesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String string = WSBundle.message("webservices.inspections.nonjaxwswebservices.inspection.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/NonJaxWsWebServicesInspection", "getShortName"));
        }
        return string;
    }

    static class AnnotateAsWebServiceFix
    extends InsertAnnotationFix
    implements LocalQuickFix {
        public AnnotateAsWebServiceFix() {
            super("@javax.jws.WebService");
        }

        @NotNull
        public String getName() {
            String string = WSBundle.message("webservices.inspections.nonjaxwswebservices.inspection.annotate.web.service.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/NonJaxWsWebServicesInspection$AnnotateAsWebServiceFix", "getName"));
            }
            return string;
        }
    }
}

