/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ArrayUtil;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.facet.client.WebServicesClientLibraries;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibUtils {
    private LibUtils() {
    }

    public static String[] getLibUrlsForToolRunning(ExternalEngine engine, Module module) {
        if (WebServicesClientLibraries.isSupported(engine.getName())) {
            LibraryInfo[] info = WebServicesClientLibraries.getRequiredLibraries(engine.getName());
            THashSet libs = new THashSet();
            for (LibraryInfo lib : info) {
                String[] libraries;
                String[] classes = lib.getRequiredClasses();
                if (classes.length == 0) continue;
                for (String library : libraries = LibUtils.getLibUrlsForToolRunning(classes[0], module.getProject())) {
                    libs.add(library);
                }
            }
            if (CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath() != null) {
                libs.add(CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath().getPath());
            }
            return ArrayUtil.toStringArray((Collection)libs);
        }
        return LibUtils.getLibsUrlsFromLibInfos(engine.getLibraryDescriptors(null, false), engine.getBasePath());
    }

    public static String[] getLibUrlsForToolRunning(String fqn, Project project) {
        Library lib = LibraryUtil.findLibraryByClass((String)fqn, (Project)project);
        if (lib == null) {
            VirtualFile[] roots = LibraryUtil.getLibraryRoots((Project)project);
            VirtualFile[] files = new VirtualFile[1];
            VirtualFile[] virtualFileArray = roots;
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile root;
                files[0] = root = virtualFileArray[i];
                if (!LibraryUtil.isClassAvailableInLibrary((VirtualFile[])files, (String)fqn)) continue;
                return new String[]{files[0].getPresentableUrl()};
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        VirtualFile[] files = lib.getFiles(OrderRootType.CLASSES);
        String[] jars = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            jars[i] = files[i].getPresentableUrl();
        }
        return jars;
    }

    public static void setupLibsForGeneratedCode(Module module, ExternalEngine engine, String bindingType) {
        String libPath = LibUtils.detectLibPath(engine);
        if (libPath != null) {
            LibUtils.setupLibraries(module, LibUtils.getGeneratedCodeLibInfos(engine, bindingType, module), libPath, false);
        }
    }

    public static LibraryDescriptor[] getGeneratedCodeLibInfos(ExternalEngine engine, String bindingType, Module module) {
        return engine.getLibraryDescriptors(bindingType, true);
    }

    static void addRequiredLibraryIfNeeded(LibraryTable libraryTable, LibraryDescriptor info, String libPath, ModifiableRootModel rootModel) {
        String name = info.getName();
        Library library = null;
        if (name != null) {
            library = libraryTable.getLibraryByName(name);
        } else {
            Iterator libraryIterator = libraryTable.getLibraryIterator();
            String firstJarName = info.getLibJars()[0];
            block0: while (libraryIterator.hasNext()) {
                Library lib = (Library)libraryIterator.next();
                if (lib.getName() != null) continue;
                for (VirtualFile f : lib.getFiles(OrderRootType.CLASSES)) {
                    if (!firstJarName.equals(f.getPresentableName())) continue;
                    library = lib;
                    break block0;
                }
            }
        }
        if (library == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Library library2 = name != null ? libraryTable.createLibrary(name) : libraryTable.createLibrary();
                Library.ModifiableModel model = library2.getModifiableModel();
                for (String jar : info.getLibJars()) {
                    LibUtils.addOneJar(jar, model, libPath);
                }
                model.commit();
                if ("project".equals(libraryTable.getTableLevel())) {
                    LibraryOrderEntry orderEntry = rootModel.addLibraryEntry(library2);
                    LibUtils.rearrageEntries(rootModel, orderEntry);
                }
            });
        } else if (LibUtils.noReferenceToLibrary(rootModel, library)) {
            Library library1 = library;
            ApplicationManager.getApplication().runWriteAction(() -> {
                LibraryOrderEntry orderEntry = rootModel.addLibraryEntry(library1);
                LibUtils.rearrageEntries(rootModel, orderEntry);
            });
        }
    }

    private static void rearrageEntries(ModifiableRootModel rootModel, LibraryOrderEntry orderEntry) {
        OrderEntry[] orderEntries = rootModel.getOrderEntries();
        OrderEntry[] newOrderEntries = new OrderEntry[orderEntries.length];
        newOrderEntries[0] = orderEntry;
        int index = 1;
        for (int i = 0; i < orderEntries.length; ++i) {
            if (orderEntries[i] == orderEntry) continue;
            newOrderEntries[index++] = orderEntries[i];
        }
        rootModel.rearrangeOrderEntries(newOrderEntries);
    }

    private static boolean noReferenceToLibrary(ModifiableRootModel rootModel, Library library) {
        LibraryOrderEntry libraryOrderEntry = rootModel.findLibraryOrderEntry(library);
        if (libraryOrderEntry != null) {
            return false;
        }
        for (OrderEntry o : rootModel.getOrderEntries()) {
            LibraryOrderEntry orderEntry;
            String name;
            if (!(o instanceof LibraryOrderEntry) || (name = (orderEntry = (LibraryOrderEntry)o).getLibraryName()) == null || !name.equals(library.getName())) continue;
            return false;
        }
        return true;
    }

    private static void addOneJar(String jarFileName, Library.ModifiableModel model, String libPath) {
        File file = new File((libPath + jarFileName).replace('\\', '/'));
        VirtualFile fileByIoFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (fileByIoFile == null) {
            fileByIoFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        }
        if (fileByIoFile != null) {
            VirtualFile fileByPath = JarFileSystem.getInstance().findFileByPath(fileByIoFile.getPath() + "!/");
            model.addRoot(fileByPath, OrderRootType.CLASSES);
        }
    }

    static String detectLibPath(@NotNull ExternalEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ws/utils/LibUtils", "detectLibPath"));
        }
        String s = engine.getBasePath();
        if (s == null) {
            return null;
        }
        if (!new File(s).exists()) {
            throw new RuntimeException("Required libs are missed");
        }
        return s + File.separatorChar;
    }

    public static String[] getLibsUrlsFromLibInfos(LibraryDescriptor[] libInfos, String basePath) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < libInfos.length; ++i) {
            for (String s : libInfos[i].getLibJars()) {
                result.add(basePath + File.separator + s);
            }
        }
        return ArrayUtil.toStringArray(result);
    }

    public static void setupLibraries(Module currentModule, LibraryDescriptor[] libInfos, String libPath, boolean moduleLibrary) {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)currentModule).getModifiableModel();
        LibraryTable libraryTable = moduleLibrary ? modifiableModel.getModuleLibraryTable() : LibraryTablesRegistrar.getInstance().getLibraryTable(currentModule.getProject());
        for (int i = 0; i < libInfos.length; ++i) {
            LibUtils.addRequiredLibraryIfNeeded(libraryTable, libInfos[i], libPath, modifiableModel);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                modifiableModel.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static XmlTag findServletWithName(XmlTag[] tags, @NotNull String axisServletName, @Nullable String deploymentServletClass) {
        if (axisServletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "axisServletName", "com/intellij/ws/utils/LibUtils", "findServletWithName"));
        }
        for (XmlTag tag : tags) {
            XmlTag name;
            String stringValue;
            XmlTag[] subTags = tag.findSubTags("servlet-name");
            if (subTags.length == 0 || !(stringValue = LibUtils.getStringValue(name = subTags[0])).equals(axisServletName)) continue;
            return tag;
        }
        return deploymentServletClass != null ? LibUtils.findServletByClass(tags, deploymentServletClass) : null;
    }

    public static XmlTag findServletByClass(XmlTag[] tags, @NotNull String servletClassName) {
        if (servletClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servletClassName", "com/intellij/ws/utils/LibUtils", "findServletByClass"));
        }
        for (XmlTag tag : tags) {
            XmlTag name;
            String stringValue;
            XmlTag[] subTags = tag.findSubTags("servlet-class");
            if (subTags.length == 0 || !(stringValue = LibUtils.getStringValue(name = subTags[0])).equals(servletClassName)) continue;
            return tag;
        }
        return null;
    }

    public static String getStringValue(XmlTag name) {
        String stringValue = "";
        XmlTagValue value = name.getValue();
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof XmlTagValue) {
            stringValue = value.getTrimmedText();
        }
        return stringValue.trim();
    }

    @Nullable
    public static Module findModuleByOutputPath(Project project, String output) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        Module currentModule = null;
        block0: for (Module module : modules) {
            VirtualFile[] files;
            for (VirtualFile file : files = OrderEnumerator.orderEntries((Module)module).getAllSourceRoots()) {
                if (!file.getPresentableUrl().equals(output)) continue;
                currentModule = module;
                break block0;
            }
        }
        return currentModule;
    }

    public static File saveSourceGeneratedFile(String wsdlUrl, String outputPath, @Nullable String packagePrefix) throws IOException {
        int i;
        URL url = new URL(wsdlUrl);
        InputStream stream = url.openStream();
        int i2 = wsdlUrl.indexOf(63, i = wsdlUrl.lastIndexOf(47));
        String fileName = wsdlUrl.substring(i, i2 != -1 ? i2 : wsdlUrl.length());
        if (i2 != -1 && !fileName.endsWith(".wsdl") && fileName.indexOf(46) == -1) {
            fileName = fileName + ".wsdl";
        }
        String s = outputPath + (packagePrefix != null ? "/" + packagePrefix.replace('.', File.separatorChar) : "");
        File f = new File(s);
        f.mkdirs();
        String fullFileName = s + fileName;
        File file = LibUtils.isSameFile(url, fullFileName) ? new File(fullFileName) : FileUtils.saveStreamContentAsFile((String)fullFileName, (InputStream)stream);
        CommonWsUtils.scanFile((File)file, (CommonWsUtils.FileProcessor)new CommonWsUtils.FileProcessor(){
            final Pattern p = Pattern.compile("(?:(?:location|schemaLocation)\\s*=\\s*(\"|'))([^\"']*)\\1");

            public void fileScanningEnded() throws IOException {
            }

            public boolean process(String s) throws IOException {
                if (s.indexOf("location") != -1 || s.indexOf("schemaLocation") != -1) {
                    Matcher matcher = this.p.matcher(s);
                    StringBuffer result = new StringBuffer();
                    while (matcher.find()) {
                    }
                    matcher.appendTail(result);
                }
                return true;
            }
        });
        return file;
    }

    private static boolean isSameFile(URL url, String fullFileName) {
        try {
            return new File(fullFileName).equals(new File(url.toURI()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String findOutputDir(Module module) {
        VirtualFile[] files = OrderEnumerator.orderEntries((Module)module).getAllSourceRoots();
        String generateSourcesDir = null;
        for (VirtualFile file : files) {
            if (file.getExtension() != null || !file.isWritable()) continue;
            generateSourcesDir = file.getPresentableUrl();
            break;
        }
        return generateSourcesDir;
    }

    public static String retrieveTargetNamespace(File savedWsdlFile) throws InvokeExternalCodeUtil.ExternalCodeException {
        final String[] detectedNsFromWsdl = new String[1];
        try {
            CommonWsUtils.scanFile((File)savedWsdlFile, (CommonWsUtils.FileProcessor)new CommonWsUtils.FileProcessor(){
                final Pattern p = Pattern.compile("(?:(?:namespace|targetNamespace)\\s*=\\s*(\"|'))([^\"']*)\\1");

                public void fileScanningEnded() throws IOException {
                }

                public boolean process(String s) throws IOException {
                    Matcher matcher;
                    if ((s.indexOf("namespace=\"") != -1 || s.indexOf("targetNamespace=\"") != -1) && (matcher = this.p.matcher(s)).find() && detectedNsFromWsdl[0] == null) {
                        detectedNsFromWsdl[0] = matcher.group(2);
                    }
                    return true;
                }
            });
        }
        catch (IOException e) {
            throw new InvokeExternalCodeUtil.ExternalCodeException(e);
        }
        return detectedNsFromWsdl[0];
    }

    public static boolean accessingLibraryJarsFromPluginBundledLibs(String basePath) {
        return !new File(basePath + File.separatorChar + "lib").exists();
    }

    public static InputStream getResourcesStream(String templateName) {
        return LibUtils.class.getResourceAsStream("/schemas/resources/" + templateName);
    }
}

