/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001aR\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u0001H\u0007\u001aD\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 \u001a\f\u0010!\u001a\u0004\u0018\u00010\u0016*\u00020\u0002\u001a\f\u0010\"\u001a\u0004\u0018\u00010#*\u00020$\u001a\f\u0010\"\u001a\u0004\u0018\u00010#*\u00020 \u001a\f\u0010%\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\n\u0010&\u001a\u00020\u0002*\u00020\u0002\u001a\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014*\u00020\u0002\u001a \u0010(\u001a\u00020\u0001*\u00020\u00022\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010*H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0003\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0003\u00a8\u0006+"}, d2={"isBuiltinExtensionFunctionalType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isBuiltinFunctionalType", "isBuiltinFunctionalTypeOrSubtype", "isExtensionFunctionType", "isFunctionType", "isFunctionTypeOrSubtype", "isNonExtensionFunctionType", "isSuspendFunctionType", "isTypeAnnotatedWithExtensionFunctionType", "createFunctionType", "Lorg/jetbrains/kotlin/types/SimpleType;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "receiverType", "parameterTypes", "", "parameterNames", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "suspendFunction", "getFunctionTypeArgumentProjections", "Lorg/jetbrains/kotlin/types/TypeProjection;", "isBuiltinFunctionClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNumberedFunctionClassFqName", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "extractParameterNameFromFunctionTypeArgument", "getFunctionalClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getReceiverTypeFromFunctionType", "getReturnTypeFromFunctionType", "getValueParameterTypesFromFunctionType", "isTypeOrSubtypeOf", "predicate", "Lkotlin/Function1;", "descriptors"})
public final class FunctionTypesKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTypeOrSubtypeOf(@NotNull KotlinType $receiver, Function1<? super KotlinType, Boolean> predicate) {
        if ((Boolean)predicate.invoke((Object)$receiver) != false) return true;
        Object r = DFS.dfsFromNode($receiver, isTypeOrSubtypeOf.1.INSTANCE, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(predicate){
            private boolean result;
            final /* synthetic */ Function1 $predicate;

            public boolean beforeChildren(@NotNull KotlinType current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (((Boolean)this.$predicate.invoke((Object)current)).booleanValue()) {
                    this.result = true;
                }
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
            {
                this.$predicate = $captured_local_variable$0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(r, (String)"DFS.dfsFromNode(\n       \u2026              }\n        )");
        if ((Boolean)r == false) return false;
        return true;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isTypeOrSubtypeOf($receiver, (Function1<? super KotlinType, Boolean>)((Function1)isFunctionTypeOrSubtype.1.INSTANCE));
    }

    public static final boolean isBuiltinFunctionalTypeOrSubtype(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isTypeOrSubtypeOf($receiver, (Function1<? super KotlinType, Boolean>)((Function1)isBuiltinFunctionalTypeOrSubtype.1.INSTANCE));
    }

    public static final boolean isFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)((Object)(classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null)), (Object)((Object)FunctionClassDescriptor.Kind.Function));
    }

    public static final boolean isSuspendFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)((Object)(classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null)), (Object)((Object)FunctionClassDescriptor.Kind.SuspendFunction));
    }

    public static final boolean isBuiltinFunctionalType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        FunctionClassDescriptor.Kind kind2 = classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
        return Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)FunctionClassDescriptor.Kind.Function)) || Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)FunctionClassDescriptor.Kind.SuspendFunction));
    }

    public static final boolean isBuiltinFunctionClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FunctionClassDescriptor.Kind kind2 = FunctionTypesKt.getFunctionalClassKind(classId.asSingleFqName().toUnsafe());
        return Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)FunctionClassDescriptor.Kind.Function)) || Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)FunctionClassDescriptor.Kind.SuspendFunction));
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    public static final boolean isBuiltinExtensionFunctionalType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isBuiltinFunctionalType($receiver) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        String shortName;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        if (!fqName2.startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return false;
        }
        List<Name> segments = fqName2.pathSegments();
        if (segments.size() != 2) {
            return false;
        }
        String string = shortName = ((Name)kotlin.collections.CollectionsKt.last(segments)).asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"shortName");
        FqName fqName3 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return BuiltInFictitiousFunctionClassFactory.Companion.isFunctionClassName(string, fqName3);
    }

    @Nullable
    public static final FunctionClassDescriptor.Kind getFunctionalClassKind(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof ClassDescriptor)) {
            return null;
        }
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe($receiver);
        return FunctionTypesKt.getFunctionalClassKind(fqNameUnsafe);
    }

    @Nullable
    public static final FunctionClassDescriptor.Kind getFunctionalClassKind(@NotNull FqNameUnsafe $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.isSafe() || $receiver.isRoot()) {
            return null;
        }
        FqName fqName2 = $receiver.toSafe();
        String string = fqName2.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.shortName().asString()");
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName.parent()");
        return BuiltInFictitiousFunctionClassFactory.Companion.getFunctionalClassKind(string, fqName3);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver) ? ((TypeProjection)kotlin.collections.CollectionsKt.first($receiver.getArguments())).getType() : null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = ((TypeProjection)kotlin.collections.CollectionsKt.last($receiver.getArguments())).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType($receiver);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TypeProjection> arguments2 = $receiver.getArguments();
        int first = FunctionTypesKt.isBuiltinExtensionFunctionalType($receiver) ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl3 = bl = first <= last;
        if (_Assertions.ENABLED && !bl) {
            String string = "Not an exact function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return arguments2.subList(first, last);
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.parameterName");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        Object object2 = kotlin.collections.CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
        if (!(object2 instanceof StringValue)) {
            object2 = null;
        }
        if ((object = (StringValue)object2) == null || (object = (String)((ConstantValue)object).getValue()) == null || (object = (String)AddToStdlibKt.check(object, extractParameterNameFromFunctionTypeArgument.name.1.INSTANCE)) == null) {
            return null;
        }
        Object name2 = object;
        return Name.identifier((String)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType2, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkParameterIsNotNull((Object)returnType2, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + (receiverType2 != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType2;
        CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable $receiver$iv = parameterTypes;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            KotlinType kotlinType2;
            void type2;
            Name name2;
            void index2;
            int n = index$iv++;
            KotlinType kotlinType3 = (KotlinType)item$iv;
            int n2 = n;
            Collection collection = arguments2;
            List<Name> list2 = parameterNames;
            Name name3 = list2 != null && (list2 = list2.get((int)index2)) != null ? (Name)AddToStdlibKt.check(list2, getFunctionTypeArgumentProjections.1.name.1.INSTANCE) : (name2 = null);
            if (name2 != null) {
                ClassDescriptor annotationClass = builtIns.getBuiltInClassByName(KotlinBuiltIns.FQ_NAMES.parameterName.shortName());
                ConstantValueFactory constantValueFactory = new ConstantValueFactory(builtIns);
                String string = name2.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
                StringValue nameValue = constantValueFactory.createStringValue(string);
                KotlinType kotlinType4 = annotationClass.getDefaultType();
                ClassConstructorDescriptor classConstructorDescriptor = annotationClass.getUnsubstitutedPrimaryConstructor();
                if (classConstructorDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                AnnotationDescriptorImpl parameterNameAnnotation = new AnnotationDescriptorImpl(kotlinType4, MapsKt.mapOf((Pair)TuplesKt.to((Object)kotlin.collections.CollectionsKt.single(classConstructorDescriptor.getValueParameters()), (Object)nameValue)), SourceElement.NO_SOURCE);
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, new AnnotationsImpl(kotlin.collections.CollectionsKt.plus((Iterable)type2.getAnnotations(), (Object)parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection((KotlinType)typeToUse);
            collection.add(typeProjection);
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType2));
        return arguments2;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, boolean suspendFunction) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
        arguments = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, parameterTypes, parameterNames, returnType, builtIns);
        size = parameterTypes.size();
        parameterCount = receiverType == null ? size : size + 1;
        v0 = classDescriptor = suspendFunction != false ? builtIns.getSuspendFunction(parameterCount) : builtIns.getFunction(parameterCount);
        if (receiverType == null) ** GOTO lbl-1000
        v1 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        if (annotations.findAnnotation(v1) != null) lbl-1000:
        // 2 sources

        {
            v2 = annotations;
        } else {
            extensionFunctionAnnotation = new AnnotationDescriptorImpl(builtIns.getBuiltInClassByName(KotlinBuiltIns.FQ_NAMES.extensionFunctionType.shortName()).getDefaultType(), MapsKt.emptyMap(), SourceElement.NO_SOURCE);
            v2 = new AnnotationsImpl(kotlin.collections.CollectionsKt.plus((Iterable)annotations, (Object)extensionFunctionAnnotation));
        }
        typeAnnotations = v2;
        v3 = classDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"classDescriptor");
        return KotlinTypeFactory.simpleNotNullType(typeAnnotations, v3, arguments);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list2, List list3, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list2, list3, kotlinType2, bl);
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType2, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2) {
        return FunctionTypesKt.createFunctionType$default(builtIns, annotations2, receiverType2, parameterTypes, parameterNames, returnType2, false, 64, null);
    }
}

