/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.io.File;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.CompiledReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.EvalClassWithInstanceAndLoader;
import org.jetbrains.kotlin.cli.common.repl.Evaluable;
import org.jetbrains.kotlin.cli.common.repl.GenericReplEvaluator;
import org.jetbrains.kotlin.cli.common.repl.InvokeWrapper;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ReplFullEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ReplRepeatingMode;
import org.jetbrains.kotlin.cli.common.repl.ScriptArgsWithTypes;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001?BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0012H\u0016J4\u0010.\u001a\u00020/2\u0006\u0010-\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u00010\n2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\u00102\u001a\u0004\u0018\u000103H\u0016J8\u00104\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0006\u0012\u0004\u0018\u0001060$2\u0006\u0010-\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\n2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J$\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:2\b\u00100\u001a\u0004\u0018\u00010\n2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010<\u001a\u00020=H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010>\u001a\u00020\u0012H\u0016R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R*\u0010#\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$j\u0002`'0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompilingEvaluator;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplFullEvaluator;", "compiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "baseClasspath", "", "Ljava/io/File;", "baseClassloader", "Ljava/lang/ClassLoader;", "fallbackScriptArgs", "Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;", "repeatingMode", "Lorg/jetbrains/kotlin/cli/common/repl/ReplRepeatingMode;", "stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;Ljava/lang/Iterable;Ljava/lang/ClassLoader;Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;Lorg/jetbrains/kotlin/cli/common/repl/ReplRepeatingMode;Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "compiledHistory", "", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "getCompiledHistory", "()Ljava/util/List;", "getCompiler", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "currentClasspath", "getCurrentClasspath", "evaluatedHistory", "getEvaluatedHistory", "evaluator", "Lorg/jetbrains/kotlin/cli/common/repl/GenericReplEvaluator;", "getEvaluator", "()Lorg/jetbrains/kotlin/cli/common/repl/GenericReplEvaluator;", "getFallbackScriptArgs", "()Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;", "history", "getHistory", "lastEvaluatedScripts", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/common/repl/CompiledReplCodeLine;", "Lorg/jetbrains/kotlin/cli/common/repl/EvalClassWithInstanceAndLoader;", "Lorg/jetbrains/kotlin/cli/common/repl/EvalHistoryType;", "getLastEvaluatedScripts", "getStateLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "compileAndEval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "scriptArgs", "verifyHistory", "invokeWrapper", "Lorg/jetbrains/kotlin/cli/common/repl/InvokeWrapper;", "compileToEvaluable", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "Lorg/jetbrains/kotlin/cli/common/repl/Evaluable;", "defaultScriptArgs", "eval", "compileResult", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "resetToLine", "lineNumber", "", "line", "DelayedEvaluation", "cli-common"})
public final class GenericReplCompilingEvaluator
implements ReplFullEvaluator {
    @NotNull
    private final GenericReplEvaluator evaluator;
    @NotNull
    private final ReplCompiler compiler;
    @Nullable
    private final ScriptArgsWithTypes fallbackScriptArgs;
    @NotNull
    private final ReentrantReadWriteLock stateLock;

    @NotNull
    public final GenericReplEvaluator getEvaluator() {
        return this.evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ReplEvalResult compileAndEval(@NotNull ReplCodeLine codeLine, @Nullable ScriptArgsWithTypes scriptArgs, @Nullable List<ReplCodeLine> verifyHistory, @Nullable InvokeWrapper invokeWrapper) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            ReplEvalResult replEvalResult;
            ReplCompileResult compiled;
            ReplCompileResult replCompileResult = compiled = this.compiler.compile(codeLine, verifyHistory);
            if (replCompileResult instanceof ReplCompileResult.Error) {
                replEvalResult = new ReplEvalResult.Error.CompileTime(compiled.getCompiledHistory(), ((ReplCompileResult.Error)compiled).getMessage(), ((ReplCompileResult.Error)compiled).getLocation());
            } else if (replCompileResult instanceof ReplCompileResult.HistoryMismatch) {
                replEvalResult = new ReplEvalResult.HistoryMismatch(compiled.getCompiledHistory(), ((ReplCompileResult.HistoryMismatch)compiled).getLineNo());
            } else if (replCompileResult instanceof ReplCompileResult.Incomplete) {
                replEvalResult = new ReplEvalResult.Incomplete(compiled.getCompiledHistory());
            } else {
                if (!(replCompileResult instanceof ReplCompileResult.CompiledClasses)) throw (Throwable)new IllegalStateException("Unknown compiler result type " + compiled);
                ReplEvalResult result2 = this.eval((ReplCompileResult.CompiledClasses)compiled, scriptArgs, invokeWrapper);
                ReplEvalResult replEvalResult2 = result2;
                if (replEvalResult2 instanceof ReplEvalResult.Error || replEvalResult2 instanceof ReplEvalResult.HistoryMismatch || replEvalResult2 instanceof ReplEvalResult.Incomplete) {
                    ReplCodeLine replCodeLine = (ReplCodeLine)CollectionsKt.lastOrNull(result2.getCompletedEvalHistory());
                    if (replCodeLine != null) {
                        ReplCodeLine replCodeLine2;
                        ReplCodeLine it = replCodeLine2 = replCodeLine;
                        this.compiler.resetToLine(it);
                    }
                    replEvalResult = result2;
                } else {
                    if (!(replEvalResult2 instanceof ReplEvalResult.ValueResult) && !(replEvalResult2 instanceof ReplEvalResult.UnitResult)) throw (Throwable)new IllegalStateException("Unknown evaluator result type " + compiled);
                    replEvalResult = result2;
                }
            }
            ReplEvalResult replEvalResult3 = replEvalResult;
            return replEvalResult3;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ReplCodeLine> resetToLine(int lineNumber) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            List<ReplCodeLine> removedCompiledLines = this.compiler.resetToLine(lineNumber);
            List<ReplCodeLine> removedEvaluatorLines = this.evaluator.resetToLine(lineNumber);
            Iterable $receiver$iv = CollectionsKt.zip((Iterable)removedCompiledLines, (Iterable)removedEvaluatorLines);
            for (Object element$iv : $receiver$iv) {
                Pair it = (Pair)element$iv;
                if (!(Intrinsics.areEqual((Object)((ReplCodeLine)it.getFirst()), (Object)((ReplCodeLine)it.getSecond())) ^ true)) continue;
                throw (Throwable)new IllegalStateException("History mismatch when resetting lines");
            }
            List<ReplCodeLine> list2 = removedCompiledLines;
            return list2;
        }
        finally {
            n = 0;
            int n5 = n3 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public List<ReplCodeLine> resetToLine(@NotNull ReplCodeLine line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        return this.resetToLine(line.getNo());
    }

    @Override
    @NotNull
    public List<Pair<CompiledReplCodeLine, EvalClassWithInstanceAndLoader>> getLastEvaluatedScripts() {
        return this.evaluator.getLastEvaluatedScripts();
    }

    @Override
    @NotNull
    public List<ReplCodeLine> getHistory() {
        return this.evaluator.getHistory();
    }

    @Override
    @NotNull
    public List<File> getCurrentClasspath() {
        return this.evaluator.getCurrentClasspath();
    }

    @Override
    @NotNull
    public List<ReplCodeLine> getCompiledHistory() {
        return this.compiler.getHistory();
    }

    @Override
    @NotNull
    public List<ReplCodeLine> getEvaluatedHistory() {
        return this.evaluator.getHistory();
    }

    @Override
    @NotNull
    public ReplEvalResult eval(@NotNull ReplCompileResult.CompiledClasses compileResult, @Nullable ScriptArgsWithTypes scriptArgs, @Nullable InvokeWrapper invokeWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)compileResult, (String)"compileResult");
        return this.evaluator.eval(compileResult, scriptArgs, invokeWrapper);
    }

    @Override
    @NotNull
    public ReplCheckResult check(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        return this.compiler.check(codeLine);
    }

    @Override
    @NotNull
    public Pair<ReplCompileResult, Evaluable> compileToEvaluable(@NotNull ReplCodeLine codeLine, @Nullable ScriptArgsWithTypes defaultScriptArgs, @Nullable List<ReplCodeLine> verifyHistory) {
        Pair pair2;
        ReplCompileResult compiled;
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        ReplCompileResult replCompileResult = compiled = this.compiler.compile(codeLine, verifyHistory);
        if (replCompileResult instanceof ReplCompileResult.CompiledClasses) {
            ReplCompileResult.CompiledClasses compiledClasses = (ReplCompileResult.CompiledClasses)compiled;
            ReplEvaluator replEvaluator = this.evaluator;
            ScriptArgsWithTypes scriptArgsWithTypes = defaultScriptArgs;
            if (scriptArgsWithTypes == null) {
                scriptArgsWithTypes = this.fallbackScriptArgs;
            }
            pair2 = new Pair((Object)compiled, (Object)new DelayedEvaluation(compiledClasses, this.stateLock, replEvaluator, scriptArgsWithTypes));
        } else {
            pair2 = new Pair((Object)compiled, null);
        }
        return pair2;
    }

    @NotNull
    public final ReplCompiler getCompiler() {
        return this.compiler;
    }

    @Nullable
    protected final ScriptArgsWithTypes getFallbackScriptArgs() {
        return this.fallbackScriptArgs;
    }

    @NotNull
    protected final ReentrantReadWriteLock getStateLock() {
        return this.stateLock;
    }

    public GenericReplCompilingEvaluator(@NotNull ReplCompiler compiler, @NotNull Iterable<? extends File> baseClasspath, @Nullable ClassLoader baseClassloader, @Nullable ScriptArgsWithTypes fallbackScriptArgs, @NotNull ReplRepeatingMode repeatingMode, @NotNull ReentrantReadWriteLock stateLock) {
        Intrinsics.checkParameterIsNotNull((Object)compiler, (String)"compiler");
        Intrinsics.checkParameterIsNotNull(baseClasspath, (String)"baseClasspath");
        Intrinsics.checkParameterIsNotNull((Object)((Object)repeatingMode), (String)"repeatingMode");
        Intrinsics.checkParameterIsNotNull((Object)stateLock, (String)"stateLock");
        this.compiler = compiler;
        this.fallbackScriptArgs = fallbackScriptArgs;
        this.stateLock = stateLock;
        this.evaluator = new GenericReplEvaluator(baseClasspath, baseClassloader, this.fallbackScriptArgs, repeatingMode, this.stateLock);
    }

    public /* synthetic */ GenericReplCompilingEvaluator(ReplCompiler replCompiler2, Iterable iterable, ClassLoader classLoader, ScriptArgsWithTypes scriptArgsWithTypes, ReplRepeatingMode replRepeatingMode, ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            scriptArgsWithTypes = null;
        }
        if ((n & 0x10) != 0) {
            replRepeatingMode = ReplRepeatingMode.REPEAT_ONLY_MOST_RECENT;
        }
        if ((n & 0x20) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(replCompiler2, iterable, classLoader, scriptArgsWithTypes, replRepeatingMode, reentrantReadWriteLock);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompilingEvaluator$DelayedEvaluation;", "Lorg/jetbrains/kotlin/cli/common/repl/Evaluable;", "compiledCode", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "evaluator", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;", "defaultScriptArgs", "Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;Ljava/util/concurrent/locks/ReentrantReadWriteLock;Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;)V", "getCompiledCode", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "scriptArgs", "invokeWrapper", "Lorg/jetbrains/kotlin/cli/common/repl/InvokeWrapper;", "cli-common"})
    public static final class DelayedEvaluation
    implements Evaluable {
        @NotNull
        private final ReplCompileResult.CompiledClasses compiledCode;
        private final ReentrantReadWriteLock stateLock;
        private final ReplEvaluator evaluator;
        private final ScriptArgsWithTypes defaultScriptArgs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ReplEvalResult eval(@Nullable ScriptArgsWithTypes scriptArgs, @Nullable InvokeWrapper invokeWrapper) {
            ReplEvalResult replEvalResult;
            int n;
            ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n2 = 0;
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = n3 - 1;
            if (n2 <= n4) {
                do {
                    n = ++n2;
                    readLock.unlock();
                } while (n2 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                ReplCompileResult.CompiledClasses compiledClasses = this.getCompiledCode();
                ScriptArgsWithTypes scriptArgsWithTypes = scriptArgs;
                if (scriptArgsWithTypes == null) {
                    scriptArgsWithTypes = this.defaultScriptArgs;
                }
                replEvalResult = this.evaluator.eval(compiledClasses, scriptArgsWithTypes, invokeWrapper);
            }
            finally {
                n = 0;
                int n5 = n3 - 1;
                if (n <= n5) {
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
            return replEvalResult;
        }

        @Override
        @NotNull
        public ReplCompileResult.CompiledClasses getCompiledCode() {
            return this.compiledCode;
        }

        public DelayedEvaluation(@NotNull ReplCompileResult.CompiledClasses compiledCode, @NotNull ReentrantReadWriteLock stateLock, @NotNull ReplEvaluator evaluator2, @Nullable ScriptArgsWithTypes defaultScriptArgs) {
            Intrinsics.checkParameterIsNotNull((Object)compiledCode, (String)"compiledCode");
            Intrinsics.checkParameterIsNotNull((Object)stateLock, (String)"stateLock");
            Intrinsics.checkParameterIsNotNull((Object)evaluator2, (String)"evaluator");
            this.compiledCode = compiledCode;
            this.stateLock = stateLock;
            this.evaluator = evaluator2;
            this.defaultScriptArgs = defaultScriptArgs;
        }
    }
}

